/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Node;
import graph.ScanString;
import graph.SpecialFunction;
import java.io.Serializable;

public class ParseFunction
extends ScanString
implements Serializable {
    static final int GROUP = 1;
    static final int ENDGROUP = 2;
    static final int ADD = 3;
    static final int SUBTRACT = 4;
    static final int DIVIDE = 5;
    static final int MULTIPLY = 6;
    static final int LOG = 7;
    static final int POWER = 8;
    static final int PI = 9;
    static final int E = 10;
    static final int SIN = 11;
    static final int COS = 12;
    static final int TAN = 13;
    static final int X = 14;
    static final int Y = 15;
    static final int Z = 16;
    static final int ASIN = 17;
    static final int ACOS = 18;
    static final int ATAN = 19;
    static final int RAD = 20;
    static final int SQRT = 21;
    static final int RANDOM = 22;
    static final int LOG10 = 23;
    static final int EXP = 24;
    static final int REMAINDER = 25;
    static final int COMMA = 26;
    static final int ATAN2 = 27;
    static final int J0 = 28;
    static final int J1 = 29;
    static final int JN = 30;
    static final int SINH = 31;
    static final int COSH = 32;
    static final int TANH = 33;
    static final int ASINH = 34;
    static final int ACOSH = 35;
    static final int ATANH = 36;
    static final int Y0 = 37;
    static final int Y1 = 38;
    static final int YN = 39;
    static final int FAC = 40;
    static final int GAMMA = 41;
    static final int ERF = 42;
    static final int ERFC = 43;
    static final int NORMAL = 44;
    static final int POISSONC = 45;
    static final int POISSON = 46;
    static final int CHISQC = 47;
    static final int CHISQ = 48;
    static final int IGAM = 49;
    static final int IGAMC = 50;
    static final int BOLTZMAN = 101;
    static final int ECHARGE = 102;
    static final int EMASS = 103;
    static final int PMASS = 104;
    static final int GRAV = 105;
    static final int PLANCK = 106;
    static final int LIGHTSPEED = 107;
    static final int STEFANBOLTZ = 108;
    static final int AVOGADRO = 109;
    static final int GASCONSTANT = 110;
    static final int GRAVACC = 111;
    private Node root = null;
    private boolean independent_x = false;
    private boolean independent_y = false;
    private boolean independent_z = false;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    public boolean debug = false;

    public ParseFunction() {
        this.addKeyWord(",", 26);
        this.addKeyWord("(", 1);
        this.addKeyWord(")", 2);
        this.addKeyWord("+", 3);
        this.addKeyWord("-", 4);
        this.addKeyWord("/", 5);
        this.addKeyWord("*", 6);
        this.addKeyWord("log", 7);
        this.addKeyWord("^", 8);
        this.addKeyWord("pi", 9);
        this.addKeyWord("e", 10);
        this.addKeyWord("sin", 11);
        this.addKeyWord("cos", 12);
        this.addKeyWord("tan", 13);
        this.addKeyWord("x", 14);
        this.addKeyWord("y", 15);
        this.addKeyWord("z", 16);
        this.addKeyWord("asin", 17);
        this.addKeyWord("acos", 18);
        this.addKeyWord("atan", 19);
        this.addKeyWord("rad", 20);
        this.addKeyWord("sqrt", 21);
        this.addKeyWord("rand", 22);
        this.addKeyWord("log10", 23);
        this.addKeyWord("exp", 24);
        this.addKeyWord("rem", 25);
        this.addKeyWord("atan2", 27);
        this.addKeyWord("j0", 28);
        this.addKeyWord("j1", 29);
        this.addKeyWord("jn", 30);
        this.addKeyWord("sinh", 31);
        this.addKeyWord("cosh", 32);
        this.addKeyWord("tanh", 33);
        this.addKeyWord("asinh", 34);
        this.addKeyWord("acosh", 35);
        this.addKeyWord("atanh", 36);
        this.addKeyWord("y0", 37);
        this.addKeyWord("y1", 38);
        this.addKeyWord("yn", 39);
        this.addKeyWord("fac", 40);
        this.addKeyWord("gamma", 41);
        this.addKeyWord("erf", 42);
        this.addKeyWord("erfc", 43);
        this.addKeyWord("normal", 44);
        this.addKeyWord("poissonc", 45);
        this.addKeyWord("poisson", 46);
        this.addKeyWord("chisq", 48);
        this.addKeyWord("chisqc", 47);
        this.addKeyWord("igam", 49);
        this.addKeyWord("igamc", 50);
        this.addKeyWord("k", 101);
        this.addKeyWord("ec", 102);
        this.addKeyWord("me", 103);
        this.addKeyWord("mp", 104);
        this.addKeyWord("gc", 105);
        this.addKeyWord("h", 106);
        this.addKeyWord("c", 107);
        this.addKeyWord("sigma", 108);
        this.addKeyWord("na", 109);
        this.addKeyWord("r", 110);
        this.addKeyWord("g", 111);
    }

    public ParseFunction(String s) {
        this();
        this.setString(s);
    }

    public boolean parse(String s) {
        this.setString(s);
        return this.parse();
    }

    public boolean parse() {
        this.root = new Node();
        if (this.parseString(this.root) != -259) {
            return false;
        }
        if (this.debug) {
            System.out.println("Before Reordering:");
            this.root.print(5);
        }
        this.reOrderNodes(this.root);
        if (this.debug) {
            System.out.println("After Reordering:");
            this.root.print(5);
        }
        return true;
    }

    public double getResult(double x, double y, double z) throws Exception {
        this.x = x;
        this.y = y;
        this.z = z;
        return this.evaluate(this.root);
    }

    public double getResult(double x, double y) throws Exception {
        this.x = x;
        this.y = y;
        return this.evaluate(this.root);
    }

    public double getResult(double x) throws Exception {
        this.x = x;
        return this.evaluate(this.root);
    }

    public double getResult() throws Exception {
        return this.evaluate(this.root);
    }

    public double[] getResults(int n, double[] x) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (x == null) {
            throw new Exception("X Array error");
        }
        double[] array = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x = x[i];
            array[i] = this.evaluate(this.root);
        }
        return array;
    }

    public double[] getResults(int n, double[] x, double[] y) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (x == null) {
            throw new Exception("X Array error");
        }
        if (y == null) {
            throw new Exception("Y Array error");
        }
        double[] array = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x = x[i];
            this.y = y[i];
            array[i] = this.evaluate(this.root);
        }
        return array;
    }

    public double[] getResults(int n, double[] x, double[] y, double[] z) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (x == null) {
            throw new Exception("X Array error");
        }
        if (y == null) {
            throw new Exception("Y Array error");
        }
        if (z == null) {
            throw new Exception("Z Array error");
        }
        double[] array = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x = x[i];
            this.y = y[i];
            this.z = z[i];
            array[i] = this.evaluate(this.root);
        }
        return array;
    }

    public boolean[] getVariables() {
        boolean[] b = new boolean[]{this.independent_x, this.independent_y, this.independent_z};
        return b;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setIndepVariables(boolean ix, boolean iy, boolean iz) {
        this.independent_x = ix;
        this.independent_y = iy;
        this.independent_z = iz;
    }

    private int parseString(Node node) {
        int token = this.nextWord();
        if (token == -257) {
            System.out.println("Error parsing \"" + this.sval + "\"");
            return -257;
        }
        if (token != -259 && this.debug) {
            System.out.println("Parse: " + this.sval + "\t Token: " + token);
        } else if (token == -259 && this.debug) {
            System.out.println("Parse: EOS");
        }
        switch (token) {
            case -258: {
                node.type = 1;
                node.value = this.nval;
                return this.parseString(node);
            }
            case 9: {
                node.type = 1;
                node.value = Math.PI;
                return this.parseString(node);
            }
            case 10: {
                node.type = 1;
                node.value = Math.E;
                return this.parseString(node);
            }
            case 101: {
                node.type = 1;
                node.value = 1.3807E-16;
                return this.parseString(node);
            }
            case 102: {
                node.type = 1;
                node.value = 4.8032E-10;
                return this.parseString(node);
            }
            case 103: {
                node.type = 1;
                node.value = 9.1095E-28;
                return this.parseString(node);
            }
            case 104: {
                node.type = 1;
                node.value = 1.6726E-24;
                return this.parseString(node);
            }
            case 105: {
                node.type = 1;
                node.value = 6.672E-8;
                return this.parseString(node);
            }
            case 106: {
                node.type = 1;
                node.value = 6.6262E-27;
                return this.parseString(node);
            }
            case 107: {
                node.type = 1;
                node.value = 2.9979E10;
                return this.parseString(node);
            }
            case 108: {
                node.type = 1;
                node.value = 5.6703E-5;
                return this.parseString(node);
            }
            case 109: {
                node.type = 1;
                node.value = 6.022E23;
                return this.parseString(node);
            }
            case 110: {
                node.type = 1;
                node.value = 8.3144E7;
                return this.parseString(node);
            }
            case 111: {
                node.type = 1;
                node.value = 980.67;
                return this.parseString(node);
            }
            case 20: {
                node.type = 1;
                node.value = Math.PI / 180;
                return this.parseString(node);
            }
            case 22: {
                node.type = 1;
                node.value = Math.random();
                return this.parseString(node);
            }
            case 14: 
            case 15: 
            case 16: {
                node.op = token;
                node.type = 4;
                if (token == 14) {
                    this.independent_x = true;
                } else if (token == 15) {
                    this.independent_y = true;
                } else if (token == 16) {
                    this.independent_z = true;
                }
                return this.parseString(node);
            }
            case -259: 
            case 2: 
            case 26: {
                break;
            }
            case 1: {
                Node left = new Node();
                if (this.parseString(left) == 2) {
                    node.left = left;
                    node.type = 5;
                    node.precedence = 5;
                    token = this.parseString(node);
                    break;
                }
                System.out.println("Parse Failed: missing parentheses");
                token = -257;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                Node right = new Node();
                int t = this.parseString(right);
                if (t != -257) {
                    if ((token == 4 || token == 3) && node.type == 3) {
                        node.right = right;
                        node.precedence = 4;
                        node.op = token;
                        node.type = 0;
                    } else {
                        Node left;
                        node.left = left = new Node(node);
                        node.right = right;
                        node.op = token;
                        node.type = 0;
                        switch (token) {
                            case 3: 
                            case 4: {
                                node.precedence = 1;
                                break;
                            }
                            case 5: 
                            case 6: {
                                node.precedence = 2;
                                break;
                            }
                            case 8: {
                                node.precedence = 3;
                            }
                        }
                    }
                }
                token = t;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                node.op = token;
                node.type = 2;
                node.precedence = 0;
                token = this.nextWord();
                if (token != 1) {
                    System.out.println("Parse Failed: intrinsic function is missing \"(\"");
                    token = -257;
                    break;
                }
                Node left = new Node();
                if (this.parseString(left) == 2) {
                    node.left = left;
                    token = this.parseString(node);
                    break;
                }
                System.out.println("Parse Failed: intrinsic function is missing \")\"");
                token = -257;
                break;
            }
            case 27: 
            case 30: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                node.op = token;
                node.type = 2;
                node.precedence = 0;
                token = this.nextWord();
                if (this.debug) {
                    System.out.println("Parse: " + this.sval);
                }
                if (token != 1) {
                    System.out.println("Parse Failed: intrinsic function is missing \"(\"");
                    token = -257;
                    break;
                }
                Node param1 = new Node();
                if (this.parseString(param1) == 26) {
                    Node param2 = new Node();
                    if (this.parseString(param2) == 2) {
                        node.right = param2;
                        node.left = param1;
                        token = this.parseString(node);
                        break;
                    }
                    System.out.println("Parse Failed: intrinsic function is missing \")\"");
                    token = -257;
                    break;
                }
                System.out.println("Parse Failed: intrinsic function is missing \",\"");
                token = -257;
                break;
            }
        }
        return token;
    }

    private double evaluate(Node node) throws Exception {
        double value = 0.0;
        if (node == null) {
            throw new Exception("evaluate: Failed because of null node!");
        }
        switch (node.type) {
            case 5: {
                value = this.evaluate(node.left);
                break;
            }
            case 0: {
                value = this.evaluateOp(node);
                break;
            }
            case 2: {
                value = this.evaluateIntrinsic(node);
                break;
            }
            case 1: {
                value = node.value;
                break;
            }
            case 4: {
                if (node.op == 14) {
                    value = this.x;
                    break;
                }
                if (node.op == 15) {
                    value = this.y;
                    break;
                }
                if (node.op != 16) break;
                value = this.z;
                break;
            }
            default: {
                throw new Exception("evaluate: Unknown type!");
            }
        }
        return value;
    }

    private double evaluateOp(Node node) throws Exception {
        double value = 0.0;
        switch (node.op) {
            case 3: {
                if (node.left != null) {
                    value = this.evaluate(node.left);
                }
                value += this.evaluate(node.right);
                break;
            }
            case 4: {
                if (node.left != null) {
                    value = this.evaluate(node.left);
                }
                value -= this.evaluate(node.right);
                break;
            }
            case 5: {
                value = this.evaluate(node.left);
                value /= this.evaluate(node.right);
                break;
            }
            case 6: {
                value = this.evaluate(node.left);
                value *= this.evaluate(node.right);
                break;
            }
            case 8: {
                value = Math.pow(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            default: {
                throw new Exception("evaluate: Failed because of Unknown operator!");
            }
        }
        return value;
    }

    private double evaluateIntrinsic(Node node) throws Exception {
        double value = 0.0;
        switch (node.op) {
            case 11: {
                value = Math.sin(this.evaluate(node.left));
                break;
            }
            case 12: {
                value = Math.cos(this.evaluate(node.left));
                break;
            }
            case 13: {
                value = Math.tan(this.evaluate(node.left));
                break;
            }
            case 17: {
                value = Math.asin(this.evaluate(node.left));
                break;
            }
            case 18: {
                value = Math.acos(this.evaluate(node.left));
                break;
            }
            case 19: {
                value = Math.atan(this.evaluate(node.left));
                break;
            }
            case 7: {
                value = Math.log(this.evaluate(node.left));
                break;
            }
            case 21: {
                value = Math.sqrt(this.evaluate(node.left));
                break;
            }
            case 23: {
                value = Math.log(this.evaluate(node.left)) / Math.E;
            }
            case 24: {
                value = Math.exp(this.evaluate(node.left));
                break;
            }
            case 28: {
                value = SpecialFunction.j0(this.evaluate(node.left));
                break;
            }
            case 29: {
                value = SpecialFunction.j1(this.evaluate(node.left));
                break;
            }
            case 37: {
                value = SpecialFunction.y0(this.evaluate(node.left));
                break;
            }
            case 38: {
                value = SpecialFunction.y1(this.evaluate(node.left));
                break;
            }
            case 40: {
                value = SpecialFunction.fac(this.evaluate(node.left));
                break;
            }
            case 41: {
                value = SpecialFunction.gamma(this.evaluate(node.left));
                break;
            }
            case 31: {
                value = SpecialFunction.sinh(this.evaluate(node.left));
                break;
            }
            case 32: {
                value = SpecialFunction.cosh(this.evaluate(node.left));
                break;
            }
            case 33: {
                value = SpecialFunction.tanh(this.evaluate(node.left));
                break;
            }
            case 34: {
                value = SpecialFunction.asinh(this.evaluate(node.left));
                break;
            }
            case 35: {
                value = SpecialFunction.acosh(this.evaluate(node.left));
                break;
            }
            case 36: {
                value = SpecialFunction.atanh(this.evaluate(node.left));
                break;
            }
            case 42: {
                value = SpecialFunction.erf(this.evaluate(node.left));
                break;
            }
            case 43: {
                value = SpecialFunction.erfc(this.evaluate(node.left));
                break;
            }
            case 44: {
                value = SpecialFunction.normal(this.evaluate(node.left));
                break;
            }
            case 46: {
                value = SpecialFunction.poisson((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 45: {
                value = SpecialFunction.poissonc((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 48: {
                value = SpecialFunction.chisq(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 47: {
                value = SpecialFunction.chisqc(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 49: {
                value = SpecialFunction.igam(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 50: {
                value = SpecialFunction.igamc(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 27: {
                value = Math.atan2(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 30: {
                value = SpecialFunction.jn((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 39: {
                value = SpecialFunction.yn((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            default: {
                throw new Exception("evaluate: Failed because of an unknown intrinsic!");
            }
        }
        return value;
    }

    private void reOrderNodes(Node node) {
        Node right = null;
        Node left = null;
        if (node == null) {
            return;
        }
        right = node.right;
        left = node.left;
        if (right != null && right.type == 5) {
            this.reOrderNodes(right);
        } else if (left != null && left.type == 5) {
            this.reOrderNodes(left);
        }
        if (node.type == 5) {
            this.reOrderNodes(left);
        } else if (node.type == 0 && right.type == 0 && node.precedence >= right.precedence) {
            Node newnode = new Node(node);
            newnode.right = right.left;
            node.replace(right);
            node.left = newnode;
            right = null;
            this.reOrderNodes(node);
        }
    }
}

