/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.tokenizer;

import java.text.BreakIterator;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.AbstractWordTokenizer;
import org.dts.spell.tokenizer.CharIteratorAdapter;

public class DefaultWordTokenizer
extends AbstractWordTokenizer {
    private BreakIterator wordIterator;
    private CharIteratorAdapter wordSequence = new CharIteratorAdapter();

    public DefaultWordTokenizer() {
        this(BreakIterator.getWordInstance());
    }

    public DefaultWordTokenizer(BreakIterator wordIterator) {
        this.wordIterator = wordIterator;
    }

    protected Word scanBefore(CharSequence sequence, int index) {
        String text;
        int start = this.wordIterator.preceding(index);
        int end2 = this.wordIterator.next();
        if (start == -1) {
            start = 0;
        }
        if (!(text = sequence.subSequence(start, end2).toString().trim()).equals("")) {
            return new Word(text, start, this.isStartOfSentence(sequence, start));
        }
        return null;
    }

    protected Word scanAfter(CharSequence sequence, int index) {
        String text;
        int end2 = this.wordIterator.following(index);
        int start = this.wordIterator.previous();
        if (end2 == -1) {
            end2 = sequence.length() - 1;
        }
        if (!(text = sequence.subSequence(start, end2).toString().trim()).equals("")) {
            return new Word(text, start, this.isStartOfSentence(sequence, start));
        }
        return null;
    }

    @Override
    public Word currentWord(int index) {
        CharSequence sequence = this.getCharSequence();
        int length = sequence.length();
        Word result = null;
        if (length > 0 && length >= index) {
            result = index == length ? this.scanBefore(sequence, index - 1) : (this.wordIterator.isBoundary(index) && Character.isWhitespace(sequence.charAt(index)) ? this.scanBefore(sequence, index) : this.scanAfter(sequence, index));
        }
        return result;
    }

    private void onChangeSequence() {
        CharSequence sequence = this.getCharSequence();
        this.wordSequence.setCharSequence(sequence);
        this.wordIterator.setText(this.wordSequence);
    }

    private void onInsertChars(int start, int end2) {
        this.onChangeSequence();
    }

    private void onDeleteChars(int start, int end2) {
        this.onChangeSequence();
    }

    @Override
    public void updateCharSequence(int start, int end2, int cause) {
        switch (cause) {
            case 2: {
                this.onChangeSequence();
                break;
            }
            case 0: {
                this.onInsertChars(start, end2);
                break;
            }
            case 1: {
                this.onDeleteChars(start, end2);
            }
        }
    }
}

