/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import javax.swing.text.Highlighter;
import org.dts.spell.swing.utils.HighlightUtils;

public class TagList {
    private TagNode first;
    private TagNode last;
    private TagNode current;

    public TagList() {
        this.clear();
    }

    public boolean isEmpty() {
        return null == this.first;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.current = null;
    }

    private TagNode findTagNodeDesc(int index, boolean returnNext) {
        Highlighter.Highlight curTag = this.current.getTag();
        TagNode aux = this.current;
        TagNode prev = aux.getPrevious();
        boolean exit = false;
        while (null != prev && !exit) {
            curTag = prev.getTag();
            if (HighlightUtils.isMinorOrEquals(curTag, index)) {
                exit = true;
                continue;
            }
            aux = prev;
            prev = aux.getPrevious();
        }
        if (returnNext) {
            return aux;
        }
        return prev;
    }

    private TagNode findTagNodeAsc(int index, boolean returnNext) {
        Highlighter.Highlight curTag = this.current.getTag();
        TagNode aux = this.current;
        TagNode next = aux.getNext();
        boolean exit = false;
        while (null != next && !exit) {
            curTag = next.getTag();
            if (HighlightUtils.isMajor(curTag, index)) {
                exit = true;
                continue;
            }
            aux = next;
            next = aux.getNext();
        }
        if (returnNext) {
            return next;
        }
        return aux;
    }

    private TagNode findTagNode(Highlighter.Highlight tag) {
        Highlighter.Highlight curTag = this.current.getTag();
        if (tag == curTag) {
            return this.current;
        }
        TagNode node = HighlightUtils.isMinor(tag, curTag) ? this.findTagNodeDesc(tag.getStartOffset(), true) : this.findTagNodeAsc(tag.getEndOffset(), false);
        if (node.getTag() == tag) {
            return node;
        }
        return null;
    }

    private TagNode findPreviousNode(int index) {
        TagNode result;
        for (result = HighlightUtils.isMajorOrEquals(this.current.getTag(), index) ? this.findTagNodeDesc(index, false) : this.findTagNodeAsc(index, false); null != result && HighlightUtils.isNullRange(result.getTag()); result = result.getPrevious()) {
        }
        return result;
    }

    public void add(Object tag) {
        this.add((Highlighter.Highlight)tag);
    }

    private void add(Highlighter.Highlight tag) {
        if (this.current != null) {
            Highlighter.Highlight curTag = this.current.getTag();
            TagNode node = HighlightUtils.isMinor(curTag, tag) ? this.findTagNodeAsc(tag.getStartOffset(), true) : this.findTagNodeDesc(tag.getStartOffset(), true);
            if (node == this.first) {
                this.current = new TagNode(tag, this.first);
                this.first.setPrevious(this.current);
                this.first = this.current;
            } else if (null == node) {
                this.current = new TagNode(tag, this.last, null);
                this.last.setNext(this.current);
                this.last = this.current;
            } else {
                this.current = new TagNode(tag, node.getPrevious(), node);
                this.current.getPrevious().setNext(this.current);
                node.setPrevious(this.current);
            }
        } else {
            this.last = this.first = new TagNode(tag);
            this.current = this.first;
        }
    }

    public void remove(Object tag) {
        this.remove((Highlighter.Highlight)tag);
    }

    private void remove(Highlighter.Highlight tag) {
        TagNode node;
        if (!this.isEmpty() && null != (node = this.findTagNode(tag))) {
            if (this.first == node) {
                if (this.last != node) {
                    this.first = node.getNext();
                    this.first.setPrevious(null);
                    this.current = this.first;
                } else {
                    this.first = null;
                    this.last = null;
                    this.current = null;
                }
            } else if (this.last == node) {
                this.last = node.getPrevious();
                this.last.setNext(null);
                this.current = this.last;
            } else {
                TagNode prev = node.getPrevious();
                prev.setNext(node.getNext());
                node.getNext().setPrevious(prev);
                this.current = prev;
            }
        }
    }

    private boolean isInside(int beginPos, int endPos) {
        if (this.isEmpty()) {
            return false;
        }
        return this.first.getTag().getStartOffset() <= endPos && this.last.getTag().getEndOffset() >= beginPos;
    }

    public void removeAll(Highlighter highlighter) {
        while (null != this.first) {
            highlighter.removeHighlight(this.first.getTag());
            this.first = this.first.getNext();
        }
        this.last = null;
        this.current = null;
    }

    private TagNode removeNullRange(TagNode begin, Highlighter highlighter) {
        while (null != begin && HighlightUtils.isNullRange(begin.getTag())) {
            highlighter.removeHighlight(begin.getTag());
            begin = begin.getNext();
        }
        return begin;
    }

    private TagNode removeRangeTo(TagNode begin, Highlighter highlighter, int endPos) {
        while (null != begin && HighlightUtils.isMinorOrEquals(begin.getTag(), endPos)) {
            highlighter.removeHighlight(begin.getTag());
            begin = begin.getNext();
        }
        return begin;
    }

    public void removeRange(int beginPos, int endPos, Highlighter highlighter) {
        if (this.isInside(beginPos, endPos)) {
            if (HighlightUtils.isMajorOrEquals(this.first.getTag(), beginPos) && HighlightUtils.isMinorOrEquals(this.last.getTag(), endPos)) {
                this.removeAll(highlighter);
            } else {
                TagNode next;
                TagNode prev = this.findPreviousNode(beginPos);
                if (null == prev) {
                    if (HighlightUtils.isInside(this.first.getTag(), beginPos - 1)) {
                        next = this.removeRangeTo(this.first.getNext(), highlighter, endPos);
                        prev = this.first;
                    } else {
                        this.first = next = this.removeRangeTo(this.first, highlighter, endPos);
                        this.first.setPrevious(null);
                        prev = next;
                        next = prev.getNext();
                    }
                } else {
                    next = this.removeRangeTo(prev.getNext(), highlighter, endPos);
                }
                if (null != next) {
                    prev.setNext(next);
                    next.setPrevious(prev);
                } else {
                    this.last = prev;
                    prev.setNext(null);
                }
                this.current = prev;
            }
        }
    }

    public void removeNullRanges(int beginPos, int endPos, Highlighter highlighter) {
        if (this.isInside(beginPos, endPos)) {
            if (HighlightUtils.isMajorOrEquals(this.first.getTag(), beginPos) && HighlightUtils.isMinorOrEquals(this.last.getTag(), endPos)) {
                this.removeAll(highlighter);
            } else {
                TagNode next;
                TagNode prev = this.findPreviousNode(beginPos);
                if (null == prev) {
                    if (HighlightUtils.isInside(this.first.getTag(), beginPos - 1)) {
                        next = this.removeNullRange(this.first.getNext(), highlighter);
                        prev = this.first;
                    } else {
                        this.first = next = this.removeNullRange(this.first, highlighter);
                        this.first.setPrevious(null);
                        prev = next;
                        next = prev.getNext();
                    }
                } else {
                    next = this.removeNullRange(prev.getNext(), highlighter);
                }
                if (null != next) {
                    prev.setNext(next);
                    next.setPrevious(prev);
                } else {
                    this.last = prev;
                    prev.setNext(null);
                }
                this.current = prev;
            }
        }
    }

    public void updateCurrent(int curPos) {
        if (!this.isEmpty()) {
            if (HighlightUtils.isMajor(this.first.getTag(), curPos)) {
                this.current = this.first;
            } else if (HighlightUtils.isMinor(this.last.getTag(), curPos)) {
                this.current = this.last;
            } else {
                this.current = this.findPreviousNode(curPos);
                if (null == this.current) {
                    this.current = this.first;
                }
            }
        }
    }

    public String toString() {
        String result = "";
        for (TagNode aux = this.first; aux != null; aux = aux.getNext()) {
            result = result + aux + "\n";
        }
        result = result + "Current = " + this.current;
        return result;
    }

    private static class TagNode {
        private TagNode next;
        private TagNode prev;
        private Highlighter.Highlight tag;

        public TagNode(Highlighter.Highlight tag) {
            this(tag, null, null);
        }

        public TagNode(Highlighter.Highlight tag, TagNode next) {
            this(tag, null, next);
        }

        public TagNode(Highlighter.Highlight tag, TagNode previous, TagNode next) {
            this.tag = tag;
            this.setNext(next);
            this.setPrevious(previous);
        }

        public TagNode getNext() {
            return this.next;
        }

        public void setNext(TagNode node) {
            this.next = node;
        }

        public TagNode getPrevious() {
            return this.prev;
        }

        public void setPrevious(TagNode node) {
            this.prev = node;
        }

        public Highlighter.Highlight getTag() {
            return this.tag;
        }

        public String toString() {
            return "(" + this.tag.getStartOffset() + "," + this.tag.getEndOffset() + ")";
        }
    }
}

