/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.finder;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.dts.spell.swing.finder.DocumentFixedCharSequence;

public class DocumentCharSequence
implements CharSequence {
    private Document document;

    public DocumentCharSequence() {
        this(null);
    }

    public DocumentCharSequence(Document doc) {
        this.document = doc;
    }

    @Override
    public int length() {
        if (null == this.document) {
            return 0;
        }
        return this.document.getLength();
    }

    @Override
    public char charAt(int index) {
        try {
            return this.document.getText(index, 1).charAt(0);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    @Override
    public CharSequence subSequence(int start, int end2) {
        return new DocumentFixedCharSequence(this.document, start, end2);
    }

    @Override
    public String toString() {
        try {
            if (null != this.document) {
                return this.document.getText(0, this.length());
            }
            return "";
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }
}

