/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellCheckerListener
extends SpellCheckAdapter {
    private ErrorMarker errorMarker;

    public RealTimeSpellCheckerListener(JTextComponent textComponent) {
        this.errorMarker = new ErrorMarker(textComponent, false);
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        this.markError(event);
    }

    @Override
    public void badCaseError(SpellCheckEvent event) {
        this.markError(event);
    }

    @Override
    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event);
    }

    private void markError(SpellCheckEvent event) {
        final Word badWord = event.getCurrentWord();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        RealTimeSpellCheckerListener.this.errorMarker.markError(badWord.getStart(), badWord.getEnd());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beginChecking(SpellCheckEvent event) {
        SynchronizedWordFinder finder = (SynchronizedWordFinder)event.getWordFinder();
        final TextRange textRange = finder.getTextRange();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RealTimeSpellCheckerListener.this.errorMarker.unMarkRange(textRange.getBegin(), textRange.getEnd());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanAllErrors() {
        this.errorMarker.quitTextComponent();
    }
}

