/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.SpellChecker;
import org.dts.spell.swing.event.RealTimeSpellCheckerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellChecker
implements DocumentListener,
Runnable {
    private SpellChecker spellChecker;
    private JTextComponent textComponent;
    private SynchronizedWordFinder finder;
    private List<TextRange> textRanges = new LinkedList<TextRange>();
    private boolean stopThread;

    public RealTimeSpellChecker(SpellChecker checker, JTextComponent textComponent, DocumentWordFinder finder) {
        this.spellChecker = checker;
        this.textComponent = textComponent;
        this.finder = new SynchronizedWordFinder(finder);
    }

    public void start() {
        Document doc = this.textComponent.getDocument();
        doc.addDocumentListener(this);
        this.textRanges.add(new TextRange(doc.getStartPosition(), doc.getEndPosition()));
        this.stopThread = false;
        Thread th = new Thread(this);
        th.setPriority(1);
        th.start();
    }

    public synchronized void stop() {
        this.textComponent.getDocument().removeDocumentListener(this);
        this.stopThread = true;
        this.notify();
    }

    public synchronized void addTextRange(DocumentEvent e) {
        try {
            if (this.textRanges.size() > 0) {
                TextRange oldTextRange = this.textRanges.get(this.textRanges.size() - 1);
                TextRange newTextRange = oldTextRange.compactWith(e);
                if (null != newTextRange) {
                    this.textRanges.add(newTextRange);
                }
            } else {
                this.textRanges.add(new TextRange(e));
            }
            if (this.textRanges.size() > 0) {
                this.notify();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public DocumentWordFinder getDocumentWordFinder() {
        return this.finder.getWrapDocumentFinder();
    }

    private void checkRange(TextRange range, RealTimeSpellCheckerListener listener) {
        this.finder.setTextRange(range);
        this.spellChecker.check(this.finder, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RealTimeSpellCheckerListener listener = new RealTimeSpellCheckerListener(this.textComponent);
        block5: while (true) {
            try {
                while (true) {
                    TextRange range;
                    RealTimeSpellChecker realTimeSpellChecker = this;
                    synchronized (realTimeSpellChecker) {
                        if (this.textRanges.isEmpty()) {
                            this.wait();
                        }
                        if (this.stopThread) {
                            break block5;
                        }
                        range = this.textRanges.remove(0);
                    }
                    this.checkRange(range, listener);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        listener.cleanAllErrors();
    }
}

