/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.dts.spell.dictionary.myspell.AffEntry;
import org.dts.spell.dictionary.myspell.GuessWord;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.MapEntry;
import org.dts.spell.dictionary.myspell.PfxEntry;
import org.dts.spell.dictionary.myspell.ReplEntry;
import org.dts.spell.dictionary.myspell.SfxEntry;
import org.dts.spell.dictionary.myspell.Utils;

public class AffixMgr {
    private AffEntry[] pStart = new AffEntry[Utils.SETSIZE];
    private AffEntry[] sStart = new AffEntry[Utils.SETSIZE];
    private AffEntry[] pFlag = new AffEntry[Utils.SETSIZE];
    private AffEntry[] sFlag = new AffEntry[Utils.SETSIZE];
    private HashMap<String, HEntry> pHMgr;
    private String trystring = null;
    private String encoding = null;
    private String compound = null;
    private int cpdmin = 3;
    private ReplEntry[] reptable = null;
    private MapEntry[] maptable = null;
    private boolean nosplitsugs = false;

    public AffixMgr(InputStream affStream, String encoding, HashMap<String, HEntry> ptr) throws IOException {
        this.pHMgr = ptr;
        this.parse_file(affStream, encoding);
    }

    public HEntry affix_check(String word) {
        HEntry rv = null;
        rv = this.prefix_check(word);
        if (rv != null) {
            return rv;
        }
        rv = this.suffix_check(word, 0, null);
        return rv;
    }

    public HEntry prefix_check(String word) {
        HEntry rv = null;
        for (PfxEntry pe = (PfxEntry)this.pStart[0]; pe != null; pe = pe.getNext()) {
            rv = pe.check(word);
            if (rv == null) continue;
            return rv;
        }
        int sp = 0;
        PfxEntry pptr = (PfxEntry)this.pStart[word.charAt(sp)];
        while (pptr != null) {
            if (Utils.isSubset(pptr.getKey(), word)) {
                rv = pptr.check(word);
                if (rv != null) {
                    return rv;
                }
                pptr = pptr.getNextEQ();
                continue;
            }
            pptr = pptr.getNextNE();
        }
        return null;
    }

    public HEntry suffix_check(String word, int sfxopts, AffEntry ppfx) {
        HEntry rv = null;
        for (SfxEntry se = (SfxEntry)this.sStart[0]; se != null; se = se.getNext()) {
            rv = se.check(word, sfxopts, ppfx);
            if (rv == null) continue;
            return rv;
        }
        String tmpword = Utils.myRevStrDup(word);
        char sp = tmpword.charAt(0);
        SfxEntry sptr = (SfxEntry)this.sStart[sp];
        while (sptr != null) {
            if (Utils.isSubset(sptr.getKey(), tmpword)) {
                rv = sptr.check(word, sfxopts, ppfx);
                if (rv != null) {
                    return rv;
                }
                sptr = sptr.getNextEQ();
                continue;
            }
            sptr = sptr.getNextNE();
        }
        return null;
    }

    public List<GuessWord> expand_rootword(String ts, String ap) {
        int al = ap.length();
        LinkedList<GuessWord> wlst = new LinkedList<GuessWord>();
        wlst.add(new GuessWord(ts, false));
        for (int i = 0; i < al; ++i) {
            char c = ap.charAt(i);
            for (SfxEntry sptr = (SfxEntry)this.sFlag[c]; sptr != null; sptr = sptr.getFlgNxt()) {
                String newword = sptr.add(ts);
                if (newword == null) continue;
                wlst.add(new GuessWord(newword, sptr.allowCross()));
            }
        }
        int n = wlst.size();
        Iterator it = wlst.iterator();
        it.next();
        for (int j = 1; j < n; ++j) {
            GuessWord wlstJ = (GuessWord)it.next();
            if (!wlstJ.allow) continue;
            for (int k = 0; k < al; ++k) {
                char c = ap.charAt(k);
                for (PfxEntry cptr = (PfxEntry)this.pFlag[c]; cptr != null; cptr = cptr.getFlgNxt()) {
                    String newword;
                    if (!cptr.allowCross() || (newword = cptr.add(wlstJ.word)) == null) continue;
                    wlst.add(new GuessWord(newword, cptr.allowCross()));
                }
            }
        }
        for (int m = 0; m < al; ++m) {
            char c = ap.charAt(m);
            for (PfxEntry ptr = (PfxEntry)this.pFlag[c]; ptr != null; ptr = ptr.getFlgNxt()) {
                String newword = ptr.add(ts);
                if (newword == null) continue;
                wlst.add(new GuessWord(newword, ptr.allowCross()));
            }
        }
        return wlst;
    }

    public HEntry compound_check(String word, char compound_flag) {
        int len = word.length();
        HEntry rv = null;
        if (len < this.cpdmin) {
            return null;
        }
        for (int i = this.cpdmin; i < len - (this.cpdmin - 1); ++i) {
            String st = word.substring(0, i);
            rv = this.lookup(st);
            if (rv == null) {
                rv = this.affix_check(st);
            }
            if (rv == null || !Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) continue;
            String wordI = word.substring(i, word.length());
            rv = this.lookup(wordI);
            if (rv != null && Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) {
                return rv;
            }
            rv = this.affix_check(wordI);
            if (rv != null && Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) {
                return rv;
            }
            rv = this.compound_check(wordI, compound_flag);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public HEntry lookup(String word) {
        if (this.pHMgr == null) {
            return null;
        }
        return this.pHMgr.get(word);
    }

    public int get_numrep() {
        if (this.reptable != null) {
            return this.reptable.length;
        }
        return 0;
    }

    public ReplEntry[] get_reptable() {
        return this.reptable;
    }

    public int get_nummap() {
        if (this.maptable != null) {
            return this.maptable.length;
        }
        return 0;
    }

    public MapEntry[] get_maptable() {
        return this.maptable;
    }

    public String get_encoding() {
        if (this.encoding == null) {
            this.encoding = "ISO8859-1";
        }
        return this.encoding;
    }

    public String get_try_string() {
        return this.trystring;
    }

    public String get_compound() {
        return this.compound;
    }

    public boolean get_nosplitsugs() {
        return this.nosplitsugs;
    }

    public static String readEncoding(String affpath) throws IOException {
        String string;
        FileInputStream rd = null;
        try {
            rd = new FileInputStream(affpath);
            string = AffixMgr.readEncoding(rd);
        }
        catch (Throwable throwable) {
            Utils.close(rd);
            throw throwable;
        }
        Utils.close(rd);
        return string;
    }

    public static String readEncoding(InputStream affStream) throws IOException {
        StringBuilder builder = new StringBuilder(20);
        int r = affStream.read();
        while (-1 != r && 10 != r) {
            builder.append((char)r);
            r = affStream.read();
        }
        return AffixMgr.parseEncoding(builder.toString());
    }

    private void parse_file(InputStream affStream, String encoding) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(affStream, encoding));
        this.encoding = encoding;
        while ((line = rd.readLine()) != null) {
            if (line.startsWith("PFX")) {
                this.parse_affix(line, 'P', rd);
                continue;
            }
            if (line.startsWith("SFX")) {
                this.parse_affix(line, 'S', rd);
                continue;
            }
            if (line.startsWith("TRY")) {
                this.parse_try(line);
                continue;
            }
            if (line.startsWith("SET")) {
                this.parse_set(line);
                continue;
            }
            if (line.startsWith("COMPOUNDFLAG")) {
                this.parse_cpdflag(line);
                continue;
            }
            if (line.startsWith("COMPOUNDMIN")) {
                this.parse_cpdmin(line);
                continue;
            }
            if (line.startsWith("REP")) {
                this.parse_reptable(line, rd);
                continue;
            }
            if (line.startsWith("MAP")) {
                this.parse_maptable(line, rd);
                continue;
            }
            if (!line.startsWith("NOSPLITSUGS")) continue;
            this.nosplitsugs = true;
        }
        this.process_pfx_order();
        this.process_sfx_order();
    }

    private void parse_try(String line) throws IOException {
        if (this.trystring != null) {
            throw new IOException(Utils.getString("ERROR_DUPLICATE_TRY"));
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.trystring = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_TRY"));
        }
    }

    private static String parseEncoding(String line) throws IOException {
        if (line == null) {
            throw new IOException(Utils.getString("ERROR_MISSING_SET"));
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        String result = null;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    result = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_SET"));
        }
        return result;
    }

    private void parse_set(String line) throws IOException {
        if (this.encoding != null) {
            throw new IOException(Utils.getString("ERROR_DUPLICATE_SET"));
        }
        this.encoding = AffixMgr.parseEncoding(line);
    }

    private void parse_cpdflag(String line) throws IOException {
        if (this.compound != null) {
            throw new IOException(Utils.getString("ERROR_DUPLICATE_COMPOUND_FLAGS"));
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.compound = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_COMPOUND_FLAG"));
        }
    }

    private void parse_cpdmin(String line) throws IOException {
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.cpdmin = Integer.parseInt(piece);
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_COMPOUND_MIN"));
        }
        if (this.cpdmin < 1 || this.cpdmin > 50) {
            this.cpdmin = 3;
        }
    }

    private void parse_reptable(String line, BufferedReader af) throws IOException {
        String piece;
        int numrep = this.get_numrep();
        if (numrep != 0) {
            throw new IOException(Utils.getString("ERROR_DUPLICATE_REP"));
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    numrep = Integer.parseInt(piece);
                    if (numrep < 1) {
                        throw new IOException(Utils.getString("INCORRECT_NUMBER_OF_ENTRIES_REP_TABLE"));
                    }
                    this.reptable = new ReplEntry[numrep];
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_REP_TABLE"));
        }
        for (int j = 0; j < numrep; ++j) {
            tp = new StringTokenizer(af.readLine(), " ");
            i = 0;
            this.reptable[j] = new ReplEntry();
            this.reptable[j].pattern = null;
            this.reptable[j].replacement = null;
            while (tp.hasMoreTokens()) {
                piece = tp.nextToken();
                if (piece.length() == 0) continue;
                switch (i) {
                    case 0: {
                        if (piece.startsWith("REP")) break;
                        throw new IOException(Utils.getString("ERROR_REP_TABLE_CORRUPT"));
                    }
                    case 1: {
                        this.reptable[j].pattern = piece;
                        break;
                    }
                    case 2: {
                        this.reptable[j].replacement = piece;
                        break;
                    }
                }
                ++i;
            }
            if (this.reptable[j].pattern != null && this.reptable[j].replacement != null) continue;
            throw new IOException(Utils.getString("ERROR_REP_TABLE_CORRUPT"));
        }
    }

    private void parse_maptable(String line, BufferedReader af) throws IOException {
        String piece;
        int nummap = this.get_nummap();
        if (nummap != 0) {
            throw new IOException(Utils.getString("ERROR_DUPLICATE_MAP"));
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    nummap = Integer.parseInt(piece);
                    if (nummap < 1) {
                        throw new IOException(Utils.getString("ERROR_NUMBER_ENTRIES_MAP"));
                    }
                    this.maptable = new MapEntry[nummap];
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            throw new IOException(Utils.getString("ERROR_MISSING_MAP"));
        }
        for (int j = 0; j < nummap; ++j) {
            tp = new StringTokenizer(line, " ");
            i = 0;
            this.maptable[j] = new MapEntry();
            this.maptable[j].set = null;
            while (tp.hasMoreTokens()) {
                piece = tp.nextToken();
                if (piece.length() == 0) continue;
                switch (i) {
                    case 0: {
                        if (piece.startsWith("MAP")) break;
                        throw new IOException(Utils.getString("ERROR_MAP_CORRUPT"));
                    }
                    case 1: {
                        this.maptable[j].set = piece;
                        break;
                    }
                }
                ++i;
            }
            if (this.maptable[j].set != null && this.maptable[j].set.length() != 0) continue;
            throw new IOException(Utils.getString("ERROR_MAP_CORRUPT"));
        }
    }

    private void parse_affix(String line, char at, BufferedReader af) throws IOException {
        String piece;
        int numents = 0;
        char achar = '\u0000';
        short ff = 0;
        AffEntry[] ptr = null;
        int nptr = 0;
        StringTokenizer tp = new StringTokenizer(line, " ");
        String nl = line;
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    ++np;
                    achar = piece.charAt(0);
                    break;
                }
                case 2: {
                    ++np;
                    if (piece.charAt(0) != 'Y') break;
                    ff = (short)Utils.XPRODUCT;
                    break;
                }
                case 3: {
                    ++np;
                    numents = Integer.parseInt(piece);
                    ptr = new AffEntry[numents];
                    for (int e = 0; e < numents; ++e) {
                        ptr[e] = new AffEntry();
                    }
                    ptr[0].xpflg = ff;
                    ptr[0].achar = achar;
                    break;
                }
            }
            ++i;
        }
        if (np != 4) {
            MessageFormat form = new MessageFormat(Utils.getString("ERROR_AFFIX_HEADER"));
            throw new IOException(form.format(new Object[]{new Character(achar), nl}));
        }
        nptr = 0;
        for (int j = 0; j < numents; ++j) {
            nl = af.readLine();
            tp = new StringTokenizer(nl, " ");
            i = 0;
            np = 0;
            while (tp.hasMoreTokens()) {
                piece = tp.nextToken();
                if (piece.length() == 0) continue;
                switch (i) {
                    case 0: {
                        ++np;
                        if (nptr == 0) break;
                        ptr[nptr].xpflg = ptr[0].xpflg;
                        break;
                    }
                    case 1: {
                        ++np;
                        if (piece.charAt(0) != achar) {
                            MessageFormat form = new MessageFormat(Utils.getString("ERROR_AFFIX_HEADER_CORRUPT_COUNT"));
                            throw new IOException(form.format(new Object[]{new Character(achar), nl}));
                        }
                        if (nptr == 0) break;
                        ptr[nptr].achar = ptr[0].achar;
                        break;
                    }
                    case 2: {
                        ++np;
                        ptr[nptr].strip = piece;
                        if (!ptr[nptr].strip.equals("0")) break;
                        ptr[nptr].strip = "";
                        break;
                    }
                    case 3: {
                        ++np;
                        ptr[nptr].appnd = piece;
                        if (!ptr[nptr].appnd.equals("0")) break;
                        ptr[nptr].appnd = "";
                        break;
                    }
                    case 4: {
                        ++np;
                        this.encodeit(ptr[nptr], piece);
                        break;
                    }
                }
                ++i;
            }
            if (np != 5) {
                MessageFormat form = new MessageFormat(Utils.getString("ERROR_AFFIX_HEADER_CORRUPT"));
                throw new IOException(form.format(new Object[]{new Character(achar), nl}));
            }
            ++nptr;
        }
        nptr = 0;
        for (int k = 0; k < numents; ++k) {
            if (at == 'P') {
                PfxEntry pfxptr = new PfxEntry(this, ptr[nptr]);
                this.build_pfxlist(pfxptr);
            } else {
                SfxEntry sfxptr = new SfxEntry(this, ptr[nptr]);
                this.build_sfxlist(sfxptr);
            }
            ++nptr;
        }
    }

    private void encodeit(AffEntry ptr, String cs) {
        int i;
        char[] mbr = new char[Utils.MAXLNLEN];
        for (i = 0; i < Utils.SETSIZE; ++i) {
            ptr.conds[i] = '\u0000';
        }
        int nc = cs.length();
        boolean neg = false;
        boolean grp = false;
        int n = 0;
        boolean ec = false;
        int nm = 0;
        if (cs.equals(".")) {
            ptr.numconds = 0;
            return;
        }
        for (i = 0; i < nc; ++i) {
            int j;
            char c = cs.charAt(i);
            if (c == '[') {
                grp = true;
                c = '\u0000';
            }
            if (grp && c == '^') {
                neg = true;
                c = '\u0000';
            }
            if (c == ']') {
                ec = true;
                c = '\u0000';
            }
            if (grp && c != '\u0000') {
                mbr[nm] = c;
                ++nm;
                c = '\u0000';
            }
            if (c != '\u0000') {
                ec = true;
            }
            if (!ec) continue;
            if (grp) {
                char k;
                if (!neg) {
                    for (j = 0; j < nm; ++j) {
                        k = mbr[j];
                        ptr.conds[k] = (char)(ptr.conds[k] | 1 << n);
                    }
                } else {
                    for (j = 0; j < Utils.SETSIZE; ++j) {
                        ptr.conds[j] = (char)(ptr.conds[j] | 1 << n);
                    }
                    for (j = 0; j < nm; ++j) {
                        k = mbr[j];
                        ptr.conds[k] = (char)(ptr.conds[k] & ~(1 << n));
                    }
                }
                neg = false;
                grp = false;
                nm = 0;
            } else if (c == '.') {
                for (j = 0; j < Utils.SETSIZE; ++j) {
                    ptr.conds[j] = (char)(ptr.conds[j] | 1 << n);
                }
            } else {
                ptr.conds[c] = (char)(ptr.conds[c] | 1 << n);
            }
            ++n;
            ec = false;
        }
        ptr.numconds = (short)n;
    }

    private void build_pfxlist(AffEntry pfxptr) {
        PfxEntry ep = (PfxEntry)pfxptr;
        String key = ep.getKey();
        char flg = ep.getFlag();
        PfxEntry ptr = (PfxEntry)this.pFlag[flg];
        ep.setFlgNxt(ptr);
        this.pFlag[flg] = ep;
        if (key.length() == 0) {
            ptr = (PfxEntry)this.pStart[0];
            ep.setNext(ptr);
            this.pStart[0] = ep;
            return;
        }
        char sp = key.charAt(0);
        ptr = (PfxEntry)this.pStart[sp];
        if (ptr == null || ep.getKey().compareTo(ptr.getKey()) <= 0) {
            ep.setNext(ptr);
            this.pStart[sp] = ep;
            return;
        }
        PfxEntry pptr = null;
        while (ptr != null && ep.getKey().compareTo(ptr.getKey()) > 0) {
            pptr = ptr;
            ptr = ptr.getNext();
        }
        pptr.setNext(ep);
        ep.setNext(ptr);
    }

    private void build_sfxlist(AffEntry sfxptr) {
        SfxEntry ep = (SfxEntry)sfxptr;
        String key = ep.getKey();
        char flg = ep.getFlag();
        SfxEntry ptr = (SfxEntry)this.sFlag[flg];
        ep.setFlgNxt(ptr);
        this.sFlag[flg] = ep;
        if (key.length() == 0) {
            ptr = (SfxEntry)this.sStart[0];
            ep.setNext(ptr);
            this.sStart[0] = ep;
            return;
        }
        char sp = key.charAt(0);
        ptr = (SfxEntry)this.sStart[sp];
        if (ptr == null || ep.getKey().compareTo(ptr.getKey()) <= 0) {
            ep.setNext(ptr);
            this.sStart[sp] = ep;
            return;
        }
        SfxEntry pptr = null;
        while (ptr != null && ep.getKey().compareTo(ptr.getKey()) > 0) {
            pptr = ptr;
            ptr = ptr.getNext();
        }
        pptr.setNext(ep);
        ep.setNext(ptr);
    }

    private void process_pfx_order() {
        for (int i = 1; i < Utils.SETSIZE; ++i) {
            PfxEntry nptr;
            PfxEntry ptr;
            for (ptr = (PfxEntry)this.pStart[i]; ptr != null; ptr = ptr.getNext()) {
                for (nptr = ptr.getNext(); nptr != null && Utils.isSubset(ptr.getKey(), nptr.getKey()); nptr = nptr.getNext()) {
                }
                ptr.setNextNE(nptr);
                ptr.setNextEQ(null);
                if (ptr.getNext() == null || !Utils.isSubset(ptr.getKey(), ptr.getNext().getKey())) continue;
                ptr.setNextEQ(ptr.getNext());
            }
            for (ptr = (PfxEntry)this.pStart[i]; ptr != null; ptr = ptr.getNext()) {
                PfxEntry mptr = null;
                for (nptr = ptr.getNext(); nptr != null && Utils.isSubset(ptr.getKey(), nptr.getKey()); nptr = nptr.getNext()) {
                    mptr = nptr;
                }
                if (mptr == null) continue;
                mptr.setNextNE(null);
            }
        }
    }

    private void process_sfx_order() {
        for (int i = 1; i < Utils.SETSIZE; ++i) {
            SfxEntry nptr;
            SfxEntry ptr;
            for (ptr = (SfxEntry)this.sStart[i]; ptr != null; ptr = ptr.getNext()) {
                for (nptr = ptr.getNext(); nptr != null && Utils.isSubset(ptr.getKey(), nptr.getKey()); nptr = nptr.getNext()) {
                }
                ptr.setNextNE(nptr);
                ptr.setNextEQ(null);
                if (ptr.getNext() == null || !Utils.isSubset(ptr.getKey(), ptr.getNext().getKey())) continue;
                ptr.setNextEQ(ptr.getNext());
            }
            for (ptr = (SfxEntry)this.sStart[i]; ptr != null; ptr = ptr.getNext()) {
                SfxEntry mptr = null;
                for (nptr = ptr.getNext(); nptr != null && Utils.isSubset(ptr.getKey(), nptr.getKey()); nptr = nptr.getNext()) {
                    mptr = nptr;
                }
                if (mptr == null) continue;
                mptr.setNextNE(null);
            }
        }
    }
}

