/*
 * Decompiled with CFR 0.152.
 */
package net.hep.graphics.ObjectBrowser.Browser;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.hep.graphics.ObjectBrowser.Browser.AbstractTreeTableModel;
import net.hep.graphics.ObjectBrowser.Browser.Browser;
import net.hep.graphics.ObjectBrowser.Browser.BrowserBroker;
import net.hep.graphics.ObjectBrowser.Browser.JTreeTable;
import net.hep.graphics.ObjectBrowser.Browser.ModelContext;
import net.hep.graphics.ObjectBrowser.Browser.Property;
import net.hep.graphics.ObjectBrowser.Browser.PropertyCatSort;
import net.hep.graphics.ObjectBrowser.Browser.PropertyGroup;
import net.hep.graphics.ObjectBrowser.Browser.PropertyModelNode;
import net.hep.graphics.ObjectBrowser.Browser.PropertyRenderer;
import net.hep.graphics.ObjectBrowser.Browser.PropertySorter;
import net.hep.graphics.ObjectBrowser.Browser.PropertyValue;
import net.hep.graphics.ObjectBrowser.Browser.SelectionEvent;
import net.hep.graphics.ObjectBrowser.Browser.TreeTableModel;

public class PropertyBrowser
implements Browser {
    private BrowserBroker m_broker;
    private PropertyModelNode m_model;
    private JTabbedPane m_tab_pane;
    private JTreeTable m_cat_table;
    private PropertyTableModel m_cat_model;
    private PropertyRenderer m_renderer;

    public PropertyBrowser(BrowserBroker broker, PropertyModelNode model) {
        this.m_broker = broker;
        broker.addSelectionListener(this);
        this.m_model = model != null ? model : new PropertyModelNode();
        this.m_tab_pane = new JTabbedPane(1);
        this.m_cat_model = new PropertyTableModel(this.m_model, new PropertyCatSort());
        this.m_cat_table = new JTreeTable(this.m_cat_model);
        this.m_cat_table.getTree().setRootVisible(false);
        this.m_cat_table.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Icon getLeafIcon() {
                return null;
            }

            @Override
            public Icon getClosedIcon() {
                return new ImageIcon(ClassLoader.getSystemResource("net/hep/graphics/ObjectBrowser/Browser/images/closed.gif"));
            }

            @Override
            public Icon getOpenIcon() {
                return new ImageIcon(ClassLoader.getSystemResource("net/hep/graphics/ObjectBrowser/Browser/images/open.gif"));
            }
        });
        this.m_tab_pane.addTab("Properties", null, new JScrollPane(this.m_cat_table), "Prop");
        this.m_renderer = new PropertyRenderer();
        this.m_renderer.setToolTipText("Event properties.");
        this.m_cat_table.getColumnModel().getColumn(1).setCellRenderer(this.m_renderer);
    }

    @Override
    public void selectionChanged(SelectionEvent event) {
        ModelContext oldContext;
        ModelContext newContext = event.context();
        ModelContext modelContext = oldContext = this.m_model != null ? this.m_model.context() : null;
        if (newContext != oldContext) {
            ModelContext c = event.context();
            PropertyModelNode node = null;
            while (c.previous() != null) {
                c = c.previous();
            }
            while (c != null && node == null) {
                try {
                    node = (PropertyModelNode)c.model();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                c = c.next();
            }
            this.m_model = node != null ? node : new PropertyModelNode();
            this.m_cat_model.regenerate();
        }
    }

    public JComponent component() {
        return this.m_tab_pane;
    }

    private class PropertyTableModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        private PropertySorter m_sorter;
        private PropertyModelNode m_sorted;

        public PropertyTableModel(PropertyModelNode model, PropertySorter sorter) {
            super(model);
            this.m_sorter = sorter;
            this.regenerate();
        }

        public void regenerate() {
            this.m_sorted = null;
            if (PropertyBrowser.this.m_model != null) {
                this.m_sorted = this.m_sorter.sort(PropertyBrowser.this.m_model);
                Object[] path = new Object[]{PropertyBrowser.this.m_model};
                this.fireTreeStructureChanged(this, path, null, null);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return PropertyBrowser.this.m_model != null ? this.m_sorted.getNbProperties() : 0;
        }

        @Override
        public Object getValueAt(Object node, int column) {
            switch (column) {
                case 0: {
                    if (node instanceof PropertyGroup) {
                        return ((PropertyGroup)node).getName();
                    }
                    if (!(node instanceof Property)) break;
                    return ((Property)node).getName();
                }
                case 1: {
                    if (node instanceof PropertyGroup) {
                        return new String();
                    }
                    if (!(node instanceof Property)) break;
                    return ((Property)node).getValue();
                }
            }
            return new String("!ERRROR!");
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Name" : "Value";
        }

        @Override
        public Class getColumnClass(int col) {
            return col == 0 ? TreeTableModel.class : PropertyValue.class;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object aValue, int row, int column) {
            int grpindex = row;
            int k = 0;
            while (grpindex > this.m_sorted.propertyGroup(k).getSize()) {
                grpindex -= this.m_sorted.propertyGroup(k).getSize();
                ++k;
            }
            Property property = this.m_sorted.propertyGroup(k).getProperty(grpindex);
            PropertyValue value = (PropertyValue)aValue;
            property.setValue(value);
        }

        @Override
        public Object getRoot() {
            return PropertyBrowser.this.m_model;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof PropertyModelNode) {
                return ((PropertyModelNode)parent).propertyGroup(index);
            }
            if (parent instanceof PropertyGroup) {
                return ((PropertyGroup)parent).getProperty(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof PropertyModelNode) {
                return ((PropertyModelNode)parent).sizeGroup();
            }
            if (parent instanceof PropertyGroup) {
                return ((PropertyGroup)parent).getSize();
            }
            return 0;
        }
    }
}

