/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import jehep.ui.Constants;
import jehep.ui.JehepTextArea;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.DocumentRenderer;
import jehep.utils.PrintText;
import jehep.utils.PrintingOptions;

public class Utils
implements ActionListener,
Constants {
    private static mainGUI win;

    public Utils(mainGUI wins) {
        win = wins;
    }

    public static String getFileName(String s) {
        return new File(s).getName().toString();
    }

    public static boolean isReadOnly(String f) {
        File file2 = new File(f);
        return !file2.canWrite();
    }

    public static void writeErrorLog(String s) {
        System.out.println(s);
    }

    public static String replaceCharInString(String s, char search2, char replace) {
        s.trim();
        char[] Char = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Char[i] != search2) continue;
            Char[i] = replace;
        }
        String t = new String(Char.toString());
        return t;
    }

    public static String splitOnToken(String s, String token) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, token);
        while (st.hasMoreTokens()) {
            String r = st.nextToken();
            StringBuffer temp = new StringBuffer(r);
            v.add(temp.toString() + "<br>&nbsp;");
        }
        String vs = v.toString();
        return vs;
    }

    public static boolean isImage(String s) {
        return s.endsWith(".gif") || s.endsWith(".jpg") || s.endsWith(".GIF") || s.endsWith(".JPG");
    }

    public static boolean setDefaults() {
        String dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>Restore Defaults?</HTML>";
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        int value = JOptionPane.showConfirmDialog(win, dialogmessage, "Restore?", 1);
        switch (value) {
            case 0: {
                return win.restoreDefaults();
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public static String comboDialog(String title, String message, String[] ints) {
        String dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>" + message + "</HTML>";
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        String s = (String)JOptionPane.showInputDialog(win, dialogmessage, title, 3, null, ints, ints[0]);
        return s;
    }

    public static File getRoot(File f) {
        while (f.getParent() != null) {
            f = new File(f.getParent());
        }
        return f;
    }

    public static boolean hasBlanks(String s) {
        s.trim();
        char[] Char = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Char[i] != ' ') continue;
            return true;
        }
        return false;
    }

    public static boolean isOSRoot(String s) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Win") && s.length() < 3) {
            return true;
        }
        return os.startsWith("Unix") || os.startsWith("Linux") || os.startsWith("Mac") && s.length() < 1;
    }

    public static boolean okToAbandon(boolean dirty, boolean readOnly, String currFileName, String untitled) {
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        if (!dirty) {
            return true;
        }
        if (dirty && readOnly) {
            return true;
        }
        String s = currFileName == null ? untitled : new File(currFileName).getName().toString();
        String dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>Save " + s + "?</HTML>";
        int value = JOptionPane.showConfirmDialog(win, dialogmessage, "Save file?", 1);
        switch (value) {
            case 0: {
                return win.save();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static String createWhiteSpace(int len) {
        return Utils.createWhiteSpace(len, 0);
    }

    public static String createWhiteSpace(int len, int tabSize) {
        StringBuffer buf = new StringBuffer();
        if (tabSize == 0) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else {
            int count = len / tabSize;
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static int getLeadingWhiteSpace(String str) {
        int whitespace;
        block3: for (whitespace = 0; whitespace < str.length(); ++whitespace) {
            switch (str.charAt(whitespace)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return whitespace;
    }

    public static int getLeadingWhiteSpaceWidth(String str, int tabSize) {
        int whitespace = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    continue block4;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    continue block4;
                }
            }
        }
        return whitespace;
    }

    public static boolean okToQuit(boolean[] dirty, boolean[] readOnly) {
        String dialogmessage = "Save unsaved Documents?";
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        boolean save = false;
        try {
            for (int i = 0; i < win.tabCount(); ++i) {
                if (!dirty[i] || readOnly[i]) continue;
                save = true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (save) {
            int value = JOptionPane.showConfirmDialog(win, dialogmessage, "Save Documents?", 1);
            switch (value) {
                case 0: {
                    return win.saveAll();
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static void getDate() {
        Calendar c = Calendar.getInstance();
        win.insert(c.toString());
    }

    public static void getTime() {
        Date date = new Date();
        date = Calendar.getInstance().getTime();
        win.insert(date.toString());
    }

    public static void ChangeCase(String type) {
        String select = win.getSelectedText();
        if (type == "Upper") {
            win.replaceSelection(select.toUpperCase());
        } else if (type == "Lower") {
            win.replaceSelection(select.toLowerCase());
        } else {
            win.replaceSelection(select.toLowerCase());
        }
        win.jehepRequestFocus();
    }

    public static void setHtmlComment() {
        String start = "<!-- ";
        String end2 = " -->";
        String select = win.getSelectedText();
        if (select == null) {
            win.replaceSelection(start + end2);
        } else {
            win.replaceSelection(start + select + end2);
        }
        win.jehepRequestFocus();
    }

    public static void setJavaComment2() {
        String start = "/*\n";
        String end2 = "\n*/";
        String select = win.getSelectedText();
        if (select == null) {
            win.replaceSelection(start + end2);
        } else {
            win.replaceSelection(start + select + end2);
        }
        win.jehepRequestFocus();
    }

    public static void setJavaComment1() {
        int start = win.getSelectionStartLine();
        int end2 = win.getSelectionEndLine();
        int selstart = win.getSelectionStart();
        int selend = win.getSelectionEnd();
        if (start == end2) {
            win.insertString("// ", selstart);
        } else {
            String s = win.getSelectedText();
            win.setSelectedText(Utils.splitOnToken2(s.trim(), "\n"));
            win.select(selstart, selend);
        }
        win.jehepRequestFocus();
    }

    public static String splitOnToken2(String s, String token) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, token, false);
        while (st.hasMoreTokens()) {
            String r = st.nextToken();
            sb.append("// " + r + "\n");
        }
        return sb.toString();
    }

    public static boolean okToOverwrite(String currFileName, File currFileType) {
        String dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>Overwrite the existing file?</HTML>";
        String titlemessage = "Please confirm:";
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        if (currFileName == null) {
            return win.saveAsFile();
        }
        File file2 = new File(currFileName);
        if (file2.exists() && !file2.equals(currFileType)) {
            SetEnv.CheckFileTime = false;
            if (0 == JOptionPane.showConfirmDialog(win, dialogmessage + currFileName, titlemessage, 0, 2)) {
                return true;
            }
        } else {
            if (file2.exists() && file2.equals(currFileType)) {
                return true;
            }
            return true;
        }
        win.setcurrFileName(null);
        return false;
    }

    public static boolean genericConfirm(String dialogmessage, String titlemessage) {
        dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>" + dialogmessage + "</HTML>";
        JOptionPane jop = new JOptionPane();
        jop.setFont(SetEnv.guiFont);
        int value = JOptionPane.showConfirmDialog(win, dialogmessage, "Confirm dialog", 0, 2);
        switch (value) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public static Font tokenisefont(String s) {
        Font f = new Font("Serif", 1, 12);
        String[] parts = s.split(":");
        if (parts.length > 2) {
            String fontName = parts[0];
            int fontStyle = Integer.parseInt(parts[1]);
            int fontSize = Integer.parseInt(parts[2]);
            f = new Font(fontName, fontStyle, fontSize);
        } else {
            System.err.println("Error in reading font from preferences");
        }
        return f;
    }

    public static String getDocs(String doc) {
        String s = new String();
        try {
            File f = new File(doc);
            if (f.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                byte[] b = new byte[in.available()];
                in.read(b, 0, b.length);
                s = new String(b, 0, b.length);
                in.close();
            } else {
                Utils.writeErrorLog("Error reading Docs");
            }
        }
        catch (IOException ex) {
            System.out.println("Error reading Docs folder");
        }
        return s;
    }

    public static void userMessage(String title, String message, int type) {
        JOptionPane jop = new JOptionPane();
        jop.setFont(new Font("Arial", 1, 14));
        String dialogtitle = title;
        String dialogmessage = "<HTML><font face = arial style='font-size:12pt;font-weight:bold' color='000000'>" + message + "</HTML>";
        int dialogtype = 0;
        dialogtype = type == 1 ? 2 : 1;
        JOptionPane.showMessageDialog(null, dialogmessage, dialogtitle, dialogtype);
    }

    public static void openDefBrowser(String s) {
        try {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + s);
        }
        catch (IOException eIO) {
            try {
                Runtime.getRuntime().exec("Netscape.exe " + s);
            }
            catch (IOException eIOExcp) {
                try {
                    Runtime.getRuntime().exec("Iexplore.exe " + s);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        win.repaint();
    }

    public static String convertEOLs(String s) {
        int gap = 32;
        char[] Char = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Char[i] != '\n' && Char[i] != '\r' && Char[i] != '\t') continue;
            Char[i] = gap;
        }
        s = new String(Char);
        return s;
    }

    public static void centerComponent(Component compo) {
        compo.setLocation(new Point((Utils.getScreenDimension().width - compo.getSize().width) / 2, (Utils.getScreenDimension().height - compo.getSize().height) / 2));
    }

    public static Dimension getScreenDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void Print() {
        if (SetEnv.isCodeView != win.selectedTabIndex()) {
            JehepTextArea textArea = win.getEditor();
            PrintingOptions printOptions = new PrintingOptions();
            printOptions.setPrintLineNumbers(true);
            printOptions.setPrintHeader(true);
            printOptions.setWrapText(false);
            Font f = win.getFont();
            printOptions.setPageFont(f);
            PageFormat pgfmt = new PageFormat();
            Paper paper = pgfmt.getPaper();
            pgfmt.setOrientation(1);
            double width = 612.0;
            double height = 792.0;
            double imgX = 72.0;
            double imgY = 72.0;
            double imgWidth = 468.0;
            double imgHeight = 648.0;
            paper.setSize(width, height);
            paper.setImageableArea(imgX, imgY, imgWidth, imgHeight);
            pgfmt.setPaper(paper);
            printOptions.setPageFormat(pgfmt);
            PrintText print = new PrintText(textArea.getDocument(), textArea.getName(), printOptions, false, textArea.getTabSize());
            win.repaint();
        } else {
            JEditorPane jep = win.getHtmlPane();
            DocumentRenderer dr = new DocumentRenderer();
            dr.print(jep);
        }
    }

    public static void PrintPreview(String s) {
        win.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

