/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jehep.utils.LimitLinesDocumentListener;

public class MessageConsole {
    private JTextComponent textComponent;
    private Document document;
    private boolean isAppend;
    private DocumentListener limitLinesListener;
    private ConsoleOutputStream cos;

    public MessageConsole(JTextComponent textComponent) {
        this(textComponent, true);
    }

    public MessageConsole(JTextComponent textComponent, boolean isAppend) {
        this.textComponent = textComponent;
        this.document = textComponent.getDocument();
        this.isAppend = isAppend;
        textComponent.setEditable(false);
    }

    public void redirectOut() {
        this.redirectOut(null, null);
    }

    public void redirectOut(Color textColor, PrintStream printStream) {
        this.cos = new ConsoleOutputStream(textColor, printStream);
        System.setOut(new PrintStream(this.cos, true));
    }

    public void redirectErr() {
        this.redirectErr(null, null);
    }

    public void redirectErr(Color textColor, PrintStream printStream) {
        this.cos = new ConsoleOutputStream(textColor, printStream);
        System.setErr(new PrintStream(this.cos, true));
    }

    public void setMessageLines(int lines) {
        if (this.limitLinesListener != null) {
            this.document.removeDocumentListener(this.limitLinesListener);
        }
        this.limitLinesListener = new LimitLinesDocumentListener(lines, this.isAppend);
        this.document.addDocumentListener(this.limitLinesListener);
    }

    public void refresh() {
        this.cos.flush();
        this.cos.clearBuffer();
        this.textComponent.setText("\n");
    }

    public long getSize() {
        return this.document.getLength();
    }

    class ConsoleOutputStream
    extends ByteArrayOutputStream {
        private SimpleAttributeSet attributes;
        private PrintStream printStream;
        private StringBuffer buffer = new StringBuffer(80);
        private boolean isFirstLine;

        public ConsoleOutputStream(Color textColor, PrintStream printStream) {
            if (textColor != null) {
                this.attributes = new SimpleAttributeSet();
                StyleConstants.setForeground(this.attributes, textColor);
            }
            this.printStream = printStream;
            if (MessageConsole.this.isAppend) {
                this.isFirstLine = true;
            }
        }

        @Override
        public void flush() {
            String message = this.toString();
            if (message.length() == 0) {
                return;
            }
            if (MessageConsole.this.isAppend) {
                this.handleAppend(message);
            } else {
                this.handleInsert(message);
            }
            this.reset();
        }

        private void handleAppend(String message) {
            if (message.endsWith("\r") || message.endsWith("\n")) {
                this.buffer.append(message);
            } else {
                this.buffer.append(message);
                this.clearBuffer();
            }
        }

        private void handleInsert(String message) {
            this.buffer.append(message);
            if (message.endsWith("\r") || message.endsWith("\n")) {
                this.clearBuffer();
            }
        }

        public void clearBuffer() {
            if (this.isFirstLine && MessageConsole.this.document.getLength() != 0) {
                this.buffer.insert(0, "\n");
            }
            this.isFirstLine = false;
            String line = this.buffer.toString();
            try {
                if (MessageConsole.this.isAppend) {
                    int offset = MessageConsole.this.document.getLength();
                    MessageConsole.this.document.insertString(offset, line, this.attributes);
                    MessageConsole.this.textComponent.setCaretPosition(MessageConsole.this.document.getLength());
                } else {
                    MessageConsole.this.document.insertString(0, line, this.attributes);
                    MessageConsole.this.textComponent.setCaretPosition(0);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.printStream != null) {
                this.printStream.print(line);
            }
            this.buffer.setLength(0);
        }
    }
}

