/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui.codeview;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;

public class java2html {
    private static final String[] keywords = new String[]{"abstract", "default", "if", "private", "throw", "boolean", "do", "implements", "protected", "throws", "break", "double", "import", "public", "transient", "byte", "else", "instanceof", "return", "try", "case", "extends", "int", "short", "void", "catch", "final", "interface", "static", "volatile", "char", "finally", "long", "super", "while", "class", "float", "native", "switch", "const", "for", "new", "synchronized", "continue", "goto", "package", "this"};
    private static Vector keyw = new Vector(keywords.length);
    private static int tabsize;
    private static String bgcolor;
    private static String txcolor;
    private static String kwcolor;
    private static String cmcolor;
    private static String c2color;
    private static String stcolor;

    public static void convert(String source) throws IOException {
        String dest = source + ".html";
        System.out.println(dest);
        FileReader in = new FileReader(source);
        FileWriter out = new FileWriter(dest);
        out.write("<html>\r\n<head>\r\n<title>");
        out.write(source);
        out.write("</title>\r\n</head>\r\n<body ");
        out.write("bgcolor=\"" + bgcolor + "\" ");
        out.write("text=\"" + txcolor + "\">\r\n");
        out.write("<pre>\r\n");
        StringBuffer buf = new StringBuffer(2048);
        int c = 0;
        int kwl = 0;
        int bufl = 0;
        int nexttolast = 0;
        int ch = 0;
        int lastch = 0;
        int s_normal = 0;
        int s_string = 1;
        int s_char = 2;
        int s_comline = 3;
        int s_comment = 4;
        int state = s_normal;
        block13: while (c != -1) {
            c = in.read();
            nexttolast = lastch;
            lastch = ch;
            int n = ch = c >= 0 ? (int)c : 0;
            if (state == s_normal) {
                if (kwl == 0 && Character.isJavaIdentifierStart((char)ch) && !Character.isJavaIdentifierPart((char)lastch) || kwl > 0 && Character.isJavaIdentifierPart((char)ch)) {
                    buf.append((char)ch);
                    ++bufl;
                    ++kwl;
                    continue;
                }
                if (kwl > 0) {
                    String kw = buf.toString().substring(buf.length() - kwl);
                    if (keyw.contains(kw)) {
                        buf.insert(buf.length() - kwl, "<font color=\"" + kwcolor + "\">");
                        buf.append("</font>");
                    }
                    kwl = 0;
                }
            }
            switch (ch) {
                case 38: {
                    buf.append("&amp;");
                    ++bufl;
                    continue block13;
                }
                case 34: {
                    buf.append("&quot;");
                    ++bufl;
                    if (state == s_normal) {
                        state = s_string;
                        buf.insert(buf.length() - "&quot;".length(), "<font color=\"" + stcolor + "\"><i>");
                        continue block13;
                    }
                    if (state != s_string || lastch == 92 && (lastch != 92 || nexttolast != 92)) continue block13;
                    buf.append("</i></font>");
                    state = s_normal;
                    continue block13;
                }
                case 39: {
                    buf.append("'");
                    ++bufl;
                    if (state == s_normal) {
                        state = s_char;
                        continue block13;
                    }
                    if (state != s_char || lastch == 92) continue block13;
                    state = s_normal;
                    continue block13;
                }
                case 92: {
                    buf.append("\\");
                    ++bufl;
                    if (lastch == 92) {
                        nexttolast = 92;
                    }
                    if (lastch != 92 || state == s_string || state != s_char) continue block13;
                    continue block13;
                }
                case 47: {
                    buf.append("/");
                    ++bufl;
                    if (state == s_string || state == s_comline) continue block13;
                    if (state == s_comment && lastch == 42) {
                        buf.append("</i></font>");
                        state = s_normal;
                    }
                    if (state == s_comment || lastch != 47) continue block13;
                    buf.insert(buf.length() - 2, "<font color=\"" + cmcolor + "\"><i>");
                    state = s_comline;
                    continue block13;
                }
                case 42: {
                    buf.append("*");
                    ++bufl;
                    if (state != s_normal || lastch != 47) continue block13;
                    buf.insert(buf.length() - 2, "<font color=\"" + c2color + "\"><i>");
                    state = s_comment;
                    continue block13;
                }
                case 60: {
                    buf.append("&lt;");
                    ++bufl;
                    continue block13;
                }
                case 62: {
                    buf.append("&gt;");
                    ++bufl;
                    continue block13;
                }
                case 9: {
                    int n2 = bufl / tabsize * tabsize + tabsize;
                    while (bufl < n2) {
                        buf.append(' ');
                        ++bufl;
                    }
                    continue block13;
                }
                case 10: 
                case 13: {
                    if (state == s_comline) {
                        buf.append("</i></font>");
                        state = s_normal;
                    }
                    buf.append((char)ch);
                    if (buf.length() >= 1024) {
                        out.write(buf.toString());
                        buf.setLength(0);
                    }
                    bufl = 0;
                    if (kwl != 0) {
                        kwl = 0;
                    }
                    if (state == s_normal || state == s_comment) continue block13;
                    state = s_normal;
                    continue block13;
                }
                case 0: {
                    if (c >= 0) break;
                    if (state == s_comline) {
                        buf.append("</font>");
                        state = s_normal;
                    }
                    out.write(buf.toString());
                    buf.setLength(0);
                    bufl = 0;
                    if (state != s_comment) continue block13;
                    buf.append("</font>");
                    state = s_normal;
                    continue block13;
                }
            }
            ++bufl;
            buf.append((char)ch);
        }
        out.write("</pre>\r\n</body>\r\n</html>");
        in.close();
        out.close();
    }

    public static void main(String[] args) {
        String source;
        String propfile;
        if (args.length < 1 || args.length > 2) {
            System.out.println("java2html converter + syntax coloring + tabs2spaces");
            System.out.println("");
            System.out.println("java  [java_opt]  java2html  [colors_file]  source");
            System.out.println("");
            System.out.println("  - java is the name of the Java interpreter");
            System.out.println("  - java_opt are the options of the Java interpreter");
            System.out.println("  - java2html is the name of this application");
            System.out.println("  - colors_file (optional) is the path ");
            System.out.println("    of a file which has a structure like this:");
            System.out.println("        tabsize=number  (default value is 4)");
            System.out.println("        bgcolor=RRGGBB  (default value is " + bgcolor + ") - background");
            System.out.println("        txcolor=RRGGBB  (default value is " + txcolor + ") - source code");
            System.out.println("        kwcolor=RRGGBB  (default value is " + kwcolor + ") - keywords");
            System.out.println("        cmcolor=RRGGBB  (default value is " + cmcolor + ") - // comments");
            System.out.println("        c2color=RRGGBB  (default value is " + c2color + ") - /* comments");
            System.out.println("        stcolor=RRGGBB  (default value is " + stcolor + ") - strings");
            System.out.println("  - source is a file or the directory to the Java source file(s)");
            System.out.println("");
            System.out.println("Examples:");
            System.out.println("    java  java2html  java2html.java");
            System.out.println("    java  java2html  C:\\TEMP");
            System.out.println("    java  java2html  java2html.properties  C:\\TEMP");
            System.exit(1);
        }
        if (args.length == 2) {
            propfile = args[0];
            source = args[1];
        } else {
            propfile = "java2html.properties";
            source = args[0];
        }
        try {
            FileInputStream in = new FileInputStream(propfile);
            Properties prop = new Properties();
            prop.load(in);
            ((InputStream)in).close();
            tabsize = Integer.parseInt(prop.getProperty("tabsize", "4"));
            bgcolor = "#" + prop.getProperty("bgcolor", bgcolor);
            txcolor = "#" + prop.getProperty("txcolor", txcolor);
            kwcolor = "#" + prop.getProperty("kwcolor", kwcolor);
            cmcolor = "#" + prop.getProperty("cmcolor", cmcolor);
            c2color = "#" + prop.getProperty("c2color", c2color);
            stcolor = "#" + prop.getProperty("stcolor", stcolor);
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (NumberFormatException e) {
            System.out.println(e);
        }
        File f = new File(source);
        if (f.isFile()) {
            try {
                java2html.convert(f.getPath());
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else if (f.isDirectory()) {
            try {
                String[] src = f.list();
                for (int i = 0; i < src.length; ++i) {
                    if (!src[i].endsWith(".java")) continue;
                    java2html.convert(new File(f, src[i]).getPath());
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else {
            System.out.println("The source parameter must be an existent file or directory");
            System.out.println("Run java2html without parameters for help");
        }
    }

    static {
        for (int i = 0; i < keywords.length; ++i) {
            keyw.addElement(keywords[i]);
        }
        tabsize = 4;
        bgcolor = "FFFFFF";
        txcolor = "000000";
        kwcolor = "3333FF";
        cmcolor = "009900";
        c2color = "999999";
        stcolor = "FF0000";
    }
}

