/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui.codeview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import jehep.ui.mainGUI;

public class BrowserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private HTMLEditorKit htmled;
    private JEditorPane jep;
    private JFrame f;
    private mainGUI win;
    private JButton backButton;
    private JLabel label;
    private JButton reloadButton;
    private String initialPage;
    private Font font;

    public BrowserPanel(String initialPage, Font font, mainGUI win) {
        this.win = win;
        this.initialPage = initialPage;
        this.font = font;
        Vector<String> history = new Vector<String>();
        history.add(initialPage);
        this.jep = new JEditorPane();
        this.colorizeHtml(initialPage);
        JScrollPane scrollPane = new JScrollPane(this.jep);
        this.label = new JLabel(initialPage);
        this.label.setBackground(Color.white);
        this.label.setForeground(Color.gray);
        this.backButton = new JButton("Back");
        this.backButton.setActionCommand("back");
        this.backButton.setPreferredSize(new Dimension(100, 20));
        this.backButton.setToolTipText("Go to previous page");
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new backButtonListener(this.jep, this.backButton, history, this.label));
        this.reloadButton = new JButton("Reload");
        this.reloadButton.setPreferredSize(new Dimension(100, 20));
        this.reloadButton.setToolTipText("Reload this page");
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.reloadPage();
            }
        });
        this.jep.addHyperlinkListener(new LinkFollower(this.jep, this.backButton, history, this.label));
        JPanel toolBar = new JPanel(new BorderLayout());
        toolBar.setBackground(Color.white);
        toolBar.setPreferredSize(new Dimension(1500, 25));
        toolBar.setMinimumSize(new Dimension(25, 25));
        toolBar.add((Component)this.backButton, "West");
        toolBar.add((Component)this.reloadButton, "East");
        toolBar.add((Component)this.label, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        this.add((Component)scrollPane, "Center");
    }

    protected void setPage(String url) {
        try {
            this.jep.setPage(url);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void colorizeHtml(String initialPage) {
        this.jep.setContentType("text/html");
        this.jep.setEditable(false);
        this.jep.setFont(this.font);
        this.htmled = (HTMLEditorKit)this.jep.getEditorKit();
        String bodyRule = "body { font-family: " + this.font.getFamily() + "; font-size: " + this.font.getSize() + "pt; }";
        this.setPage(initialPage);
        StyleSheet ssc = ((HTMLDocument)this.jep.getDocument()).getStyleSheet();
        ssc.addRule(bodyRule);
        ssc.addRule("h1 {color: blue;}");
        ssc.addRule("img {vertical-align: middle;}");
        String s = "DIV.comment { BACKGROUND-COLOR: #ffffff; margin-left: 10px; margin-right: 10px;}";
        ssc.addRule(s);
        s = "DIV.jycode { BACKGROUND-COLOR: #EFFBFB;}";
        ssc.addRule(s);
        s = "DIV.footer { BACKGROUND-COLOR: #E6E6E6; color: #ffffff;}";
        ssc.addRule(s);
    }

    public JEditorPane getEPane() {
        return this.jep;
    }

    public void reloadPage() {
        this.label.setText(this.initialPage);
        Document doc = this.jep.getDocument();
        doc.putProperty("stream", null);
        this.colorizeHtml(this.initialPage);
    }

    class backButtonListener
    implements ActionListener {
        protected JEditorPane jep;
        protected JLabel label;
        protected JButton backButton;
        protected Vector<String> history;

        public backButtonListener(JEditorPane jep, JButton backButton, Vector<String> history, JLabel label) {
            this.jep = jep;
            this.backButton = backButton;
            this.history = history;
            this.label = label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String curl = this.history.lastElement();
                this.history.removeElement(curl);
                curl = this.history.lastElement();
                BrowserPanel.this.setPage(curl);
                this.label.setText("<html><b>URL:</b> " + curl);
                if (this.history.size() == 1) {
                    this.backButton.setEnabled(false);
                }
            }
            catch (Exception ex) {
                System.out.println("Exception " + ex);
            }
        }
    }

    class LinkFollower
    implements HyperlinkListener {
        protected JEditorPane jep;
        protected JLabel label;
        protected JButton backButton;
        protected Vector<String> history;

        public LinkFollower(JEditorPane jep, JButton backButton, Vector<String> history, JLabel label) {
            this.jep = jep;
            this.backButton = backButton;
            this.history = history;
            this.label = label;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    String currentURL = evt.getURL().toString();
                    this.history.add(currentURL);
                    this.backButton.setEnabled(true);
                    System.out.println("Going to " + currentURL);
                    this.openWebpage(currentURL);
                }
                catch (Exception e) {
                    System.out.println("ERROR: Trouble fetching url");
                }
            }
        }

        public void openWebpage(String urlString) {
            try {
                Desktop.getDesktop().browse(new URL(urlString).toURI());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

