/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class WWWRunDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton runButton;
    private JButton openButton;
    private JTextArea wwwArea;
    private static String errmess = "<html>Not supported file format! <br> Can be used with:<br>  Jython (*.py)<br>,  BeanShell (*.bsh),<br> Java (*.java), <br> Groovy (*.groovy, *.gvy, *.gy), <br> JRuby (*.rb), <br>Octave/Mathlab (*.m)<br> </html>";
    final String pathOut = SetEnv.DirPath + SetEnv.fSep + "macros" + SetEnv.fSep + "downloads" + SetEnv.fSep;
    private final mainGUI win;

    public WWWRunDialog(final mainGUI win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.setResizable(true);
        win.setPromptTabIndex(1);
        Rectangle bounds = win.getBounds();
        int ww = bounds.width;
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(460, 140));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WWWRunDialog.this.setVisible(false);
                WWWRunDialog.this.dispose();
            }
        });
        this.runButton = new JButton();
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fin = WWWRunDialog.this.wwwArea.getText();
                if ((fin = fin.trim()).endsWith(".py") || fin.endsWith(".groovy") || fin.endsWith(".gvy") || fin.endsWith(".gy") || fin.endsWith(".bsh") || fin.endsWith(".Bsh") || fin.endsWith(".java") || fin.endsWith(".m")) {
                    String[] pyFile = fin.split("/");
                    String ss = pyFile[pyFile.length - 1];
                    String ff = WWWRunDialog.this.pathOut + ss;
                    WWWRunDialog.this.readFile(fin, ff);
                    win.open(ff, false);
                    SetEnv.showStatusBarText("Executing=" + ss);
                    win.getPanelBottom().RunCommand();
                } else {
                    JOptionPane.showMessageDialog(win, errmess);
                }
            }
        });
        this.openButton = new JButton();
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fin = WWWRunDialog.this.wwwArea.getText();
                String[] pyFile = (fin = fin.trim()).split("/");
                if (pyFile.length > 1) {
                    if (fin.endsWith(".groovy") || fin.endsWith(".gvy") || fin.endsWith(".gy") || fin.endsWith(".py") || fin.endsWith(".bsh") || fin.endsWith(".m") || fin.endsWith(".java") || fin.endsWith(".txt") || fin.endsWith(".rb")) {
                        String ss = pyFile[pyFile.length - 1];
                        String ff = WWWRunDialog.this.pathOut + ss;
                        WWWRunDialog.this.readFile(fin, ff);
                        SetEnv.showStatusBarText("Openning=" + ss);
                        win.open(ff, false);
                    } else {
                        JOptionPane.showMessageDialog(win, errmess);
                    }
                }
            }
        });
        int hh = bounds.height;
        int xx = bounds.x;
        int yy = bounds.y;
        this.wwwArea = new JTextArea();
        JPanel jp = new JPanel();
        jp.add((Component)this.openButton, "East");
        jp.add((Component)this.runButton, "East");
        jp.add((Component)this.closeButton, "East");
        JLabel jleb = new JLabel("<html><b>Enter URL of the supported files:</b><i><br>Jython (*.py), BeanShell (*.bsh),<br>Groovy (*.groovy,*.gvy,*.gy),<br>JRuby (*.rb), Matlab/Octave (*.m),<br>Java code (*.java)</i></html>");
        jleb.setMinimumSize(new Dimension(300, 300));
        jleb.setMaximumSize(new Dimension(300, 300));
        lowerPanel.add((Component)jleb, "North");
        lowerPanel.add((Component)jp, "South");
        this.getContentPane().add((Component)this.wwwArea, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.setTitle("Open or run scripts from URL location");
        this.setLocation(xx + (int)(0.12 * (double)ww), yy + (int)(0.4 * (double)hh));
        this.setMinimumSize(new Dimension((int)((double)ww * 0.45), 220));
        this.setMaximumSize(new Dimension(ww, 350));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void readFile(String file2, String ff) {
        try {
            String inputLine;
            URL url = new URL(file2);
            SetEnv.showStatusBarText("Connecting to=" + file2);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            FileWriter fstream = new FileWriter(ff);
            BufferedWriter out = new BufferedWriter(fstream);
            while ((inputLine = in.readLine()) != null) {
                out.write(inputLine + "\n");
            }
            in.close();
            out.close();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.win, "Wrong URL. MalformedURLException!");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.win, "Wrong IO. IOException!");
        }
    }
}

