/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import jehep.ui.SetEnv;
import jehep.ui.UJar;
import jehep.ui.UpdateDialog;

public final class UpdateService {
    private ArrayList<UJar> jars;
    private ArrayList<UJar> WWWjars;
    final String newFile = SetEnv.SERVER_URL_UPDATE + "dmelt_jars";
    private JFrame win;
    private boolean showGUI;
    private boolean isneedupdate = false;
    private boolean noconnection = false;

    public UpdateService(JFrame frame, boolean showGUI) {
        this.win = frame;
        this.showGUI = showGUI;
        this.isneedupdate = false;
        this.noconnection = false;
    }

    public void StartUpdate(boolean showGUI) {
        this.noconnection = false;
        this.isneedupdate = false;
        this.showGUI = showGUI;
        this.jars = new ArrayList();
        this.WWWjars = new ArrayList();
        String webFileData = "";
        try {
            String str;
            URL url = new URL(this.newFile);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = in.readLine()) != null) {
                String[] s;
                webFileData = webFileData + str;
                if (str.startsWith("#") || (s = (str = str.replace("\n", "")).split(" ")).length != 2) continue;
                String sjar = s[0];
                String slen = s[1];
                int ilen = Integer.parseInt(slen);
                this.WWWjars.add(new UJar(sjar, sjar, ilen));
            }
            in.close();
        }
        catch (MalformedURLException e) {
            this.noconnection = true;
        }
        catch (IOException e) {
            this.noconnection = true;
        }
        File startingDirectory = new File(SetEnv.DirPath + SetEnv.fSep + "lib" + SetEnv.fSep);
        this.jars = new ArrayList();
        try {
            List<File> files = this.getFileListing(startingDirectory);
            try {
                BufferedWriter fout = new BufferedWriter(new FileWriter(SetEnv.DirPath + SetEnv.fSep + "lib" + SetEnv.fSep + "dmelt_jars"));
                Date date = new Date();
                long timestamp = System.currentTimeMillis() / 1000L;
                fout.write("# " + Long.toString(timestamp) + "\n");
                fout.write("# " + date.toString() + "\n");
                for (File file2 : files) {
                    String sname = file2.toString();
                    if (!sname.endsWith(".jar")) continue;
                    int filesize = (int)file2.length();
                    String s = Integer.toString(filesize);
                    sname = sname.replace("\\", "/");
                    String[] xname = sname.split("/");
                    String shortpath = sname;
                    if (xname.length > 2) {
                        shortpath = xname[xname.length - 2] + "/" + xname[xname.length - 1];
                    }
                    fout.write(shortpath + " " + s + "\n");
                    UJar ujar = new UJar(shortpath, shortpath, filesize);
                    ujar.setNeedUpdate(true);
                    if (this.noconnection) {
                        ujar.setNeedUpdate(false);
                    }
                    for (int j = 0; j < this.WWWjars.size(); ++j) {
                        if (!shortpath.equals(this.WWWjars.get(j).getName()) || filesize != this.WWWjars.get(j).getSize()) continue;
                        ujar.setNeedUpdate(false);
                    }
                    if (ujar.getNeedUpdate()) {
                        this.isneedupdate = true;
                    }
                    this.jars.add(ujar);
                }
                fout.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        if (showGUI) {
            new UpdateDialog(this.win, this.jars);
        }
        if (!showGUI && this.isneedupdate) {
            new UpdateDialog(this.win, this.jars);
        }
    }

    private List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        this.validateDirectory(aStartingDir);
        List<File> result = this.getFileListingNoSort(aStartingDir);
        Collections.sort(result);
        return result;
    }

    private List<File> getFileListingNoSort(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file2 : filesDirs) {
            result.add(file2);
            if (file2.isFile()) continue;
            List<File> deeperList = this.getFileListingNoSort(file2);
            result.addAll(deeperList);
        }
        return result;
    }

    private void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }
}

