/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jehep.ui.SetEnv;
import jehep.ui.UJar;
import jehep.utils.Util;
import jehep.utils.Utils;
import jehep.utils.downloadman.DownloadManager;

public class UpdateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton updateButton;
    private ArrayList<UJar> updatejar;
    private JFrame win;
    private Color origColor = null;
    private Timer tim;
    private final Color myred = new Color(250, 160, 160);

    public UpdateDialog(JFrame win, ArrayList<UJar> jars) {
        this.win = win;
        this.updatejar = new ArrayList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Update dialog");
        this.setModal(true);
        this.setResizable(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(400, res.width), Math.min(350, res.height));
        this.setSize(size);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(400, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.setVisible(false);
                UpdateDialog.this.dispose();
            }
        });
        this.updateButton = new JButton();
        this.origColor = this.updateButton.getBackground();
        this.updateButton.setText("No updates available");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.startUpdate();
            }
        });
        lowerPanel.add((Component)this.updateButton, null);
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        DefaultTableModel model = new DefaultTableModel();
        model.setColumnIdentifiers(new String[]{"Jar Library", "Update Status"});
        model.setRowCount(jars.size());
        JTable table = new JTable(model){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row)) {
                    c.setBackground(row % 2 == 0 ? this.getBackground() : new Color(202, 249, 255));
                    int modelRow = this.convertRowIndexToModel(row);
                    String type = (String)this.getModel().getValueAt(modelRow, 1);
                    if ("need update".equals(type)) {
                        c.setBackground(UpdateDialog.this.myred);
                    }
                }
                return c;
            }
        };
        Font nf = new Font(SetEnv.globalFont.getFamily(), 0, SetEnv.globalFont.getSize());
        table.setFont(nf);
        model.setColumnIdentifiers(new String[]{"Jar Library", "Update Status"});
        model.setRowCount(jars.size());
        int row = 0;
        for (UJar data : jars) {
            String status = "ok";
            if (data.getNeedUpdate()) {
                status = "need update";
                this.updatejar.add(data);
            }
            model.setValueAt(data.getName(), row, 0);
            model.setValueAt(status, row, 1);
            ++row;
        }
        table.setCellSelectionEnabled(false);
        int Nrjars = this.updatejar.size();
        if (Nrjars > 0) {
            this.updateButton.setText("Update " + Integer.toString(Nrjars) + " files");
            this.tim = new Timer();
            this.tim.schedule((TimerTask)new Flasher(), 0L, 1000L);
        }
        JScrollPane panel1 = new JScrollPane(table);
        topPanel.add((Component)panel1, "Center");
        Util.centreWithin(win, this);
        this.setVisible(true);
    }

    public void startUpdate() {
        if (!SetEnv.isCommunity) {
            String dirtocopy = SetEnv.DirPath + SetEnv.fSep + "lib";
            String url = SetEnv.SERVER_URL_UPDATE;
            new DownloadManager(this.win, this.updatejar, url, dirtocopy);
            this.tim = null;
            this.setVisible(false);
            this.dispose();
        } else {
            Utils.userMessage("Message", "This is a community edition of DataMelt. Online update of libraries is disabled. ", 1);
        }
    }

    class Flasher
    extends TimerTask {
        Flasher() {
        }

        @Override
        public void run() {
            if (UpdateDialog.this.updateButton.getBackground().equals(UpdateDialog.this.origColor)) {
                UpdateDialog.this.updateButton.setBackground(UpdateDialog.this.myred);
            } else {
                UpdateDialog.this.updateButton.setBackground(UpdateDialog.this.origColor);
            }
        }
    }
}

