/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import bsh.EvalError;
import bsh.Interpreter;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jehep.shellbsh.JHEPConsole;
import jehep.shelljython.JyShell;
import jehep.ui.Constants;
import jehep.ui.Editor;
import jehep.ui.mainGUI;
import jehep.utils.BrowserLaunch;
import jehep.utils.GetWebFile;
import jehep.utils.MessageConsolePanel;
import jehep.utils.Util;
import jehep.utils.Utils;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.jruby.embed.ScriptingContainer;
import org.python.util.InteractiveInterpreter;

public class SetEnv
implements Constants {
    public static final String DataMeltWeb = "https://datamelt.org";
    public static final String SERVER_URL = "https://datamelt.org/support/";
    public static String SERVER_URL_UPDATE = "https://datamelt.org/support/current/jars/";
    public static final String JAVA_API = "http://docs.oracle.com/javase/9/docs/api/";
    public static final String DMELT_API = "https://datamelt.org/api/doc.php/";
    public static mainGUI win;
    public static String BUILD_DATE;
    public static String BUILD_BY;
    public static String VERSION;
    public static String TITLE;
    public static String OS;
    public static int BUILD_UPDATE_TIME;
    public static int isCodeView;
    private static String HardAddress;
    public static int markSize;
    public static boolean CheckFileTime;
    public static boolean CheckUpdates;
    public static String JHPLOT_BUILD_DATE;
    public static String JHPLOT_BUILD_BY;
    public static String JHPLOT_VERSION;
    public static String JHPLOT_JAR;
    public static boolean hasToBeRestarted;
    public static String JYTHON_VERSION;
    public static String JYTHON_INI;
    private static final int SECONDS = 3000;
    private static Timer timer;
    public static Locale locale;
    public static String LANGU;
    public static String OSsys;
    public static String DirPath;
    public static final String fSep;
    public static final String lSep;
    public static String curDir;
    public static String DicDir;
    public static String ProjDir;
    public static JButton jbtRunSpell;
    public static int ToSpell;
    public static JHEPConsole BSconsole;
    public static Interpreter BSin;
    public static JyShell JConsole;
    public static long time_current;
    public static long time_update;
    public static Font helpFont;
    public static boolean isGuiLoaded;
    public static Font globalFont;
    public static Font guiFont;
    public static int appWidth;
    public static int appHeight;
    public static Vector<String> BShistory;
    public static boolean FirstTime;
    public static String INIFILE;
    public static String INIRUN;
    public static List<String> RunComm;
    public static String RunCommText;
    public static final String RunCommTextDefault;
    public static String LookAndFeel;
    public static int SelectedDic;
    public static String SelectedDicName;
    public static JLabel MessageBar;
    public static Color FontColor;
    public static Font FontBold;
    public static Font FontPlain;
    public static SpellDictionary dict;
    public static SpellChecker checker;
    public static String INIDIR;
    public static String ClassPath;
    public static boolean isCommunity;

    public static void init() {
        int fontSize;
        win = null;
        String OS = System.getProperty("os.name").toLowerCase();
        RunComm = new ArrayList<String>();
        curDir = System.getProperty("user.dir");
        isGuiLoaded = false;
        hasToBeRestarted = false;
        JYTHON_VERSION = "Jython 2.5.1";
        time_update = time_current = System.currentTimeMillis() / 1000L;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int Sheight = screenSize.height;
        int Swidth = screenSize.width;
        if (Sheight > 10 && Swidth > 10) {
            appWidth = (int)(0.7 * (double)Swidth);
            appHeight = (int)(0.7 * (double)Sheight);
            fontSize = (int)Math.sqrt((double)appHeight / 2.5);
            if (fontSize < 4 || fontSize > 120) {
                fontSize = 16;
            }
            globalFont = new Font("Arial", 1, fontSize);
            guiFont = new Font("Arial", 1, fontSize - 2);
            markSize = fontSize - 3;
            if (markSize < 5 || markSize > 50) {
                markSize = 12;
            }
        } else {
            appWidth = 700;
            appHeight = 500;
            fontSize = 16;
            globalFont = new Font("Arial", 1, fontSize);
            guiFont = new Font("Arial", 1, fontSize - 2);
            markSize = 14;
        }
        DirPath = System.getProperty("jehep.home");
        if (DirPath == null) {
            try {
                DirPath = SetEnv.getJarContainingFolder(mainGUI.class);
                DirPath = DirPath.replace(fSep + "lib" + fSep + "jehep", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (DirPath == null) {
                Path currentRelativePath = Paths.get("", new String[0]);
                DirPath = currentRelativePath.toAbsolutePath().toString();
                DirPath = DirPath.replace(fSep + "lib" + fSep + "jehep", "");
            }
        }
        DicDir = DirPath + fSep + "dic";
        ClassPath = System.getProperty("java.class.path");
        RunCommText = RunCommTextDefault;
        String ss = "macros" + fSep + "system" + fSep + "sysjehep.py";
        if (DirPath.length() > 0) {
            ss = DirPath + fSep + ss;
        }
        JYTHON_INI = "execfile(\"" + ss + "\");";
        LookAndFeel = UIManager.getSystemLookAndFeelClassName();
        LANGU = "en";
        SelectedDic = 0;
        SelectedDicName = "no spelling";
        locale = new Locale(LANGU);
        Locale.setDefault(locale);
        ToSpell = 0;
        HardAddress = SetEnv.getSN().trim();
        INIDIR = System.getProperty("user.home") + File.separator + ".dmelt";
        OSsys = "linux";
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            OSsys = "windows";
            INIDIR = System.getProperty("user.home") + File.separator + "dmelt";
        }
        if (OS.startsWith("mac os x")) {
            OSsys = "mac";
        }
        INIFILE = INIDIR + File.separator + "jehep.pref";
        INIRUN = INIDIR + File.separator + "jehep.run";
        FontColor = Color.black;
        FontBold = new Font("Lucida Sans", 1, 14);
        FontPlain = new Font("Lucida Sans", 0, 14);
        MessageBar = new JLabel("");
        MessageBar.setFont(new Font("Lucida Sans", 0, 12));
        timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBar.setText("");
                timer.stop();
            }
        });
        timer.setRepeats(false);
        SetEnv.readManifest();
        SERVER_URL_UPDATE = SERVER_URL_UPDATE + VERSION + "/";
        Thread t = new Thread(){

            @Override
            public void run() {
                SetEnv.readJHplotManifest();
            }
        };
        t.start();
    }

    public static String getSN() {
        String mac = "123456789";
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (i.isLoopbackAddress() || i.isLinkLocalAddress() || !i.isSiteLocalAddress()) continue;
                    ip = i;
                }
            }
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                return mac;
            }
            byte[] mac_byte = network.getHardwareAddress();
            if (mac_byte == null) {
                return mac;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac_byte.length; ++i) {
                sb.append(String.format("%02X%s", mac_byte[i], i < mac_byte.length - 1 ? "" : ""));
            }
            mac = sb.toString();
        }
        catch (UnknownHostException e) {
            return mac;
        }
        catch (SocketException e) {
            return mac;
        }
        return mac.trim();
    }

    public static String getHardAddress() {
        return HardAddress;
    }

    public static void setHardAddress(String s) {
        HardAddress = s;
    }

    private static String getJarContainingFolder(Class aclass) throws Exception {
        File jarFile;
        CodeSource codeSource = aclass.getProtectionDomain().getCodeSource();
        if (codeSource.getLocation() != null) {
            jarFile = new File(codeSource.getLocation().toURI());
        } else {
            String path = aclass.getResource(aclass.getSimpleName() + ".class").getPath();
            String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
            jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            jarFile = new File(jarFilePath);
        }
        return jarFile.getParentFile().getAbsolutePath();
    }

    public static void showStatusBarText(String text) {
        MessageBar.setText(text);
        if (timer.isRunning()) {
            timer.restart();
        } else {
            timer.start();
        }
    }

    public static void showStatusBarTextAlways(String text) {
        if (timer.isRunning()) {
            timer.stop();
        }
        MessageBar.setText(text);
    }

    public static void loadDic(String file2) {
        try {
            dict = new OpenOfficeSpellDictionary(new ZipFile(file2), true);
            checker = new SpellChecker(dict);
            checker.setCaseSensitive(false);
        }
        catch (IOException ex) {
            ErrorMsgBox.show(ex);
        }
    }

    public static void removeDic() {
        dict = null;
        checker = null;
        System.gc();
    }

    public static void writeComm() {
        File fprop = new File(INIFILE);
        if (fprop.exists()) {
            try {
                FileOutputStream fout = new FileOutputStream(INIRUN);
                new PrintStream(fout).println(RunCommText);
                fout.close();
            }
            catch (IOException e) {
                System.err.println("Unable to write :" + INIRUN);
            }
        }
    }

    public static boolean checkSplash() {
        boolean tmp = true;
        try {
            String s;
            FileReader inF = new FileReader(INIFILE);
            BufferedReader br = new BufferedReader(inF);
            while ((s = br.readLine()) != null) {
                if (s.indexOf(".splash") == -1 || s.indexOf("0") == -1) continue;
                tmp = false;
                break;
            }
            inF.close();
        }
        catch (IOException e) {
            int separ;
            String sname;
            String dirprop;
            File td;
            boolean succ1;
            File fprop = new File(INIFILE);
            if (!fprop.exists() && !(succ1 = (td = new File(dirprop = (sname = fprop.getAbsolutePath()).substring(0, separ = sname.lastIndexOf(fSep)))).mkdir())) {
                System.out.println("Cannot make:" + dirprop);
            }
            return tmp;
        }
        return tmp;
    }

    public static void readComm() {
        RunCommText = "";
        try {
            String s;
            FileReader inF = new FileReader(INIRUN);
            BufferedReader br = new BufferedReader(inF);
            while ((s = br.readLine()) != null) {
                RunCommText = RunCommText + s + lSep;
            }
            inF.close();
        }
        catch (IOException e) {
            RunCommText = RunCommTextDefault;
        }
    }

    public static String readFile(String file2) {
        String tmp = "";
        try {
            String s;
            FileReader inF = new FileReader(file2);
            BufferedReader br = new BufferedReader(inF);
            while ((s = br.readLine()) != null) {
                tmp = tmp + s + lSep;
            }
            inF.close();
        }
        catch (IOException e) {
            System.err.println("Unable to read :" + file2);
        }
        return tmp;
    }

    public static boolean runDefaultCommands() {
        for (int i = 0; i < RunComm.size(); ++i) {
            String s = RunComm.get(i);
            StringTokenizer st = new StringTokenizer(s, " ");
            int ncount = st.countTokens();
            String[] sword = new String[ncount];
            if (ncount != 2) {
                System.out.println("Wrong defintion of the command:" + s);
                return false;
            }
            int m = 0;
            while (st.hasMoreTokens()) {
                sword[m] = st.nextToken();
                sword[m] = sword[m].trim();
                ++m;
            }
            String ss = null;
            if (Editor.DocName().endsWith(sword[0])) {
                ss = DirPath + fSep + "macros" + fSep + "user" + fSep + sword[1];
            }
            if (ss == null) continue;
            if (OSsys.equals("windows")) {
                ss = ss.replace("\\", "\\\\");
            }
            BSconsole.Execute("source(\"" + ss + "\")");
            return true;
        }
        return false;
    }

    public static void cdProjectDir() {
        String ss = ProjDir;
        if (OSsys.equals("windows")) {
            ss = ss.replace("\\", "\\\\");
        }
        String schange = "cd(\"" + ss + "\");";
        BSconsole.Execute(schange);
        schange = "pwd();";
        BSconsole.Execute(schange);
    }

    public static void buildComm() {
        RunComm.clear();
        RunCommText = RunCommText.trim();
        if (RunCommText.length() > 0) {
            StringTokenizer st = new StringTokenizer(RunCommText, lSep);
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                if ((tmp = tmp.trim()).startsWith("#")) continue;
                RunComm.add(tmp.trim());
            }
        }
    }

    public static void iniBsh() {
        BSconsole.setFont(globalFont);
        try {
            String ss = "macros" + fSep + "system" + fSep + "sysjehep.bsh";
            if (DirPath.length() > 0) {
                ss = DirPath + fSep + ss;
            }
            if (OSsys.equals("windows")) {
                ss = ss.replace("\\", "\\\\");
            }
            BSin.source(ss);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (EvalError e1) {
            e1.printStackTrace();
        }
    }

    public static void iniJyShell() {
        JYTHON_VERSION = JConsole.getVersion();
        JConsole.runPythonCmd(JYTHON_INI);
    }

    public static void processJRubyMacro(final String scriptname) {
        Thread t = new Thread("running jruby"){

            @Override
            public void run() {
                ScriptingContainer jruby = new ScriptingContainer();
                jruby.runScriptlet(scriptname);
            }
        };
        t.start();
    }

    public static void processGroovyMacro(final String scriptname, MessageConsolePanel mconsole) {
        final Binding binding = new Binding();
        final StringWriter stringWriter = new StringWriter();
        binding.setProperty("stdin", (Object)new PrintWriter(stringWriter));
        binding.setProperty("stdout", (Object)new PrintWriter(stringWriter));
        binding.setProperty("stderr", (Object)new PrintWriter(stringWriter));
        Thread t = new Thread("running groovy"){

            @Override
            public void run() {
                GroovyShell shell = new GroovyShell(binding);
                Object script = shell.evaluate(scriptname);
                System.out.println(stringWriter.toString() + "# done");
            }
        };
        t.start();
    }

    public static void iniJRuby() {
    }

    public static void JyRunFile(String file2) {
        if (JConsole == null) {
            Utils.userMessage("Error", "Wait for 2-3 sec! Jython is loading..", 1);
            return;
        }
        JConsole.runPythonCmd("print '\\n'");
        JConsole.executePythonFile(new File(file2));
    }

    public static InteractiveInterpreter JyInterpreter() {
        return JConsole.getPythonInterpreter();
    }

    public static void JyRunCMD(String line) {
        if (JConsole == null) {
            Utils.userMessage("Error", "Wait for 2-3 sec! Jython is loading..", 1);
            return;
        }
        JConsole.runPythonCmd(line);
    }

    public static String filesList(String dir2, String extension) {
        return Util.getListFiles(dir2, extension);
    }

    public static String filesListStrip(String dir2, String extension) {
        String s = Util.getListFiles(dir2, extension);
        s = s.replace(dir2 + fSep, "");
        return s;
    }

    public static String jarDirectories(String dirName) {
        String tmp = "";
        File dir2 = new File(dirName);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file2) {
                return file2.isDirectory();
            }
        };
        File[] directories = dir2.listFiles(fileFilter);
        for (int i = 0; i < directories.length; ++i) {
            String ss = directories[i].toString();
            int k1 = ss.lastIndexOf(fSep);
            String g = ss.substring(k1 + 1);
            tmp = tmp + " -C " + dirName + "  " + g;
        }
        return tmp;
    }

    public static boolean filesRemove(String dir2, String extension) {
        return Util.removeListFiles(dir2, extension);
    }

    public static void readManifest() {
        String manf = DirPath + fSep + "lib" + fSep + "jehep" + fSep + "jehep.jar";
        BUILD_DATE = "20150120";
        BUILD_BY = "S.Chekanov";
        VERSION = "1.1";
        try {
            JarFile jar = new JarFile(manf);
            Manifest manifest = jar.getManifest();
            Attributes attribs = manifest.getMainAttributes();
            BUILD_DATE = attribs.getValue("Built-Date");
            BUILD_BY = attribs.getValue("Built-By");
            VERSION = attribs.getValue("Version");
        }
        catch (IOException e) {
            System.out.println("Cannot read jar-file manifest: " + manf);
        }
    }

    public static void readJHplotManifest() {
        String manf = DirPath + fSep + "lib" + fSep + "system" + fSep + "jhplot.jar";
        JHPLOT_BUILD_DATE = "20070120";
        JHPLOT_BUILD_BY = "S.Chekanov";
        JHPLOT_VERSION = "1.7";
        try {
            JarFile jar = new JarFile(manf);
            Manifest manifest = jar.getManifest();
            Attributes attribs = manifest.getMainAttributes();
            JHPLOT_BUILD_DATE = attribs.getValue("Built-Date");
            JHPLOT_BUILD_BY = attribs.getValue("Built-By");
            JHPLOT_VERSION = attribs.getValue("Version");
        }
        catch (IOException e) {
            System.out.println("Cannot read jar-file manifest: " + manf);
        }
    }

    public static void updateFromWeb(final String fileToupdate, final String prefix) {
        final String oldcopy = DirPath + fSep + "lib" + fSep + "system" + fSep + fileToupdate;
        final String updatedir = DirPath + fSep + "lib" + fSep + "update";
        SetEnv.showStatusBarText("Start update for: " + fileToupdate);
        Thread t = new Thread(){

            @Override
            public void run() {
                GetWebFile.getfile(fileToupdate, SetEnv.SERVER_URL, prefix, oldcopy, updatedir);
            }
        };
        t.start();
    }

    public static void updateJarFromWeb(final String fileToupdate, final String oldcopy, final String updatedir) {
        SetEnv.showStatusBarText("Start update for: " + fileToupdate);
        Thread t = new Thread(){

            @Override
            public void run() {
                GetWebFile.getfile(fileToupdate, SetEnv.SERVER_URL, "", oldcopy, updatedir);
            }
        };
        t.start();
    }

    public static void RefreshBS() {
        Thread t = new Thread("refreshing beanshell"){

            @Override
            public void run() {
                BSconsole = new JHEPConsole();
                BSin = new Interpreter(BSconsole);
                new Thread(BSin).start();
                SetEnv.iniBsh();
                System.gc();
            }
        };
        t.start();
    }

    public static void RefreshJS() {
        Thread t = new Thread("refreshing beanshell"){

            @Override
            public void run() {
                JConsole = new JyShell();
                SetEnv.iniJyShell();
                System.gc();
            }
        };
        t.start();
    }

    public static void RefreshJSsoft() {
        Thread t = new Thread("refreshing beanshell"){

            @Override
            public void run() {
                JConsole.clear();
                System.gc();
            }
        };
        t.start();
    }

    public static JEditorPane getMessage(String message) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\">" + message + "</body></html>");
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        ep.setEditable(false);
        return ep;
    }

    public static void searchDM(int page) {
        String a_letter;
        String a_letter2;
        String smes = "<html><b>Word for searching is not selected, too short or too common. <br> Highlight a word and try again.</b></html>";
        String txt = Editor.Page[page].getSelectedText();
        if (txt == null) {
            JOptionPane.showMessageDialog(win, "<html><b>Word for searching is not selected, too short or too common. <br> Highlight a word and try again.</b></html>", "Error", 0);
            return;
        }
        if ((txt = txt.trim()).length() < 3 || txt.startsWith("//") || txt.equals("from") || txt.equals("import") || txt.equals("java") || txt.equals("and") || txt.equals("datamelt") || txt.equals("python") || txt.equals("jython")) {
            JOptionPane.showMessageDialog(win, "<html><b>Word for searching is not selected, too short or too common. <br> Highlight a word and try again.</b></html>", "Error", 0);
            return;
        }
        if (txt.length() > 80) {
            JOptionPane.showMessageDialog(win, "Too long string to process. Select a shorter word.", "Error", 0);
            return;
        }
        String[] ss = txt.split(" ");
        if (ss.length > 1) {
            txt = ss[0].trim();
        }
        int nstart = Editor.Page[page].getSelectionStart();
        int nend = nstart + txt.length();
        String text = Editor.Page[page].getText();
        int total = text.length();
        boolean isBeggining = false;
        if (nstart > 0 && nstart < total && (a_letter2 = Character.toString(text.charAt(nstart - 1))).trim().length() > 0) {
            isBeggining = true;
        }
        boolean isEnd = false;
        if (nend > nstart && nend < total - 1 && (a_letter = Character.toString(text.charAt(nend))).trim().length() > 0) {
            isEnd = true;
        }
        if (isBeggining) {
            txt = "*" + txt;
        }
        if (isEnd) {
            txt = txt + "*";
        }
        if (!isBeggining && !isEnd) {
            int b = Editor.Page[page].getLineOfOffset(Editor.Page[page].getCaretPosition());
            String txtImport = Editor.Page[page].getLineText(b);
            int i1 = txtImport.indexOf("from");
            int i2 = txtImport.indexOf("import");
            int i3 = txtImport.indexOf(txt);
            if (i1 > -1 && i2 > -1 && i2 > i1 && i3 > i2) {
                txt = "*." + txt;
            }
        }
        String searchstring = "https://datamelt.org/search/form.php?query=" + txt;
        BrowserLaunch.openURL(searchstring);
    }

    public static void lookupAPI(int page) {
        int b = Editor.Page[page].getLineOfOffset(Editor.Page[page].getCaretPosition());
        String txt = Editor.Page[page].getLineText(b);
        if (txt == null) {
            return;
        }
        String tmp = txt.trim();
        if (tmp.startsWith("#") || tmp.startsWith("//")) {
            JOptionPane.showMessageDialog(win, "No import statement on this line! Commented out?", "Error", 0);
            return;
        }
        int aaa = tmp.indexOf("#");
        if (aaa > -1) {
            tmp = tmp.substring(0, aaa);
        }
        if ((aaa = tmp.indexOf("//")) > -1) {
            tmp = tmp.substring(0, aaa);
        }
        tmp = tmp.replace(";", "");
        tmp = tmp.replaceAll("\\s+", " ").trim();
        tmp = tmp.replace("\n", "");
        int index = tmp.indexOf("import");
        boolean err = true;
        String[] parts = tmp.split(" ");
        if (parts[0].equals("import")) {
            String pack = parts[1];
            String API = pack.replace(".", "/");
            API = API.replace("*", "package-summary");
            String WWW_API = null;
            WWW_API = pack.indexOf("java") > -1 ? JAVA_API + API + ".html" : DMELT_API + API;
            BrowserLaunch.openURL(WWW_API);
            return;
        }
        String pack = null;
        ArrayList<String> methods = new ArrayList<String>();
        if (parts.length > 3 && parts[0].equals("from")) {
            int k;
            pack = parts[1];
            String classes = tmp.substring(index + 6, tmp.length());
            classes = classes.replaceAll("\\s", "");
            String[] m_class = classes.split(",");
            for (k = 0; k < m_class.length; ++k) {
                methods.add(m_class[k]);
            }
            for (k = 0; k < methods.size(); ++k) {
                err = false;
                String cc = ((String)methods.get(k)).replace(".", "/");
                String API = pack.replace(".", "/") + "/" + cc;
                String WWW_API = null;
                API = API.replace("*", "package-summary");
                WWW_API = pack.indexOf("java") > -1 ? JAVA_API + API + ".html" : DMELT_API + API;
                BrowserLaunch.openURL(WWW_API);
            }
        }
        if (err) {
            JOptionPane.showMessageDialog(win, "No \"import\" statement on this line! Please move the cursor to the line with the import of a package!", "Error", 0);
        }
    }

    public static void globalReload() {
    }

    public static void printThreads() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread t : threads) {
            String name = t.getName();
            Thread.State state = t.getState();
            int priority = t.getPriority();
            String type = t.isDaemon() ? "Daemon" : "Normal";
            System.out.printf("%-20s \t %s \t %d \t %s\n", new Object[]{name, state, priority, type});
        }
    }

    public static double getProcessCpuLoad() {
        double tmp = -1.0;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            tmp = (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            tmp = -1.0;
        }
        return tmp;
    }

    static {
        BUILD_UPDATE_TIME = 45000;
        isCodeView = -1;
        HardAddress = "123456789";
        markSize = 15;
        CheckFileTime = true;
        CheckUpdates = true;
        JHPLOT_JAR = "jhplot.jar";
        fSep = System.getProperty("file.separator");
        lSep = System.getProperty("line.separator");
        time_current = 0L;
        time_update = 0L;
        helpFont = new Font("Arial", 0, 10);
        appWidth = 600;
        appHeight = 400;
        BShistory = new Vector();
        FirstTime = false;
        INIFILE = "";
        INIRUN = "";
        RunCommTextDefault = "# <extension>  <file to execute>" + lSep + ".cxx   run_make.bsh" + lSep + ".tex   run_latex.bsh" + lSep + ".java  run_java.bsh" + lSep;
        isCommunity = false;
    }
}

