/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import jehep.ui.Constants;
import jehep.ui.PanelFiles;
import jehep.ui.PanelStructure;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import tabclose.CloseListener;
import tabclose.CloseTabbedPane;

public class PanelLeft
extends JPanel
implements MouseListener,
Constants {
    private mainGUI win;
    private CloseTabbedPane jtab;
    private PanelFiles jPanelFiles;
    private PanelStructure jPanelStructure;
    private static final long serialVersionUID = 1L;

    public PanelLeft(mainGUI win) {
        this.win = win;
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        this.jPanelFiles = new PanelFiles(this.win);
        this.jPanelStructure = new PanelStructure(this.win);
        this.jtab = new CloseTabbedPane(1);
        this.jtab.addCloseListener(new CloseListener(){

            @Override
            public void closeOperation(MouseEvent e) {
                int tabNumber = PanelLeft.this.jtab.getOverTabIndex();
                if (tabNumber == 0) {
                    PanelLeft.this.RefreshFileBrowser();
                }
                if (tabNumber == 1) {
                    PanelLeft.this.RefreshStructure();
                }
            }
        });
        this.jtab.setFont(SetEnv.guiFont);
        this.jtab.addTab(" Files ", this.jPanelFiles);
        this.jtab.addTab(" Structure ", this.jPanelStructure);
        this.add(this.jtab);
    }

    public void setProjectDir() {
        this.jPanelFiles.setProjectDir();
    }

    public void RefreshFileBrowser() {
        this.jPanelFiles.reloadFileBrowser();
    }

    public void RefreshStructure() {
        this.jPanelStructure.Refresh();
        this.repaint();
    }

    public void Repaint() {
        this.jPanelStructure.Repaint();
        this.repaint();
    }

    public void ClearStructure() {
        this.jPanelStructure.Clear();
    }

    public void setProject() {
        this.jPanelFiles.setProject();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

