/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jehep.fbrowser.FBException;
import jehep.fbrowser.JTreeTable;
import jehep.fbrowser.RegularFileSystemModel;
import jehep.ui.Constants;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class PanelFiles
extends JPanel
implements MouseListener,
Constants {
    private mainGUI win;
    private JTreeTable mtree;
    private JTree jtree;
    private JScrollPane scroll;
    private RegularFileSystemModel model;
    private static final long serialVersionUID = 1L;

    public PanelFiles(final mainGUI win) {
        this.win = win;
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        try {
            this.model = new RegularFileSystemModel(SetEnv.ProjDir);
        }
        catch (FBException e1) {
            e1.printStackTrace();
        }
        this.mtree = new JTreeTable(this.model, this);
        this.mtree.setCellSelectionEnabled(false);
        TableColumn column0 = null;
        column0 = this.mtree.getColumnModel().getColumn(0);
        column0.setPreferredWidth(250);
        column0.setMinWidth(100);
        column0.setMaxWidth(4000);
        column0 = this.mtree.getColumnModel().getColumn(1);
        column0.setPreferredWidth(100);
        column0.setMinWidth(20);
        column0.setMaxWidth(200);
        column0 = this.mtree.getColumnModel().getColumn(2);
        column0.setPreferredWidth(60);
        column0.setMinWidth(20);
        column0.setMaxWidth(200);
        this.jtree = this.mtree.getTree();
        this.mtree.addMouseListener(this);
        this.jtree.setFont(SetEnv.guiFont);
        this.jtree.setShowsRootHandles(true);
        this.jtree.putClientProperty("JTree.lineStyle", "Angled");
        this.jtree.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(openIcon);
        renderer.setClosedIcon(closedIcon);
        renderer.setLeafIcon(leafIcon);
        this.jtree.setCellRenderer(renderer);
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int clickedrow;
                if (!SetEnv.isGuiLoaded) {
                    System.out.println("Gui is loading... Click in 1-2 sec");
                }
                if (e.getClickCount() == 2 && SetEnv.isGuiLoaded && (clickedrow = PanelFiles.this.jtree.getRowForLocation(e.getX(), e.getY())) != -1) {
                    TreePath treepath = PanelFiles.this.jtree.getPathForRow(clickedrow);
                    String str = new String(treepath.toString());
                    int inx = str.indexOf(", ");
                    str = inx > -1 ? str.substring(inx + 2, str.length() - 1) : str.substring(1, str.length() - 1);
                    str = str.replace(", ", SetEnv.fSep);
                    String w = SetEnv.ProjDir + SetEnv.fSep + str;
                    File file2 = new File(w);
                    if (file2.exists() && !file2.isDirectory() && file2.canRead()) {
                        win.open(w, false);
                    }
                }
            }
        });
        this.scroll = new JScrollPane(this.mtree);
        Color cc = Color.white;
        this.mtree.setBackground(cc);
        this.jtree.setBackground(cc);
        this.scroll.getViewport().setBackground(cc);
        this.scroll.setWheelScrollingEnabled(true);
        this.setBackground(cc);
        this.add(this.scroll);
    }

    public void setProjectDir() {
        String s = null;
        JFileChooser jfc = new JFileChooser(SetEnv.ProjDir);
        jfc.setFont(SetEnv.guiFont);
        jfc.isDirectorySelectionEnabled();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(this) == 0) {
            s = jfc.getSelectedFile().getPath();
        }
        this.repaint();
        if (s == null) {
            return;
        }
        File f = new File(s);
        if (f.exists() && f.isDirectory()) {
            SetEnv.ProjDir = s;
            this.setProject();
        }
    }

    public void setProject() {
        try {
            this.model = new RegularFileSystemModel(SetEnv.ProjDir);
            this.jtree.setModel(this.model);
            this.jtree.updateUI();
            this.jtree.getSelectionModel().setSelectionMode(1);
            this.repaint();
        }
        catch (FBException e) {
            e.printStackTrace();
        }
    }

    public void reloadFileBrowser() {
        if (this.jtree.isSelectionEmpty() && this.jtree.getRowCount() > 0) {
            this.jtree.setSelectionRow(0);
        }
        this.mtree.refreshFile();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

