/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import jehep.ui.Login;

public class LoginDialog
extends JDialog {
    private JTextField tfUsername;
    private JPasswordField pfPassword;
    private JLabel lbUsername;
    private JLabel lbPassword;
    private JButton btnLogin;
    private JButton btnCancel;
    private boolean succeeded;

    public LoginDialog(Frame parent) {
        super(parent, "DMelt-Pro activation", true);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.fill = 2;
        this.lbUsername = new JLabel("Username: ");
        cs.gridx = 0;
        cs.gridy = 0;
        cs.gridwidth = 1;
        panel.add((Component)this.lbUsername, cs);
        this.tfUsername = new JTextField(20);
        cs.gridx = 1;
        cs.gridy = 0;
        cs.gridwidth = 2;
        panel.add((Component)this.tfUsername, cs);
        this.lbPassword = new JLabel("Password: ");
        cs.gridx = 0;
        cs.gridy = 1;
        cs.gridwidth = 1;
        panel.add((Component)this.lbPassword, cs);
        this.pfPassword = new JPasswordField(20);
        cs.gridx = 1;
        cs.gridy = 1;
        cs.gridwidth = 2;
        panel.add((Component)this.pfPassword, cs);
        panel.setBorder(new LineBorder(Color.GRAY));
        this.btnLogin = new JButton("Activate");
        this.btnLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Login.authenticate(LoginDialog.this.getUsername(), LoginDialog.this.getPass())) {
                    LoginDialog.this.succeeded = true;
                    LoginDialog.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(LoginDialog.this, "Invalid username or password. Too short username or password?", "Login", 0);
                    LoginDialog.this.tfUsername.setText("");
                    LoginDialog.this.pfPassword.setText("");
                    LoginDialog.this.succeeded = false;
                }
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.dispose();
            }
        });
        JPanel bp = new JPanel();
        bp.add(this.btnLogin);
        bp.add(this.btnCancel);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)bp, "Last");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public String getUsername() {
        return this.tfUsername.getText().trim();
    }

    public String getPass() {
        return new String(this.pfPassword.getPassword());
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }
}

