/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jehep.utils.BrowserLaunch;
import jehep.utils.ResourceLoader;
import jehep.utils.Util;

public class HelpDialog
extends JDialog {
    private JButton closeButton;
    private JPanel panel1;
    private String what = "jython";

    public HelpDialog(JFrame win, String what) {
        this.what = what.toLowerCase();
        this.setDefaultCloseOperation(2);
        this.setTitle(what);
        this.setModal(true);
        this.setResizable(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(580, res.width), Math.min(380, res.height));
        this.setSize(size);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(580, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpDialog.this.setVisible(false);
                HelpDialog.this.dispose();
            }
        });
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.createPage1();
        topPanel.add((Component)this.panel1, "Center");
        Util.centreWithin(win, this);
        this.setVisible(true);
    }

    public void createPage1() {
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout());
        JEditorPane epane = new JEditorPane();
        epane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        epane.setAutoscrolls(true);
        epane.setEditable(false);
        epane.setBackground(new Color(250, 251, 251));
        epane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    BrowserLaunch.openURL(e.getURL().toString());
                }
            }
        });
        String hstr = "jython_help.html";
        if (this.what.equals("jython")) {
            hstr = "jython_help.html";
        } else if (this.what.equals("beanshell")) {
            hstr = "beanshell_help.html";
        } else if (this.what.equals("groovy")) {
            hstr = "beanshell_help.html";
        } else if (this.what.equals("jmathlab")) {
            hstr = "jmathlab_help.html";
        } else if (this.what.equals("output")) {
            hstr = "output_help.html";
        }
        URL page = ResourceLoader.getResourceURL("#standards/" + hstr);
        try {
            epane.setPage(page);
        }
        catch (Exception e) {
            System.err.println("Couldn't create URL: " + hstr);
            epane.setContentType("text/plain");
        }
        JScrollPane jsp = new JScrollPane(epane);
        this.panel1.add(jsp);
    }
}

