/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import jehep.syntax.SyntaxDocument;
import jehep.syntax_check.Checker;
import jehep.textparse.StructTree;
import jehep.ui.BMarks;
import jehep.ui.Constants;
import jehep.ui.JehepTextArea;
import jehep.ui.SetEnv;
import jehep.utils.Utils;
import jehep.utils.VasJava2HTML;
import jehep.utils.VasJython2HTML;

public class Editor
implements Constants {
    public static final int Max = 50;
    public static JehepTextArea[] Page = new JehepTextArea[50];
    public static StructTree[] Struc = new StructTree[50];
    public static String[] fileNames = new String[50];
    public static BMarks[] bmarks = new BMarks[50];
    public static String DocStyle;
    public static int BracketStyle;
    public static String DocName;
    public static JehepTextArea jta;
    public static int LineNumber;
    public static int ColumnNumber;
    public static int Selected;
    public static Set<String>[] AcceptedWords;
    public static Set<String>[] BadWords;
    public static boolean ignoreCase;
    public static boolean wholeWord;
    public static boolean wrap;
    public static boolean runFind;
    public static boolean replaceAll;
    public static boolean replace;
    public static boolean replaceFinished;
    public static int pos;
    private static int counter;
    public static Color LineColor;
    public static final Color ErrorSyntaxLineColor;
    public static final Color ErrorLineColor;
    private static int lastpos;
    public static int LastPos;
    public static int ErrorLine;
    public static int ErrorSyntaxLine;

    public static void init() {
        Selected = 0;
        ignoreCase = false;
        wholeWord = true;
        wrap = true;
        DocStyle = "tex";
        DocName = "none";
        ErrorLine = -1;
        LineColor = Color.lightGray;
        jta = new JehepTextArea();
        jta.getPainter().setFont(SetEnv.guiFont);
        jta.setTokenMarker(null);
        jta.setCaretVisible(false);
        jta.getPainter().setCaretColor(LineColor);
        jta.getPainter().setLineHighlightEnabled(true);
        jta.getPainter().setLineHighlightColor(Color.lightGray);
        jta.getPainter().setSelectionColor(Color.white);
        jta.setRequestFocusEnabled(true);
        jta.setEditable(false);
    }

    public static void iniWords(int i) {
        if (i < 50) {
            Editor.AcceptedWords[i] = new HashSet<String>();
            Editor.BadWords[i] = new HashSet<String>();
        } else {
            System.out.println("Too many pages requested!");
        }
    }

    private static void markLine(int line) {
        ErrorLine = line;
        Editor.goToLine(line);
        Editor.setLineHighlightEnabled(true);
        Editor.setLineHighlightColor(ErrorLineColor);
    }

    public static void flashLine(int line) {
        Editor.setLineHighlightEnabled(true);
        Color LineColor = Editor.getLineHighlightColor();
        Editor.setLineHighlightColor(Color.green);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Editor.setLineHighlightColor(LineColor);
    }

    public static void findErrorLine(String serror) {
        int nline = serror.indexOf(".py");
        if (nline > -1) {
            String ss = serror.substring(nline + 4, serror.length());
            StringTokenizer st = new StringTokenizer(ss);
            while (st.hasMoreTokens()) {
                String skk = st.nextToken();
                skk = skk.replace(",", "");
                if ((skk = skk.trim()).length() < 1) continue;
                try {
                    int line = Integer.parseInt(skk);
                    Editor.markLine(line);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }

    public static String getTextCurrentLine() {
        int b = jta.getLineOfOffset(jta.getCaretPosition());
        return jta.getLineText(b);
    }

    public static int getErrorLine() {
        Checker ch = new Checker();
        ErrorSyntaxLine = ch.getErrorLine();
        return ErrorSyntaxLine;
    }

    public static String DocDir() {
        String tmp = "";
        String s = Editor.DocName();
        int inx = s.lastIndexOf(SetEnv.fSep);
        if (inx > -1) {
            tmp = s.substring(0, inx);
        }
        return tmp;
    }

    public static String DocStyle() {
        return DocStyle;
    }

    public static Font getFont() {
        return Page[Selected].getPainter().getFont();
    }

    public static void setFont(Font f) {
        Page[Selected].getPainter().setFont(f);
    }

    public static String DocName() {
        DocName = "none";
        if (fileNames[Selected] == null) {
            return DocName;
        }
        DocName = fileNames[Selected];
        return DocName;
    }

    public static String DocMasterName() {
        String tmp = Editor.DocName();
        int fdot = tmp.lastIndexOf(".");
        if (fdot > -1) {
            tmp = tmp.substring(0, fdot);
        }
        return tmp;
    }

    public static String DocMasterNameShort() {
        String s = Editor.DocMasterName();
        int fdir = s.lastIndexOf(SetEnv.fSep);
        if (fdir > -1) {
            int nlen = s.length();
            s = s.substring(fdir + 1, nlen);
        }
        return s;
    }

    public static Set<String> AcceptedWords() {
        return AcceptedWords[Selected];
    }

    public static Set<String> BadWords() {
        return BadWords[Selected];
    }

    public static void Paste() {
        Page[Selected].paste();
    }

    public static void selectAll() {
        Page[Selected].selectAll();
    }

    public static SyntaxDocument getDocument() {
        return Page[Selected].getDocument();
    }

    public static JehepTextArea get() {
        return Page[Selected];
    }

    public static void goToLine(int line) {
        int a = Page[Selected].getLineCount();
        if (a < 2) {
            return;
        }
        if (line > a) {
            return;
        }
        if (line < 1) {
            return;
        }
        try {
            Editor.grabFocus();
            Page[Selected].setCaretPosition(Page[Selected].getLineStartOffset(line - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delLine() {
        int b = Page[Selected].getCaretPosition();
        try {
            int a = Page[Selected].getLineOfOffset(b);
            int start = Page[Selected].getLineStartOffset(a);
            int end2 = Page[Selected].getLineEndOffset(a);
            Page[Selected].select(start, end2);
            Page[Selected].setSelectedText("");
        }
        catch (Exception ex) {
            System.out.println("Error deleting line " + ex.getMessage());
            Utils.userMessage("Error", SYSTEM_ERROR, 1);
            Utils.writeErrorLog("Error deleting line " + ex.getMessage());
        }
    }

    public static String getSelectedText() {
        String s = Page[Selected].getSelectedText();
        return s;
    }

    public static String getLastSelectedText() {
        String s = Page[Selected].getLastSelectedText();
        return s;
    }

    public static void setLastSelectedText(String a) {
        Page[Selected].setLastSelectedText(a);
    }

    public static void requestFocusInWindow() {
        Page[Selected].requestFocusInWindow();
    }

    public static void grabFocus() {
        if (SetEnv.isCodeView > -1) {
            return;
        }
        Page[Selected].grabFocus();
    }

    public static void ScrollToLine(int a) {
        int itot = Page[Selected].getLineCount();
        int ivis = Page[Selected].getVisibleLines();
        ivis = (int)(0.5 * (double)ivis);
        boolean suc = false;
        if (a + ivis < itot) {
            suc = Page[Selected].scrollTo(a + ivis, 0);
        }
    }

    public static void select(int a, int b) {
        Page[Selected].select(a, b);
    }

    public static int getSelectionStart() {
        return Page[Selected].getSelectionStart();
    }

    public static int getSelectionEnd() {
        return Page[Selected].getSelectionEnd();
    }

    public static void setCaretPos(int a) {
        Page[Selected].setCaretPosition(a);
    }

    public static int getCaretPos() {
        return Page[Selected].getCaretPosition();
    }

    public static Color getLineHighlightColor() {
        return Page[Selected].getPainter().getLineHighlightColor();
    }

    public static void setLineHighlightEnabled(boolean doit) {
        Page[Selected].getPainter().setLineHighlightEnabled(doit);
    }

    public static void setLineHighlightColor(Color lineHighlightColor) {
        Page[Selected].getPainter().setLineHighlightColor(lineHighlightColor);
    }

    public static void replaceSelection(String t) {
        Page[Selected].setSelectedText(t);
    }

    public static Color getCaretColor() {
        return Page[Selected].getPainter().getCaretColor();
    }

    public static void setCaretColor(Color caretColor) {
        Page[Selected].getPainter().setCaretColor(caretColor);
    }

    public static void RefreshDoc() {
        int line = Page[Selected].getLineCount();
        int a = Page[Selected].getCaretPosition();
        int aX = Page[Selected].getScrollX();
        int aY = Page[Selected].getScrollY();
        try {
            Page[Selected].grabFocus();
            Page[Selected].setCaretPosition(Page[Selected].getLineStartOffset(line - 1));
        }
        catch (Exception ex) {
            System.out.println("Error sweeping document");
        }
        Page[Selected].setCaretPosition(a);
        Page[Selected].setScrollX(aX);
        Page[Selected].setScrollY(aY);
    }

    public static void setLine() {
    }

    public static int getSelectionStartLine() {
        return Page[Selected].getSelectionStartLine();
    }

    public static void setEditable(boolean s) {
        Page[Selected].setEditable(s);
    }

    public static int getSelectionEndLine() {
        return Page[Selected].getSelectionEndLine();
    }

    public static void setSelectedText(String s) {
        Page[Selected].setSelectedText(s);
    }

    public static String getText() {
        return Page[Selected].getText();
    }

    public static int getLineCount() {
        return Page[Selected].getLineCount();
    }

    public static String getLineText(int a) {
        return Page[Selected].getLineText(a);
    }

    public static int getCaretPosition() {
        return Page[Selected].getCaretPosition();
    }

    public static void setCaretPositionNoScroll(int a) {
        Page[Selected].setCaretPositionNoScroll(a);
    }

    public static void setCaretPosition(int a) {
        Page[Selected].setCaretPosition(a);
    }

    public static int getLineOfOffset(int pos) {
        return Page[Selected].getLineOfOffset(pos);
    }

    public static int getLineStartOffset(int pos) {
        return Page[Selected].getLineStartOffset(pos);
    }

    public static int getLineEndOffset(int pos) {
        return Page[Selected].getLineEndOffset(pos);
    }

    public static boolean isGutterCollapsed() {
        return Page[Selected].getGutter().isCollapsed();
    }

    public static int getColumn() {
        int a = Page[Selected].getLineStartOffset(Page[Selected].getLineOfOffset(Page[Selected].getCaretPosition()));
        int c = Page[Selected].getCaretPosition();
        ColumnNumber = c - a;
        return ColumnNumber;
    }

    public static int getLine() {
        int b = Page[Selected].getLineOfOffset(Page[Selected].getCaretPosition());
        return LineNumber;
    }

    public static void insetText(String str, int pos) {
        Page[Selected].insert(str, pos);
    }

    public static void insetTextCaret(String str) {
        Page[Selected].insert(str, Editor.getCaretPosition());
    }

    public static boolean FindFast(String whatTofind) {
        String s = Page[Selected].getText();
        if (whatTofind == null || s == null) {
            return false;
        }
        if (whatTofind.length() < 1 || s.length() < 1) {
            return false;
        }
        pos = s.indexOf(whatTofind = whatTofind.trim(), LastPos);
        if (pos == -1) {
            SetEnv.MessageBar.setText(whatTofind + " was not found");
            LastPos = 0;
            return false;
        }
        LastPos = pos + whatTofind.length();
        int LastLine = 1 + Page[Selected].getLineOfOffset(LastPos);
        SetEnv.MessageBar.setText(whatTofind + " found on line " + LastLine);
        Editor.select(pos, pos + whatTofind.length());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean FindNext(String whatTofind) {
        String str;
        String s = Page[Selected].getText();
        if (whatTofind.equals("") || whatTofind == null) {
            Utils.userMessage("Nothing to search for", "Nothing to search for", 2);
            return false;
        }
        String findstr = whatTofind;
        if (ignoreCase) {
            s = s.toLowerCase();
            str = findstr.toLowerCase();
        } else {
            str = findstr;
        }
        if (wholeWord) {
            str = " " + str + " ";
        } else {
            str.trim();
        }
        if (str != null) {
            int a = str.length();
            int pos = s.indexOf(str, Editor.getCaretPos());
            lastpos = s.lastIndexOf(str);
            if (pos != -1) {
                Editor.select(pos, pos + findstr.length());
                return true;
            }
            if (wrap) {
                pos = s.indexOf(findstr, 0);
                Editor.select(pos, pos + findstr.length());
                return true;
            }
            Utils.userMessage("Not Found", findstr + " not found", 1);
            return false;
        }
        if (!replaceAll) {
            Utils.userMessage("String not found", "String '" + findstr + "' not found", 2);
            return false;
        }
        Utils.userMessage("Finished", "Search and Replace finished " + new String(Integer.toString(counter)) + " occurences replaced.", 2);
        counter = 0;
        return false;
    }

    public static void Replace(String findstr1, String findstr2) {
        String find1 = findstr1;
        String find2 = findstr2;
        String s = Page[Selected].getText();
        if (findstr2.equals("") || findstr2 == null) {
            find1 = " ";
        }
        if (findstr1 != null) {
            Page[Selected].grabFocus();
            String t = find2;
            String str = find1;
            if (t != null) {
                try {
                    if (wholeWord) {
                        Editor.replaceSelection(t);
                    } else {
                        Editor.replaceSelection(t);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error performing replace: " + ex.getMessage());
                    Utils.userMessage("Error", "An error has occured, please see error log.", 1);
                    Utils.writeErrorLog("Error performing replace " + ex.getMessage());
                }
            }
            if (!replaceAll) {
                Editor.FindNext(find1);
                Editor.grabFocus();
            }
        }
    }

    public static void replaceAll(String find1, String find2) {
        replaceAll = true;
        if (find1 == null || find1.equals("")) {
            Editor.FindNext(find1);
        }
        while (Editor.FindNext(find1)) {
            Editor.Replace(find1, find2);
            ++counter;
        }
    }

    public static void replaceAllWords(String pattern, String replace) {
        int s = 0;
        int e = 0;
        int origin = Editor.getCaretPos();
        counter = 0;
        StringBuffer result = new StringBuffer();
        String str = Page[Selected].getText();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
            ++counter;
        }
        SetEnv.MessageBar.setText("Replaced=" + counter);
        result.append(str.substring(s));
        String ss = result.toString();
        Page[Selected].setText(ss);
        Editor.setCaretPos(origin);
        Page[Selected].updateScrollBars();
    }

    public static void toHTML() {
        String str = Editor.DocName();
        try {
            Applet myClass;
            String newFile = new String(str + ".html");
            RandomAccessFile file2 = new RandomAccessFile(str, "r");
            byte[] fileC = new byte[(int)file2.length()];
            file2.readFully(fileC);
            file2.close();
            String fileContent = new String(fileC, 0);
            file2 = new RandomAccessFile(newFile, "rw");
            if (str.endsWith(".java") || str.endsWith(".bsh")) {
                myClass = new VasJava2HTML(false);
                file2.writeBytes(((VasJava2HTML)myClass).transform(fileContent));
            }
            if (str.endsWith(".py")) {
                myClass = new VasJython2HTML(false);
                file2.writeBytes(((VasJython2HTML)myClass).transform(fileContent));
            }
            file2.close();
        }
        catch (Exception e) {
            System.out.println("File problem durng HTML export");
        }
    }

    static {
        BracketStyle = 2;
        LineNumber = -1;
        ColumnNumber = -1;
        AcceptedWords = new HashSet[50];
        BadWords = new HashSet[50];
        replaceFinished = false;
        pos = 0;
        counter = 0;
        ErrorSyntaxLineColor = new Color(255, 215, 215);
        ErrorLineColor = new Color(250, 160, 210);
        lastpos = 0;
        LastPos = 0;
        ErrorLine = -1;
        ErrorSyntaxLine = -1;
    }
}

