/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import jehep.ui.mainGUI;
import jehep.utils.Utils;

class DropHandler
extends TransferHandler {
    private mainGUI win;
    static final String SYSTEM_ERROR = new String("An application error has occured, please see error log. Tools > Error log");

    DropHandler(mainGUI win) {
        this.win = win;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        if (!this.canImport(component, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            this.importFiles(transferable);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("Error dropping file " + e.getMessage());
            Utils.userMessage("Error", SYSTEM_ERROR, 1);
            Utils.writeErrorLog("Error dropping file  " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IO Error dropping file " + e.getMessage());
            Utils.userMessage("Error", SYSTEM_ERROR, 1);
            Utils.writeErrorLog("IO Error dropping file  " + e.getMessage());
        }
        return false;
    }

    private void importFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        for (int i = 0; i < files.size(); ++i) {
            this.win.open(files.get(i).toString(), false);
        }
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return Arrays.asList(flavors).contains(DataFlavor.javaFileListFlavor);
    }
}

