/*
 * Decompiled with CFR 0.152.
 */
package jehep.textparse;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jehep.textparse.CParse;
import jehep.textparse.FortranParse;
import jehep.textparse.JavaParse;
import jehep.textparse.LatexParse;
import jehep.textparse.OidNode;
import jehep.textparse.PhpParse;
import jehep.textparse.PythonParse;
import jehep.ui.Editor;

public class StructTree {
    public DefaultMutableTreeNode philosophersNode;
    public DefaultTreeModel model;
    public DefaultMutableTreeNode rootNode;
    public DefaultMutableTreeNode ancient;
    private List<OidNode> Data = new ArrayList<OidNode>();
    private List<DefaultMutableTreeNode> Nodes = new ArrayList<DefaultMutableTreeNode>();

    public StructTree() {
        this.rootNode = new DefaultMutableTreeNode("Structure");
        this.model = new DefaultTreeModel(this.rootNode);
    }

    public void add() {
        Object lpar;
        String StyleDoc = Editor.DocStyle;
        this.remove();
        if (StyleDoc.equals("latex")) {
            lpar = new LatexParse();
            this.Data = ((LatexParse)lpar).Load();
        } else if (StyleDoc.equals("jav")) {
            lpar = new JavaParse();
            this.Data = ((JavaParse)lpar).Load();
        } else if (StyleDoc.equals("fortran")) {
            lpar = new FortranParse();
            this.Data = ((FortranParse)lpar).Load();
        } else if (StyleDoc.equals("php")) {
            lpar = new PhpParse();
            this.Data = ((PhpParse)lpar).Load();
        } else if (StyleDoc.equals("python") || StyleDoc.equals("pythonRoot")) {
            lpar = new PythonParse();
            this.Data = ((PythonParse)lpar).Load();
        } else if (StyleDoc.equals("c") || StyleDoc.equals("cpp") || StyleDoc.equals("cxx")) {
            lpar = new CParse();
            this.Data = ((CParse)lpar).Load();
        }
        for (int i = 0; i < this.Data.size(); ++i) {
            OidNode m_Data = this.Data.get(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(m_Data.getName());
            this.model.insertNodeInto(node, this.rootNode, this.rootNode.getChildCount());
            this.Nodes.add(node);
        }
    }

    public void remove() {
        for (int i = 0; i < this.Nodes.size(); ++i) {
            DefaultMutableTreeNode element = this.Nodes.get(i);
            this.model.removeNodeFromParent(element);
        }
        this.Nodes.clear();
        this.Data.clear();
        this.model.reload();
    }

    public int getSize() {
        return this.Data.size();
    }

    public String getName(int i) {
        String tmp = "none";
        if (i > this.Data.size()) {
            return tmp;
        }
        OidNode id = this.Data.get(i);
        tmp = id.getName();
        return tmp;
    }

    public int getLine(int i) {
        int tmp = 0;
        if (i > this.Data.size()) {
            return tmp;
        }
        OidNode id = this.Data.get(i);
        tmp = id.getId();
        return tmp;
    }
}

