/*
 * Decompiled with CFR 0.152.
 */
package jehep.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jehep.syntax.SyntaxStyle;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.Token;
import jehep.syntax.TokenMarker;
import jehep.textarea.AntiAlias;
import jehep.textarea.JEditTextArea;
import jehep.textarea.PythonUtilities;
import jehep.textarea.TextAreaDefaults;
import jehep.textarea.TextAreaHighlight;
import jehep.textarea.TextUtilities;
import jehep.ui.Editor;
import jehep.ui.SetEnv;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    private static final long serialVersionUID = 1L;
    public static RenderingHints ANTI_ALIASED_RENDERING = null;
    public static RenderingHints DEFAULT_RENDERING = null;
    public static int current_line = -1;
    public static int bracked_line = -1;
    private AntiAlias antiAlias;
    boolean fracFontMetrics;
    RenderingHints renderingHints;
    FontRenderContext fontRenderContext;
    private static Object sm_hrgbRender;
    private static Constructor<FontRenderContext> sm_frcConstructor;
    private boolean wrapGuide;
    private Color wrapGuideColor;
    private int wrapGuideOffset;
    private boolean linesIntervalHighlight;
    private Color linesIntervalColor;
    private int linesInterval;
    int currentLineIndex;
    Token currentLineTokens;
    Segment currentLine;
    protected JEditTextArea textArea;
    protected SyntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean paintInvalid;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected TextAreaHighlight highlights;

    private void updateRenderingHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        if (this.antiAlias.val() == 0) {
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        } else if (this.antiAlias.val() == 2 && sm_hrgbRender != null) {
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, sm_hrgbRender);
            Object fontRenderHint = this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            Object[] paramList = new Object[]{null, sm_hrgbRender, fontRenderHint};
            try {
                this.fontRenderContext = sm_frcConstructor.newInstance(paramList);
            }
            catch (Exception e) {
                this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
            }
        } else {
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        }
        this.renderingHints = new RenderingHints(hints);
    }

    public TextAreaPainter(JEditTextArea textArea, TextAreaDefaults defaults) {
        this.textArea = textArea;
        this.setAntiAlias(new AntiAlias(1));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(new Font("Monospaced", 1, 12));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.blockCaret = defaults.blockCaret;
        this.styles = defaults.styles;
        this.cols = defaults.cols;
        this.rows = defaults.rows;
        this.caretColor = defaults.caretColor;
        this.selectionColor = defaults.selectionColor;
        this.lineHighlightColor = defaults.lineHighlightColor;
        this.lineHighlight = defaults.lineHighlight;
        this.bracketHighlightColor = defaults.bracketHighlightColor;
        this.bracketHighlight = defaults.bracketHighlight;
        this.paintInvalid = defaults.paintInvalid;
        this.eolMarkerColor = defaults.eolMarkerColor;
        this.eolMarkers = defaults.eolMarkers;
        this.wrapGuide = defaults.wrapGuide;
        this.wrapGuideColor = defaults.wrapGuideColor;
        this.wrapGuideOffset = defaults.wrapGuideOffset;
        this.linesIntervalHighlight = defaults.linesIntervalHighlight;
        this.linesIntervalColor = defaults.linesIntervalColor;
        this.linesInterval = defaults.linesInterval;
    }

    public void setAntiAlias(AntiAlias newValue) {
        this.antiAlias = newValue;
        this.updateRenderingHints();
    }

    public void setAntiAliasingEnabled(boolean enable) {
        if (enable) {
            this.setAntiAlias(new AntiAlias(1));
        } else {
            this.setAntiAlias(new AntiAlias(0));
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.antiAlias.val() != 0;
    }

    public AntiAlias getAntiAlias() {
        return this.antiAlias;
    }

    public void setWrapGuideEnabled(boolean enabled) {
        this.wrapGuide = enabled;
    }

    public void setWrapGuideOffset(int offset) {
        this.wrapGuideOffset = offset;
    }

    public void setWrapGuideColor(Color color) {
        this.wrapGuideColor = color;
    }

    public void setLinesIntervalHighlightEnabled(boolean enabled) {
        this.linesIntervalHighlight = enabled;
    }

    public void setLinesInterval(int offset) {
        this.linesInterval = offset;
    }

    public void setLinesIntervalHighlightColor(Color color) {
        this.linesIntervalColor = color;
    }

    public final void setBackgroundColor(Color c) {
        this.setBackground(c);
    }

    public final void setForeGroundColor(Color c) {
        this.setForeground(c);
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] styles) {
        this.styles = styles;
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
        this.invalidateSelectedLines();
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.invalidateSelectedLines();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
        this.invalidateSelectedLines();
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.lineHighlight = lineHighlight;
        this.invalidateSelectedLines();
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final void setBracketHighlightColor(Color bracketHighlightColor) {
        this.bracketHighlightColor = bracketHighlightColor;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final void setBracketHighlightEnabled(boolean bracketHighlight) {
        this.bracketHighlight = bracketHighlight;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean blockCaret) {
        this.blockCaret = blockCaret;
        this.invalidateSelectedLines();
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color eolMarkerColor) {
        this.eolMarkerColor = eolMarkerColor;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean eolMarkers) {
        this.eolMarkers = eolMarkers;
        this.repaint();
    }

    public boolean getInvalidLinesPainted() {
        return this.paintInvalid;
    }

    public void setInvalidLinesPainted(boolean paintInvalid) {
        this.paintInvalid = paintInvalid;
    }

    public void addCustomHighlight(TextAreaHighlight highlight) {
        highlight.init(this.textArea, this.highlights);
        this.highlights = highlight;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.highlights != null) {
            return this.highlights.getToolTipText(evt);
        }
        return null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    @Override
    public void paint(Graphics gfx) {
        assert (gfx instanceof Graphics2D);
        Graphics2D gfx2 = (Graphics2D)gfx;
        gfx2.setRenderingHints(this.renderingHints);
        this.fontRenderContext = gfx2.getFontRenderContext();
        this.tabSize = this.fm.charWidth(' ') * (Integer)this.textArea.getDocument().getProperty("tabSize");
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        int height = this.fm.getHeight();
        int firstLine = this.textArea.getFirstLine();
        int firstInvalid = firstLine + clipRect.y / height;
        int lastInvalid = firstLine + (clipRect.y + clipRect.height - 1) / height;
        try {
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            int x = this.textArea.getHorizontalOffset();
            for (int line = firstInvalid; line <= lastInvalid; ++line) {
                this.paintLine(gfx, tokenMarker, line, x);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                int h = clipRect.y + clipRect.height;
                this.repaint(0, h, this.getWidth(), this.getHeight() - h);
            }
        }
        catch (Exception e) {
            System.err.println("Error repainting line range {" + firstInvalid + "," + lastInvalid + "}:");
            e.printStackTrace();
        }
    }

    public final void invalidateLine(int line) {
        this.repaint(0, this.textArea.lineToY(line) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), this.fm.getHeight());
    }

    public final void invalidateLineRange(int firstLine, int lastLine) {
        this.repaint(0, this.textArea.lineToY(firstLine) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), (lastLine - firstLine + 1) * this.fm.getHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int offset = this.textArea.getHorizontalOffset();
        int ntabs = ((int)x - offset) / this.tabSize;
        return (ntabs + 1) * this.tabSize + offset;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        dim.width = this.fm.charWidth('w') * this.cols;
        dim.height = this.fm.getHeight() * this.rows;
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void paintLine(Graphics gfx, TokenMarker tokenMarker, int line, int x) {
        Font defaultFont = this.getFont();
        Color defaultColor = this.getForeground();
        this.currentLineIndex = line;
        int y = this.textArea.lineToY(line);
        if (line < 0 || line >= this.textArea.getLineCount()) {
            if (this.paintInvalid) {
                this.paintHighlight(gfx, line, y);
                this.styles[10].setGraphicsFlags(gfx, defaultFont);
                gfx.drawString("~", 0, y + this.fm.getHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(gfx, line, defaultFont, defaultColor, x, y);
        } else {
            this.paintSyntaxLine(gfx, tokenMarker, line, defaultFont, defaultColor, x, y);
        }
    }

    protected void paintPlainLine(Graphics gfx, int line, Font defaultFont, Color defaultColor, int x, int y) {
        this.paintHighlight(gfx, line, y);
        this.textArea.getLineText(line, this.currentLine);
        gfx.setFont(defaultFont);
        gfx.setColor(defaultColor);
        x = Utilities.drawTabbedText(this.currentLine, x, y += this.fm.getHeight(), gfx, (TabExpander)this, 0);
        if (this.eolMarkers) {
            gfx.setColor(this.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintSyntaxLine(Graphics gfx, TokenMarker tokenMarker, int line, Font defaultFont, Color defaultColor, int x, int y) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(gfx, line, y);
        gfx.setFont(defaultFont);
        gfx.setColor(defaultColor);
        x = SyntaxUtilities.paintSyntaxLine(this.currentLine, this.currentLineTokens, this.styles, this, gfx, x, y += this.fm.getHeight());
        if (this.eolMarkers) {
            gfx.setColor(this.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintHighlight(Graphics gfx, int line, int y) {
        if (this.bracketHighlight && line == this.textArea.getBracketLine() && TextUtilities.Type != 0 && Editor.BracketStyle == 1) {
            current_line = line;
            this.paintBracketConnectors(gfx, line, y);
        } else if (Editor.BracketStyle == 1 && Editor.BracketStyle == 1) {
            bracked_line = this.textArea.getBracketLineAll() + 1;
            if (bracked_line > 0) {
                String s = "Matched bracket on line:" + Integer.toString(bracked_line) + "   text:" + Editor.getLineText(bracked_line - 1);
                SetEnv.showStatusBarText(s);
            }
        } else if (Editor.BracketStyle == 2) {
            current_line = line;
            this.paintPythonConnectors(gfx, line, y);
        }
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(gfx, line, y);
        }
        if (this.linesIntervalHighlight && this.linesInterval > 0) {
            this.paintLinesInterval(gfx, line, y);
        }
        if (this.wrapGuide && this.wrapGuideOffset > 0) {
            this.paintWrapGuide(gfx, line, y);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(gfx, line, y);
        }
        if (this.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(gfx, line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(gfx, line, y);
        }
    }

    protected void paintWrapGuide(Graphics gfx, int line, int y) {
        gfx.setColor(this.wrapGuideColor);
        int _offset = y + (this.fm.getLeading() + this.fm.getMaxDescent());
        int start = line > 0 ? _offset : 0;
        int end2 = line != this.textArea.getLineCount() - 1 ? _offset + this.fm.getHeight() : this.textArea.getHeight();
        int charWidth = this.fm.charWidth('m');
        int offset = this.textArea.getHorizontalOffset();
        int width = this.textArea.getWidth();
        int off = this.wrapGuideOffset * charWidth + offset;
        if (off >= 0 && off < width) {
            gfx.drawLine(off, start, off, end2);
        }
    }

    protected void paintLinesInterval(Graphics gfx, int line, int y) {
        if ((line + 1) % this.linesInterval == 0) {
            int x2;
            int x1;
            int height = this.fm.getHeight();
            int _offset = y + this.fm.getLeading() + this.fm.getMaxDescent();
            int selectionStart = this.textArea.getSelectionStart();
            int selectionEnd = this.textArea.getSelectionEnd();
            gfx.setColor(this.linesIntervalColor);
            gfx.fillRect(0, _offset, this.getWidth(), height);
            gfx.setColor(this.selectionColor);
            int selectionStartLine = this.textArea.getSelectionStartLine();
            int selectionEndLine = this.textArea.getSelectionEndLine();
            int lineStart = this.textArea.getLineStartOffset(line);
            if (this.textArea.isSelectionRectangular()) {
                int lineLen = this.textArea.getLineLength(line);
                x1 = this.textArea.offsetToX(line, Math.min(lineLen, selectionStart - this.textArea.getLineStartOffset(selectionStartLine)));
                if (x1 == (x2 = this.textArea.offsetToX(line, Math.min(lineLen, selectionEnd - this.textArea.getLineStartOffset(selectionEndLine))))) {
                    ++x2;
                }
            } else if (selectionStartLine == selectionEndLine) {
                x1 = this.textArea.offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea.offsetToX(line, selectionEnd - lineStart);
            } else if (line == selectionStartLine) {
                x1 = this.textArea.offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea.offsetToX(line, this.textArea.getLineLength(line));
            } else if (line == selectionEndLine) {
                x1 = 0;
                x2 = this.textArea.offsetToX(line, selectionEnd - lineStart);
            } else {
                x1 = 0;
                x2 = this.textArea.offsetToX(line, this.textArea.getLineLength(line));
            }
            gfx.fillRect(x1 > x2 ? x2 : x1, _offset, x1 > x2 ? x1 - x2 : x2 - x1, height);
        }
    }

    protected void paintLineHighlight(Graphics gfx, int line, int y) {
        int selectionEnd;
        int height = this.fm.getHeight();
        y += this.fm.getLeading() + this.fm.getMaxDescent();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart == (selectionEnd = this.textArea.getSelectionEnd())) {
            if (this.lineHighlight) {
                gfx.setColor(this.lineHighlightColor);
                gfx.fillRect(0, y, this.getWidth(), height);
            }
        } else {
            int x2;
            int x1;
            gfx.setColor(this.selectionColor);
            int selectionStartLine = this.textArea.getSelectionStartLine();
            int selectionEndLine = this.textArea.getSelectionEndLine();
            int lineStart = this.textArea.getLineStartOffset(line);
            if (this.textArea.isSelectionRectangular()) {
                int lineLen = this.textArea.getLineLength(line);
                x1 = this.textArea._offsetToX(line, Math.min(lineLen, selectionStart - this.textArea.getLineStartOffset(selectionStartLine)));
                if (x1 == (x2 = this.textArea._offsetToX(line, Math.min(lineLen, selectionEnd - this.textArea.getLineStartOffset(selectionEndLine))))) {
                    ++x2;
                }
            } else if (selectionStartLine == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else if (line == selectionStartLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.getWidth();
            } else if (line == selectionEndLine) {
                x1 = 0;
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else {
                x1 = 0;
                x2 = this.getWidth();
            }
            gfx.fillRect(x1 > x2 ? x2 : x1, y, x1 > x2 ? x1 - x2 : x2 - x1, height);
        }
    }

    protected void paintBracketHighlight(Graphics gfx, int line, int y) {
        int position = this.textArea.getBracketPosition();
        if (position == -1) {
            return;
        }
        int x = this.textArea._offsetToX(line, position);
        gfx.setColor(this.bracketHighlightColor);
        gfx.drawRect(x, y += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintPythonConnectors(Graphics gfx, int line, int y) {
        if (Editor.isGutterCollapsed()) {
            return;
        }
        bracked_line = PythonUtilities.findIndention(this.textArea, this, gfx);
        if (bracked_line > 0) {
            String s = "Matched on line:" + Integer.toString(bracked_line) + "   text:" + Editor.getLineText(bracked_line);
            SetEnv.showStatusBarText(s);
        }
        this.textArea.getGutter().repaint();
    }

    protected void paintBracketConnectors(Graphics gfx, int line, int y) {
        if (Editor.isGutterCollapsed()) {
            return;
        }
        bracked_line = this.textArea.getBracketLine() + 1;
        this.textArea.getGutter().repaint();
    }

    protected void paintCaret(Graphics gfx, int line, int y) {
        if (this.textArea.isCaretVisible()) {
            int offset = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
            int caretX = this.textArea._offsetToX(line, offset);
            int caretWidth = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
            y += this.fm.getLeading() + this.fm.getMaxDescent();
            int height = this.fm.getHeight();
            gfx.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                gfx.fillRect(caretX, y + height - 1, caretWidth, 1);
            } else {
                gfx.drawRect(caretX, y, caretWidth - 1, height - 1);
            }
        }
    }

    static {
        try {
            Field f = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
            sm_hrgbRender = f.get(null);
            Class[] fracFontMetricsTypeList = new Class[]{AffineTransform.class, Object.class, Object.class};
            sm_frcConstructor = FontRenderContext.class.getConstructor(fracFontMetricsTypeList);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

