/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax_check;

import java.io.StringWriter;
import java.io.Writer;
import jehep.ui.Editor;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;

public class Checker {
    private static final long serialVersionUID = 1L;
    private PythonInterpreter interp;
    private StringWriter out;
    private StringWriter err;
    private String mess = "";
    private int erline = -1;

    public Checker() {
        int ill2;
        if (!Editor.DocName().endsWith(".py")) {
            return;
        }
        this.out = new StringWriter();
        this.err = new StringWriter();
        try {
            this.interp = new PythonInterpreter();
            this.interp.setErr((Writer)this.err);
            String cmt = "import py_compile; py_compile.compile(\"" + Editor.DocName() + "\")";
            this.interp.exec(cmt);
            StringBuffer results = new StringBuffer();
            results.append(this.out.toString());
            results.append(this.err.toString());
            this.mess = results.toString();
            this.interp.cleanup();
        }
        catch (PyException exec) {
            this.mess = exec.toString();
        }
        if (this.mess.length() < 1) {
            return;
        }
        String errline = "";
        int ill = this.mess.indexOf("line");
        if (ill > -1 && (ill2 = (errline = this.mess.substring(ill + 5, this.mess.length())).indexOf("\n")) > -1) {
            errline = errline.substring(0, ill2);
        }
        if ((errline = errline.trim()).length() < 1) {
            return;
        }
        this.erline = -1;
        try {
            this.erline = Integer.parseInt(errline);
        }
        catch (NumberFormatException e) {
            this.erline = -1;
        }
        if (this.erline == -1) {
            return;
        }
    }

    public int getErrorLine() {
        return this.erline;
    }

    private String exec(String script) {
        this.interp.exec(script);
        StringBuffer results = new StringBuffer();
        results.append(this.out.toString());
        results.append(this.err.toString());
        return results.toString();
    }
}

