/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;

public class KumacTokenMarker
extends TokenMarker {
    private static KeywordMap kumacKeywords;
    private KeywordMap keywords = KumacTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block15: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case 'E': {
                            if (!SyntaxUtilities.regionMatches(false, line, i1, "XEC SQL")) break;
                            this.doKeyword(line, i, c);
                            i += 7;
                            token = (byte)8;
                            continue block15;
                        }
                        case '*': {
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            token = 0;
                            this.lastOffset = this.lastKeyword = length;
                            break block15;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            continue block15;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            continue block15;
                        }
                        case ' ': {
                            this.doKeyword(line, i, c);
                        }
                    }
                    continue block15;
                }
                case 8: {
                    if (c != 'E' || !SyntaxUtilities.regionMatches(false, line, i1, "ND-EXEC")) continue block15;
                    this.addToken((i += 8) - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block15;
                }
                case 3: {
                    if (c != '\"') continue block15;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                case 4: {
                    if (c != '\'') continue block15;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            default: 
        }
        this.addToken(length - this.lastOffset, token);
        return token;
        throw new InternalError("Invalid state: " + token);
    }

    public static KeywordMap getKeywords() {
        if (kumacKeywords == null) {
            kumacKeywords = new KeywordMap(true);
            kumacKeywords.add("macro", (byte)8);
            kumacKeywords.add("set", (byte)8);
            kumacKeywords.add("title", (byte)8);
            kumacKeywords.add("atitle", (byte)8);
            kumacKeywords.add("zone", (byte)8);
            kumacKeywords.add("opt", (byte)8);
            kumacKeywords.add("if", (byte)8);
            kumacKeywords.add("end", (byte)8);
            kumacKeywords.add("endif", (byte)8);
            kumacKeywords.add("nbox", (byte)8);
            kumacKeywords.add("asiz", (byte)8);
            kumacKeywords.add("utit", (byte)8);
            kumacKeywords.add("option", (byte)8);
            kumacKeywords.add("xwin", (byte)8);
            kumacKeywords.add("ywin", (byte)8);
            kumacKeywords.add("AND", (byte)8);
            kumacKeywords.add("clr", (byte)6);
            kumacKeywords.add("ksiz", (byte)6);
            kumacKeywords.add("DATA", (byte)6);
            kumacKeywords.add("mess", (byte)8);
            kumacKeywords.add("ELSE", (byte)8);
            kumacKeywords.add("END", (byte)8);
            kumacKeywords.add("print", (byte)6);
            kumacKeywords.add("do", (byte)6);
            kumacKeywords.add("FILE", (byte)6);
            kumacKeywords.add("FUNCTION", (byte)6);
            kumacKeywords.add("IF", (byte)6);
            kumacKeywords.add("print", (byte)6);
            kumacKeywords.add("CALL", (byte)6);
            kumacKeywords.add("CLOSE", (byte)6);
            kumacKeywords.add("CONTINUE", (byte)6);
            kumacKeywords.add("DO", (byte)6);
            kumacKeywords.add("ELSE", (byte)6);
            kumacKeywords.add("ELSEIF", (byte)6);
            kumacKeywords.add("ENDIF", (byte)6);
            kumacKeywords.add("GOTO", (byte)6);
            kumacKeywords.add("GO TO", (byte)6);
            kumacKeywords.add("IF", (byte)6);
            kumacKeywords.add("INDEX", (byte)6);
            kumacKeywords.add("INQUIRE", (byte)6);
            kumacKeywords.add("OPEN", (byte)6);
            kumacKeywords.add("PRINT", (byte)6);
            kumacKeywords.add("READ", (byte)6);
            kumacKeywords.add("RETURN", (byte)6);
            kumacKeywords.add("THEN", (byte)6);
            kumacKeywords.add("WRITE", (byte)6);
            kumacKeywords.add("BLOCK DATA", (byte)7);
            kumacKeywords.add("COMPILER", (byte)7);
            kumacKeywords.add("END", (byte)7);
            kumacKeywords.add("ENTRY", (byte)7);
            kumacKeywords.add("FUNCTION", (byte)7);
            kumacKeywords.add("INCLUDE", (byte)7);
            kumacKeywords.add("SUBROUTINE", (byte)7);
            kumacKeywords.add("CHARACTER", (byte)8);
            kumacKeywords.add("DATA", (byte)8);
            kumacKeywords.add("DEFINE", (byte)8);
            kumacKeywords.add("EQUIVALENCE", (byte)8);
            kumacKeywords.add("IMPLICIT", (byte)8);
            kumacKeywords.add("INTEGER", (byte)8);
            kumacKeywords.add("LOGICAL", (byte)8);
            kumacKeywords.add("PARAMETER", (byte)8);
            kumacKeywords.add("REAL", (byte)8);
            kumacKeywords.add(".AND.", (byte)9);
            kumacKeywords.add(".EQ.", (byte)9);
            kumacKeywords.add(".NE.", (byte)9);
            kumacKeywords.add(".NOT.", (byte)9);
            kumacKeywords.add(".OR.", (byte)9);
            kumacKeywords.add("+", (byte)9);
            kumacKeywords.add("-", (byte)9);
            kumacKeywords.add("*", (byte)9);
            kumacKeywords.add("**", (byte)9);
            kumacKeywords.add("/", (byte)9);
            kumacKeywords.add(".FALSE.", (byte)4);
            kumacKeywords.add(".TRUE.", (byte)4);
        }
        return kumacKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

