/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.JavaScriptTokenMarker;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;

public class HTMLTokenMarker
extends TokenMarker {
    public static final byte JAVASCRIPT = 100;
    public static final byte HTML_LITERAL_QUOTE = 101;
    public static final byte HTML_LITERAL_NO_QUOTE = 102;
    public static final byte INSIDE_TAG = 103;
    private KeywordMap keywords;
    private boolean js;
    private boolean javascript;
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;

    public HTMLTokenMarker() {
        this(true);
    }

    public HTMLTokenMarker(boolean js) {
        this.js = js;
        this.keywords = JavaScriptTokenMarker.getKeywords();
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        this.lastWhitespace = offset - 1;
        block35: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                boolean bl = backslash = !backslash;
                if (token == 100) continue;
            }
            switch (token) {
                case 0: {
                    backslash = false;
                    switch (c) {
                        case '\\': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)9;
                            break;
                        }
                        case '<': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            if (SyntaxUtilities.regionMatches(false, line, i1, "!--")) {
                                i += 3;
                                token = 1;
                                break;
                            }
                            if (this.js && SyntaxUtilities.regionMatches(true, line, i1, "script")) {
                                this.addToken(1, (byte)6);
                                this.lastOffset = this.lastKeyword = i1;
                                token = (byte)11;
                                this.javascript = true;
                                break;
                            }
                            this.addToken(1, (byte)6);
                            this.lastOffset = this.lastKeyword = i1;
                            token = (byte)11;
                            break;
                        }
                        case '&': {
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)7;
                        }
                    }
                    continue block35;
                }
                case 9: {
                    backslash = false;
                    if (c == '<') continue block35;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block35;
                }
                case 11: {
                    backslash = false;
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        if (!this.javascript) {
                            token = 0;
                            continue block35;
                        }
                        this.javascript = false;
                        this.lastWhitespace = i;
                        token = (byte)100;
                        continue block35;
                    }
                    if (c == ':') {
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block35;
                    }
                    if (c != ' ' && c != '\t') continue block35;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)103;
                    continue block35;
                }
                case 103: {
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, (byte)11);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        if (!this.javascript) {
                            token = 0;
                            continue block35;
                        }
                        this.javascript = false;
                        token = (byte)100;
                        continue block35;
                    }
                    if (c == '/' || c == '?') {
                        this.addToken(1, (byte)11);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)11;
                        continue block35;
                    }
                    this.addToken(i - this.lastOffset, (byte)0);
                    this.lastOffset = this.lastKeyword = i;
                    token = (byte)8;
                    continue block35;
                }
                case 7: {
                    backslash = false;
                    if (c != ';') continue block35;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block35;
                }
                case 8: {
                    if (c == '/' || c == '?') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)11);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block35;
                    }
                    if (c == '=') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)5);
                        this.lastOffset = this.lastKeyword = i1;
                        if (i1 < array.length && array[i1] == '\"') {
                            token = (byte)101;
                            ++i;
                            continue block35;
                        }
                        token = (byte)102;
                        continue block35;
                    }
                    if (c == '>') {
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)6);
                        this.lastOffset = this.lastKeyword = i1;
                        token = 0;
                        continue block35;
                    }
                    if (c != ' ' && c != '\t') continue block35;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)103;
                    continue block35;
                }
                case 101: {
                    if (c != '\"') continue block35;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)103;
                    continue block35;
                }
                case 102: {
                    if (c == ' ' || c == '\t') {
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)103;
                        continue block35;
                    }
                    if (c != '>') continue block35;
                    this.addToken(i - this.lastOffset, (byte)3);
                    this.addToken(1, (byte)6);
                    this.lastOffset = this.lastKeyword = i1;
                    token = 0;
                    continue block35;
                }
                case 1: {
                    backslash = false;
                    if (!SyntaxUtilities.regionMatches(false, line, i, "-->")) continue block35;
                    this.addToken(i + 3 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i + 3;
                    token = 0;
                    continue block35;
                }
                case 100: {
                    switch (c) {
                        case '<': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (!SyntaxUtilities.regionMatches(true, line, i1, "/script>")) continue block35;
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.addToken(1, (byte)6);
                            this.addToken(7, (byte)11);
                            this.addToken(1, (byte)6);
                            this.lastOffset = this.lastKeyword = (i += 9);
                            token = 0;
                            break;
                        }
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, (byte)0);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = (byte)100;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '\"': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)3;
                            break;
                        }
                        case '\'': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)4;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block35;
                            this.addToken(i - this.lastOffset, (byte)0);
                            this.lastOffset = this.lastKeyword = i;
                            if (array[i1] == '/') {
                                this.addToken(length - i, (byte)2);
                                this.lastOffset = this.lastKeyword = length;
                                break block35;
                            }
                            if (array[i1] != '*') continue block35;
                            token = (byte)2;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) == -1) continue block35;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block35;
                    }
                    if (c != '\"') continue block35;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block35;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block35;
                    }
                    if (c != '\'') continue block35;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    this.lastOffset = this.lastKeyword = i1;
                    token = (byte)100;
                    continue block35;
                }
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block35;
                    this.addToken((i += 2) - this.lastOffset, (byte)1);
                    this.lastOffset = this.lastKeyword = i;
                    token = (byte)100;
                    continue block35;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = (byte)100;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 100: {
                this.doKeyword(line, length, '\u0000');
                this.addToken(length - this.lastOffset, (byte)0);
                break;
            }
            case 2: {
                this.addToken(length - this.lastOffset, (byte)1);
                break;
            }
            case 103: {
                break;
            }
            case 101: 
            case 102: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastKeyword = i1;
            this.lastOffset = i;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

