/*
 * Decompiled with CFR 0.152.
 */
package jehep.sexam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Util {
    private static final int BUFFER_SIZE = 4096;

    private Util() {
    }

    public static Point centreWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x + (rec.width - dim.width >> 1);
        pos.y = rec.y + (rec.height - dim.height >> 1);
        return pos;
    }

    public static Point rightWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x + rec.width;
        pos.y = rec.y;
        return pos;
    }

    public static Point belowWithin(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x;
        pos.y = rec.y + rec.height;
        return pos;
    }

    public static void centreWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.centreWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static void leftWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.centreWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static void rightWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Dimension pwin = parent.getSize();
        Point p = Util.centreWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width - (int)(1.2 * (double)pwin.width);
        if (diff < 0) {
            p.x += diff;
        }
        if (p.x < 0) {
            Util.centreWithin(parent, child);
            return;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static void belowWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = Util.belowWithin(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static String fileNameOfPath(String path) {
        if (path == null) {
            return "";
        }
        File f = new File(path);
        return f.getName();
    }

    public static String pathNameOfPath(String path) {
        if (path == null) {
            return "";
        }
        File f = new File(path);
        return f.getParent();
    }

    public static String substituteText(String text, String token, String substitute) {
        int index;
        if (token == null || substitute == null || (index = text.indexOf(token)) < 0) {
            return text;
        }
        while (index > -1) {
            text = text.substring(0, index) + substitute + text.substring(index + token.length());
            index = text.indexOf(token);
        }
        return text;
    }

    public static String substituteTextS(String text, String token, String substitute) {
        int index;
        if (token == null || substitute == null || (index = text.indexOf(token)) < 0) {
            return text;
        }
        if (index > -1) {
            text = text.substring(0, index) + substitute + text.substring(index + token.length());
        }
        return text;
    }

    public static String htmlEncoded(String text) {
        int len = text.length();
        StringBuffer b = new StringBuffer(len * 3);
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block6;
                }
                case '>': {
                    b.append("&gt;");
                    continue block6;
                }
                case '&': {
                    b.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block6;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        if (inputFile == null | outputFile == null) {
            throw new IllegalArgumentException("null pointer");
        }
        if (inputFile.equals(outputFile)) {
            throw new IllegalArgumentException("illegal self reference");
        }
        byte[] buffer = new byte[2048];
        try {
            int len;
            File parent = inputFile.getAbsoluteFile().getParentFile();
            if (!outputFile.isAbsolute()) {
                outputFile = new File(parent, outputFile.getPath());
            }
            Util.ensureFilePath(outputFile, parent);
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            CRC32 crcSum = new CRC32();
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                crcSum.update(buffer, 0, len);
            }
            in.close();
            out.close();
            int writeCrc = (int)crcSum.getValue();
            in = new FileInputStream(outputFile);
            crcSum.reset();
            while ((len = in.read(buffer)) != -1) {
                crcSum.update(buffer, 0, len);
            }
            if (writeCrc != (int)crcSum.getValue()) {
                throw new StreamCorruptedException("bad copy CRC");
            }
        }
        catch (IOException e) {
            System.err.println("*** error during file copy: " + outputFile.getAbsolutePath());
            System.err.println(e);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static boolean ensureFilePath(File file2, File defaultDir) {
        File parent = file2.getParentFile();
        if (parent != null) {
            return Util.ensureDirectory(parent, defaultDir);
        }
        return true;
    }

    public static boolean ensureDirectory(File dir2, File defaultDir) {
        boolean success = true;
        if (dir2 == null) {
            throw new IllegalArgumentException("dir = null");
        }
        if (!dir2.isAbsolute()) {
            dir2 = new File(defaultDir, dir2.getPath());
        }
        if (!dir2.isDirectory()) {
            boolean bl = success = !dir2.isFile() && dir2.mkdirs();
            if (!success) {
                System.err.println("failed while trying to create directory: " + dir2.toString());
            }
        }
        return success;
    }

    public static int textVariance(char[] ca) {
        BitSet set = new BitSet();
        for (int i = 0; i < ca.length; ++i) {
            set.set(ca[i]);
        }
        return set.cardinality();
    }

    public static boolean deleteDir(File dir2) {
        if (dir2.isDirectory()) {
            String[] children = dir2.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Util.deleteDir(new File(dir2, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir2.delete();
    }

    public static String getListFiles(String dir2, String extension) {
        String tmp = "";
        try {
            File tempDir = new File(dir2);
            List<File> files = Util.getFileListing(tempDir);
            for (File file2 : files) {
                String s = file2.toString();
                if (!s.endsWith(extension)) continue;
                tmp = tmp + s + " ";
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static boolean removeListFiles(String dir2, String extension) {
        boolean tmp = true;
        try {
            File tempDir = new File(dir2);
            List<File> files = Util.getFileListing(tempDir);
            for (File file2 : files) {
                boolean success;
                String s = file2.toString();
                if (!s.endsWith(extension) || (success = file2.delete())) continue;
                tmp = false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        Util.validateDirectory(aStartingDir);
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file2 : filesDirs) {
            result.add(file2);
            if (file2.isFile()) continue;
            List<File> deeperList = Util.getFileListing(file2);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static boolean createjararchive(String dir2, String str6) {
        List<File> files = null;
        String extension = ".class";
        boolean suc = true;
        try {
            File tempDir = new File(dir2);
            files = Util.getFileListing(tempDir);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            suc = false;
            return suc;
        }
        byte[] buffer3 = new byte[4096];
        boolean k = false;
        int k1 = 0;
        Object s = null;
        String g = null;
        try {
            FileOutputStream stream = new FileOutputStream(str6);
            JarOutputStream out = new JarOutputStream(stream);
            for (File file2 : files) {
                int nRead;
                String ss = file2.toString();
                if (!ss.endsWith(extension)) continue;
                k1 = ss.lastIndexOf("\\");
                g = ss.substring(k1 + 1);
                JarEntry jarAdd = new JarEntry(g);
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(ss);
                while ((nRead = in.read(buffer3, 0, buffer3.length)) > 0) {
                    out.write(buffer3, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            suc = false;
        }
        return suc;
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                Util.extractFile(zipIn, filePath);
            } else {
                File dir2 = new File(filePath);
                dir2.mkdir();
                dir2.setWritable(true);
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static void main(String[] args) throws Exception {
        FileInputStream fis = new FileInputStream("original.txt");
        FileOutputStream fos = new FileOutputStream("compressed.gz");
        GZIPOutputStream gos = new GZIPOutputStream(fos);
        Util.doCopy(fis, gos);
        FileInputStream fis2 = new FileInputStream("compressed.gz");
        GZIPInputStream gis = new GZIPInputStream(fis2);
        FileOutputStream fos2 = new FileOutputStream("uncompressed.txt");
        Util.doCopy(gis, fos2);
    }

    public static void doCopy(InputStream is, OutputStream os) throws Exception {
        int oneByte;
        while ((oneByte = is.read()) != -1) {
            os.write(oneByte);
        }
        os.close();
        is.close();
    }

    public static String readFileAsString(String filePath) {
        StringBuffer fileData = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileData.toString();
    }

    public static String readFileAsStringException(String filePath) throws IOException, FileNotFoundException {
        StringBuffer fileData = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
        }
        reader.close();
        return fileData.toString();
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                ret = ret && Util.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String address, String localFileName) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = new URL(address);
            out = new BufferedOutputStream(new FileOutputStream(localFileName));
            conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
                numWritten += (long)numRead;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Color darker(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 - fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 - fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 - fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }

    public static Color lighter(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 + fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 + fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 + fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }
}

