/*
 * Decompiled with CFR 0.152.
 */
package jehep.sexam;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import jehep.sexam.Global;
import jehep.sexam.HintTextFieldUI;
import jehep.sexam.MyAbstractTreeTableModel;
import jehep.sexam.MyDataModel;
import jehep.sexam.MyDataNode;
import jehep.sexam.MyTreeTable;
import jehep.sexam.PJP;
import jehep.sexam.Util;
import jehep.ui.Editor;
import jehep.ui.SecurityActive;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class OnlineProgramsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton runButton;
    private JButton openButton;
    private JButton intstalledButton;
    private JButton viewButton;
    private JPanel info;
    private JPanel upperPanel;
    private String[] items = new String[]{"All languages", "Jython", "Java", "Groovy", "JRuby", "BeanShell", "Octave"};
    private JComboBox langSelect;
    private JLabel jinfo;
    private JScrollPane jScrollPane1;
    private mainGUI win;
    private MyAbstractTreeTableModel treeTableModel;
    private MyTreeTable myTreeTable;
    private TreeMap<String, ArrayList<PJP>> webtopics1;
    private TreeMap<String, ArrayList<PJP>> webtopics2;
    private ImageIcon[] images;
    private HashMap<String, String> tooltips;
    private HashMap<String, PJP> webprograms;
    private SortedSet<String> examplekeys;
    private boolean show_all = true;
    private String selected = "";
    private ImageIcon closedIcon;
    private ImageIcon openIcon;
    private ImageIcon pythonIconFree;
    private ImageIcon pythonIconPro;
    private ImageIcon rubyIconFree;
    private ImageIcon rubyIconPro;
    private ImageIcon javaIconFree;
    private ImageIcon javaIconPro;
    private ImageIcon bshIconFree;
    private ImageIcon bshIconPro;
    private ImageIcon groovyIconFree;
    private ImageIcon groovyIconPro;
    private ImageIcon octaveIconFree;
    private ImageIcon octaveIconPro;
    private String tmpdir;
    private DefaultMutableTreeNode root;
    private ArrayList<PJP> local;
    private int n1 = 0;
    private int n2 = 0;
    private int ntot = 0;
    private JLabel jb1;
    private JLabel jb2;
    private JPanel buttons;
    private JTextField searchText;
    private JButton searchButton;
    private JButton freeButton;
    private String searchWord = "";
    private JPopupMenu popup;
    private int selLang = 0;

    public OnlineProgramsDialog(final mainGUI win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.setResizable(true);
        win.setPromptTabIndex(1);
        this.tmpdir = SetEnv.DirPath + SetEnv.fSep + "cachedir" + SetEnv.fSep;
        if (Global.webpjp == null || Global.webpjp.size() == 0) {
            Global.webpjp = Global.readWebIndex();
        }
        this.closedIcon = new ImageIcon(this.getClass().getResource("images/folderclosed.png"));
        this.openIcon = new ImageIcon(this.getClass().getResource("images/folderopen.png"));
        this.pythonIconPro = new ImageIcon(this.getClass().getResource("images/python-logo-pro.png"));
        this.pythonIconFree = new ImageIcon(this.getClass().getResource("images/python-logo-free.png"));
        this.rubyIconPro = new ImageIcon(this.getClass().getResource("images/ruby-logo-pro.png"));
        this.rubyIconFree = new ImageIcon(this.getClass().getResource("images/ruby-logo-free.png"));
        this.javaIconPro = new ImageIcon(this.getClass().getResource("images/java-logo-pro.png"));
        this.javaIconFree = new ImageIcon(this.getClass().getResource("images/java-logo-free.png"));
        this.bshIconPro = new ImageIcon(this.getClass().getResource("images/bsh-logo-pro.png"));
        this.bshIconFree = new ImageIcon(this.getClass().getResource("images/bsh-logo-free.png"));
        this.groovyIconPro = new ImageIcon(this.getClass().getResource("images/groovy-logo-pro.png"));
        this.groovyIconFree = new ImageIcon(this.getClass().getResource("images/groovy-logo-free.png"));
        this.octaveIconPro = new ImageIcon(this.getClass().getResource("images/octave-logo-pro.png"));
        this.octaveIconFree = new ImageIcon(this.getClass().getResource("images/octave-logo-free.png"));
        this.images = new ImageIcon[this.items.length];
        Integer[] intArray = new Integer[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            intArray[i] = new Integer(i);
            this.images[i] = this.createImageIcon("images/" + this.items[i] + ".png");
            if (this.images[i] == null) continue;
            this.images[i].setDescription(this.items[i]);
        }
        this.langSelect = new JComboBox<Integer>(intArray);
        ComboBoxRenderer renderer = new ComboBoxRenderer();
        renderer.setHorizontalAlignment(2);
        this.langSelect.setSelectedIndex(this.selLang);
        this.langSelect.setRenderer(renderer);
        this.langSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcmbType = (JComboBox)e.getSource();
                OnlineProgramsDialog.this.selLang = jcmbType.getSelectedIndex();
                OnlineProgramsDialog.this.reloadDialog();
            }
        });
        this.jb1 = new JLabel();
        this.jinfo = new JLabel("Ready");
        this.jinfo.setPreferredSize(new Dimension(270, 28));
        this.jinfo.setBackground(Color.white);
        Border border = BorderFactory.createLineBorder(Color.BLUE, 1);
        this.jinfo.setBorder(border);
        this.jinfo.setHorizontalAlignment(0);
        this.jinfo.setVerticalAlignment(0);
        JPanel lowerPanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OnlineProgramsDialog.this.setVisible(false);
                OnlineProgramsDialog.this.dispose();
            }
        });
        this.info = new JPanel(new BorderLayout());
        this.upperPanel = new JPanel(new BorderLayout());
        JPanel searchPanel1 = new JPanel(new BorderLayout());
        JPanel searchPanel2 = new JPanel(new BorderLayout());
        this.searchText = new JTextField();
        this.searchText.setUI(new HintTextFieldUI("Search", true));
        Font newTextFieldFont = new Font(this.searchText.getFont().getName(), 1, this.searchText.getFont().getSize());
        this.searchText.setFont(SetEnv.guiFont);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    Toolkit.getDefaultToolkit().beep();
                    String s = OnlineProgramsDialog.this.searchText.getText();
                    OnlineProgramsDialog.this.show_all = true;
                    OnlineProgramsDialog.this.searchWord = s.trim();
                    if (OnlineProgramsDialog.this.searchWord.length() > 2) {
                        OnlineProgramsDialog.this.searchText.selectAll();
                        OnlineProgramsDialog.this.reloadDialog();
                    }
                }
            }
        });
        this.searchButton = new JButton();
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String s = OnlineProgramsDialog.this.searchText.getText();
                OnlineProgramsDialog.this.searchWord = s.trim();
                OnlineProgramsDialog.this.show_all = true;
                if (OnlineProgramsDialog.this.searchWord.length() > 2) {
                    OnlineProgramsDialog.this.searchText.selectAll();
                    OnlineProgramsDialog.this.reloadDialog();
                }
            }
        });
        this.intstalledButton = new JButton("All");
        this.intstalledButton.setToolTipText("Show all programs");
        this.intstalledButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OnlineProgramsDialog.this.searchText.setText("");
                OnlineProgramsDialog.this.show_all = true;
                OnlineProgramsDialog.this.reloadDialog();
            }
        });
        this.freeButton = new JButton("Free");
        this.freeButton.setToolTipText("DataMelt-Pro examples");
        this.freeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OnlineProgramsDialog.this.searchText.setText("");
                OnlineProgramsDialog.this.searchWord = "";
                OnlineProgramsDialog.this.show_all = false;
                OnlineProgramsDialog.this.reloadDialog();
            }
        });
        this.searchButton.setPreferredSize(new Dimension(28, 28));
        this.searchButton.setToolTipText("Search in names or in description");
        ImageIcon searchIcon = new ImageIcon(this.getClass().getResource("images/search.png"));
        this.searchButton.setIcon(searchIcon);
        searchPanel2.add((Component)this.searchButton, "East");
        searchPanel1.add((Component)this.freeButton, "Center");
        searchPanel1.add((Component)this.intstalledButton, "West");
        searchPanel1.add((Component)this.langSelect, "East");
        this.upperPanel.add((Component)this.searchText, "Center");
        this.upperPanel.add((Component)searchPanel2, "East");
        this.upperPanel.add((Component)searchPanel1, "West");
        this.buttons = new JPanel();
        this.info.add((Component)this.jb1, "Center");
        this.runButton = new JButton("Open & Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = OnlineProgramsDialog.this.myTreeTable.getSelectedRow();
                if (row < 0) {
                    JOptionPane.showMessageDialog(win, "Please select the example code!");
                    return;
                }
                OnlineProgramsDialog.this.selected = (String)OnlineProgramsDialog.this.myTreeTable.getValueAt(row, 0);
                boolean found = OnlineProgramsDialog.this.openFile(OnlineProgramsDialog.this.selected);
                if (found) {
                    win.RunCommand();
                }
            }
        });
        this.openButton = new JButton("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = OnlineProgramsDialog.this.myTreeTable.getSelectedRow();
                if (row < 0) {
                    JOptionPane.showMessageDialog(win, "Please select the example code!");
                    return;
                }
                OnlineProgramsDialog.this.selected = (String)OnlineProgramsDialog.this.myTreeTable.getValueAt(row, 0);
                OnlineProgramsDialog.this.openFile(OnlineProgramsDialog.this.selected);
            }
        });
        this.viewButton = new JButton("CodeView");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int row = OnlineProgramsDialog.this.myTreeTable.getSelectedRow();
                if (row < 0) {
                    JOptionPane.showMessageDialog(win, "Please select the example code!");
                    return;
                }
                OnlineProgramsDialog.this.selected = (String)OnlineProgramsDialog.this.myTreeTable.getValueAt(row, 0);
                OnlineProgramsDialog.this.openFile(OnlineProgramsDialog.this.selected);
                win.generateHtml(true);
            }
        });
        this.fillDataForThisDialog();
        this.treeTableModel = new MyDataModel(this.createDataStructure());
        this.myTreeTable = new MyTreeTable(this.treeTableModel);
        this.popup = new JPopupMenu();
        JMenuItem jmm1 = new JMenuItem("View info");
        JMenuItem jmm2 = new JMenuItem("View code");
        this.popup.add(jmm1);
        this.popup.add(jmm2);
        ActionListener viewListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PJP data = (PJP)OnlineProgramsDialog.this.webprograms.get(OnlineProgramsDialog.this.selected);
                String fil = data.getName();
                String aut = data.getAuthor();
                String version = Float.toString(data.getVersion());
                long msec = (long)data.getTime() * 1000L;
                Date d = new Date(msec);
                String date = d.toString();
                String desc = data.getDescription();
                String pro = "GNU";
                if (data.getPro() == 1) {
                    pro = "DataMelt-Pro";
                }
                String mess = "File: " + fil + "<br>Author: " + aut + "<br>Version: " + version + "<br>Modified: " + date + "<br>License:" + pro;
                mess = "<HTML><BODY><P>" + mess + "</P></BODY></HTML>";
                JOptionPane.showMessageDialog(win, mess, "Example information", 1);
            }
        };
        ActionListener codeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OnlineProgramsDialog.this.openFile(OnlineProgramsDialog.this.selected);
            }
        };
        jmm1.addActionListener(viewListener);
        jmm2.addActionListener(codeListener);
        this.myTreeTable.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = new Point(e.getX(), e.getY());
                    int col = OnlineProgramsDialog.this.myTreeTable.columnAtPoint(p);
                    int row = OnlineProgramsDialog.this.myTreeTable.rowAtPoint(p);
                    if (!OnlineProgramsDialog.this.myTreeTable.isRowSelected(row)) {
                        OnlineProgramsDialog.this.myTreeTable.changeSelection(row, col, false, false);
                    }
                    OnlineProgramsDialog.this.selected = (String)OnlineProgramsDialog.this.myTreeTable.getValueAt(row, 0);
                    OnlineProgramsDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        });
        int size = Editor.getFont().getSize();
        String ssf = Editor.getFont().getFamily();
        this.myTreeTable.setCustomFont(new Font(ssf, 0, size), new Font(ssf, 0, size));
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.getViewport().add(this.myTreeTable);
        this.buttons.add((Component)this.openButton, null);
        this.buttons.add((Component)this.runButton, null);
        this.buttons.add((Component)this.viewButton, null);
        this.buttons.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttons.add((Component)this.closeButton, null);
        Rectangle bounds = win.getBounds();
        int ww = bounds.width;
        int hh = bounds.height;
        int xx = bounds.x;
        int yy = bounds.y;
        lowerPanel.setPreferredSize(new Dimension((int)((double)ww * 0.7), 80));
        this.jScrollPane1.setPreferredSize(new Dimension((int)((double)ww * 0.7), (int)((double)hh * 0.8)));
        lowerPanel.add((Component)this.info, "West");
        lowerPanel.add((Component)this.jinfo, "Center");
        lowerPanel.add((Component)this.buttons, "East");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.getContentPane().add((Component)this.upperPanel, "North");
        this.setTitle("DataMelt Example Manager");
        this.setSize((int)(0.85 * (double)ww), (int)(0.7 * (double)hh));
        Dimension tableSize = this.myTreeTable.getPreferredSize();
        this.myTreeTable.getColumn("Topic").setPreferredWidth((int)(0.25 * (double)ww));
        this.myTreeTable.getColumn("Topic").setMaxWidth((int)(0.7 * (double)ww));
        this.myTreeTable.getColumn("Topic").setMinWidth(100);
        this.myTreeTable.getColumn("Description").setPreferredWidth((int)(0.8 * (double)ww));
        this.myTreeTable.getColumn("Description").setMaxWidth((int)(0.95 * (double)ww));
        this.myTreeTable.getColumn("Description").setMinWidth(200);
        this.myTreeTable.getColumn("Macro").setPreferredWidth(80);
        this.myTreeTable.getColumn("Macro").setMaxWidth(100);
        this.myTreeTable.getColumn("Macro").setMinWidth(70);
        this.myTreeTable.getColumn("Date").setPreferredWidth(120);
        this.myTreeTable.getColumn("Date").setWidth(120);
        this.myTreeTable.getColumn("Date").setMaxWidth(300);
        this.myTreeTable.getColumn("Date").setMinWidth(100);
        Util.centreWithin(win, this);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public void fillDataForThisDialog() {
        this.webprograms = new HashMap();
        Global.size_available = 0L;
        this.examplekeys = new TreeSet<String>();
        if (Global.webpjp == null || Global.webpjp.size() == 0) {
            Global.webpjp = Global.readWebIndex();
        }
        this.ntot = 0;
        this.n1 = 0;
        this.n2 = 0;
        for (int i = 0; i < Global.webpjp.size(); ++i) {
            PJP pjp = Global.webpjp.get(i);
            String[] ss = pjp.getShortNameDesc();
            String dir2 = pjp.getDirectory();
            String name = ss[0];
            String string = ss[1];
            String fname = pjp.getName();
            Global.size_available += (long)pjp.getSize();
            String size = pjp.getSizeAsString();
            int type = pjp.getType();
            if (this.searchWord != null) {
                boolean ifound = false;
                if (this.searchWord.length() > 1) {
                    String slowercase = this.searchWord.toLowerCase();
                    if (name.toLowerCase().indexOf(slowercase) > -1 || string.toLowerCase().indexOf(slowercase) > -1 || dir2.toLowerCase().indexOf(slowercase) > -1) {
                        ifound = true;
                    }
                }
                if (this.searchWord.length() < 2) {
                    ifound = true;
                }
                if (!ifound) continue;
            }
            ++this.n1;
            boolean ispro = false;
            if (pjp.getPro() == 1) {
                ++this.n2;
                ispro = true;
            }
            if (!this.show_all && ispro) continue;
            boolean isLangTake = false;
            if (this.selLang == 0) {
                isLangTake = true;
            }
            if (this.selLang == type) {
                isLangTake = true;
            }
            if (!isLangTake) continue;
            this.examplekeys.add(dir2.trim());
            this.webprograms.put(name.trim(), pjp);
            ++this.ntot;
        }
        this.webtopics1 = new TreeMap();
        this.webtopics2 = new TreeMap();
        for (String key : this.examplekeys) {
            String name;
            PJP pjp;
            String[] parts = key.split("/");
            if (parts.length < 2) {
                TreeSet<String> tmp = new TreeSet<String>();
                for (Map.Entry entry : this.webprograms.entrySet()) {
                    pjp = (PJP)entry.getValue();
                    name = pjp.getName();
                    String dir3 = pjp.getDirectory();
                    String[] parts1 = dir3.split("/");
                    if (!parts1[0].trim().equalsIgnoreCase(parts[0].trim())) continue;
                    tmp.add(name);
                }
                ArrayList list1 = new ArrayList();
                for (String name2 : tmp) {
                    list1.add(this.webprograms.get(name2));
                }
                this.webtopics1.put(parts[0].trim(), list1);
            }
            if (parts.length <= 1) continue;
            TreeSet<String> tmp1 = new TreeSet<String>();
            for (Map.Entry entry : this.webprograms.entrySet()) {
                pjp = (PJP)entry.getValue();
                name = pjp.getName();
                if (!pjp.getDirectory().equals(key)) continue;
                tmp1.add(name);
            }
            ArrayList<PJP> list2 = new ArrayList<PJP>();
            for (String name2 : tmp1) {
                PJP obg = this.webprograms.get(name2);
                if (obg == null) continue;
                list2.add(obg);
            }
            this.webtopics2.put(parts[0].trim() + "/" + parts[1].trim(), list2);
            ArrayList<PJP> tt = this.webtopics1.get(parts[0].trim());
            if (tt != null) continue;
            this.webtopics1.put(parts[0].trim(), new ArrayList());
        }
        String s1 = "<html><b>" + Integer.toString(this.ntot) + " examples </b></html>";
        this.jb1.setText(s1);
    }

    public void reloadDialog() {
        this.fillDataForThisDialog();
        this.treeTableModel = new MyDataModel(this.createDataStructure());
        this.myTreeTable.setModel(this.treeTableModel);
        this.revalidate();
    }

    public MyDataNode createDataStructure() {
        int lii = SecurityActive.getLicenseValid();
        ArrayList<MyDataNode> rootNodes = new ArrayList<MyDataNode>();
        for (Map.Entry<String, ArrayList<PJP>> pairs : this.webtopics1.entrySet()) {
            String topic = pairs.getKey();
            ArrayList<PJP> list = pairs.getValue();
            ArrayList<MyDataNode> children = new ArrayList<MyDataNode>();
            ArrayList<String> subtopic = new ArrayList<String>();
            for (Map.Entry<String, ArrayList<PJP>> pairs1 : this.webtopics2.entrySet()) {
                String name = pairs1.getKey();
                String[] snames = name.split("/");
                String stopic = snames[0];
                if (!topic.equalsIgnoreCase(stopic)) continue;
                subtopic.add(snames[1]);
            }
            long lastesttime = 0L;
            HashSet<String> ignorekeys = new HashSet<String>();
            int nsubs = 0;
            for (int j = 0; j < subtopic.size(); ++j) {
                String sub = (String)subtopic.get(j);
                ArrayList<MyDataNode> children1 = new ArrayList<MyDataNode>();
                ArrayList<PJP> pp = this.webtopics2.get(topic + "/" + sub);
                int nexm1 = 0;
                long time1 = 0L;
                for (int j1 = 0; j1 < pp.size(); ++j1) {
                    PJP pjp = pp.get(j1);
                    long msec1 = (long)pjp.getTime() * 1000L;
                    Date d = new Date(msec1);
                    String name1 = pjp.getName();
                    ignorekeys.add(name1);
                    ImageIcon image = this.getFileIcon(lii, pjp);
                    children1.add(new MyDataNode(name1, image, pjp.getDescription(), d, null));
                    ++nexm1;
                    if (msec1 <= time1) continue;
                    time1 = msec1;
                }
                nsubs += nexm1;
                children.add(new MyDataNode(sub, null, Integer.toString(nexm1) + " examples", null, children1));
                lastesttime = time1;
            }
            int nexm = 0;
            long time = 0L;
            for (int j = 0; j < list.size(); ++j) {
                PJP pjp = list.get(j);
                long msec = (long)pjp.getTime() * 1000L;
                Date d = new Date(msec);
                String name = pjp.getName();
                boolean exists = ignorekeys.contains(name);
                if (exists) continue;
                ImageIcon image = this.getFileIcon(lii, pjp);
                children.add(new MyDataNode(name, image, pjp.getDescription(), d, null));
                ++nexm;
                if (msec <= time) continue;
                time = msec;
            }
            if (time > lastesttime) {
                lastesttime = time;
            }
            rootNodes.add(new MyDataNode(topic, null, Integer.toString(nexm + nsubs) + " examples", new Date(lastesttime), children));
        }
        MyDataNode root = new MyDataNode("Root", null, " ", null, rootNodes);
        return root;
    }

    private boolean openFile(String selected) {
        File temp = new File(this.tmpdir + selected);
        if (!this.webprograms.containsKey(selected)) {
            return false;
        }
        PJP data = this.webprograms.get(selected);
        String macro = data.getMacro();
        float version = data.getVersion();
        if (version > Float.parseFloat(SetEnv.VERSION)) {
            JOptionPane.showMessageDialog(this.win, SetEnv.getMessage("Example code was generated using a newer version of DataMelt. <br> Please update the DataMelt installation.</a>"), "Micro version problem", 0);
            return false;
        }
        if (SecurityActive.getLicenseValid() == 0 && data.getPro() == 1) {
            JOptionPane.showMessageDialog(this.win, SetEnv.getMessage("No License Key for DataMelt Professional edition! <br> Please request a membeship from <br> <a href=\"https://datamelt.org/\">https://datamelt.org/</a>"), "License Key Failure", 0);
            return false;
        }
        boolean isfile = temp.exists();
        boolean iscash = false;
        if (isfile) {
            long length = temp.length();
            if (Math.abs(length - (long)data.getSize()) < 1000L && length > 1L && data.getSize() > 1) {
                this.win.open(temp.getAbsolutePath(), false);
                iscash = true;
                this.jinfo.setText("View: " + selected);
            }
            return true;
        }
        if (macro == null && !iscash) {
            macro = Global.readMacro(data.getHash());
            data.setMacro(macro);
        }
        if (!iscash) {
            this.jinfo.setText("View: " + selected);
            try {
                FileWriter fw = new FileWriter(temp);
                fw.write(macro);
                fw.close();
                this.win.open(temp.getAbsolutePath(), false);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private ImageIcon getFileIcon(int lii, PJP pjp) {
        int type = pjp.getType();
        ImageIcon image = this.pythonIconFree;
        if (type == 1) {
            image = this.pythonIconFree;
        }
        if (type == 1 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.pythonIconPro;
        }
        if (type == 4) {
            image = this.rubyIconFree;
        }
        if (type == 4 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.rubyIconPro;
        }
        if (type == 2) {
            image = this.javaIconFree;
        }
        if (type == 2 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.javaIconPro;
        }
        if (type == 3) {
            image = this.groovyIconFree;
        }
        if (type == 3 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.groovyIconPro;
        }
        if (type == 6) {
            image = this.octaveIconFree;
        }
        if (type == 6 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.octaveIconPro;
        }
        if (type == 5) {
            image = this.bshIconFree;
        }
        if (type == 5 && (pjp.getPro() > 0 || lii > 0)) {
            image = this.bshIconPro;
        }
        return image;
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(this.getClass().getResource("images/All.png"));
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font uhOhFont;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ImageIcon icon = OnlineProgramsDialog.this.images[selectedIndex];
            String pet = OnlineProgramsDialog.this.items[selectedIndex];
            this.setIcon(icon);
            if (icon != null) {
                this.setText(pet);
                this.setFont(list.getFont());
            } else {
                this.setText(pet);
                this.setFont(list.getFont());
                this.setIcon(OnlineProgramsDialog.this.createImageIcon("images/All.png"));
            }
            return this;
        }

        protected void setUhOhText(String uhOhText, Font normalFont) {
            if (this.uhOhFont == null) {
                this.uhOhFont = normalFont.deriveFont(2);
            }
            this.setFont(this.uhOhFont);
            this.setText(uhOhText);
        }
    }
}

