/*
 * Decompiled with CFR 0.152.
 */
package jehep.gnu.regexp;

import jehep.gnu.regexp.CharIndexed;
import jehep.gnu.regexp.REMatch;
import jehep.gnu.regexp.REToken;

final class RETokenRange
extends REToken {
    private char lo;
    private char hi;
    private boolean insens;

    RETokenRange(int subIndex, char lo, char hi, boolean ins) {
        super(subIndex);
        this.insens = ins;
        this.lo = this.insens ? Character.toLowerCase(lo) : lo;
        this.hi = ins ? Character.toLowerCase(hi) : hi;
    }

    @Override
    int getMinimumLength() {
        return 1;
    }

    @Override
    boolean match(CharIndexed input, REMatch mymatch) {
        char c = input.charAt(mymatch.index);
        if (c == '\uffff') {
            return false;
        }
        if (this.insens) {
            c = Character.toLowerCase(c);
        }
        if (c >= this.lo && c <= this.hi) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    @Override
    void dump(StringBuffer os) {
        os.append(this.lo).append('-').append(this.hi);
    }
}

