/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class Communicator {
    private static Component computeParent(Component parent) {
        if (parent == null) {
            return parent;
        }
        Container parent_1 = parent.getParent();
        if (parent_1 == null) {
            return parent;
        }
        Container parent_2 = parent_1.getParent();
        if (parent_2 == null) {
            return parent;
        }
        if (parent_2 instanceof JScrollPane) {
            return parent_2;
        }
        return parent;
    }

    public static void showErrorMessage(Component parent, String msg, Exception e) {
        Communicator.showErrorMessage(Communicator.computeParent(parent), msg + (e == null ? "" : "[" + e.getMessage() + "]"));
    }

    public static void showErrorMessage(Component parent, String msg) {
        JOptionPane.showMessageDialog(Communicator.computeParent(parent), msg, "Error!", 0);
    }

    public static void showInfoMessage(Component parent, String msg) {
        JOptionPane.showMessageDialog(Communicator.computeParent(parent), msg, "Information.", 1);
    }

    public static boolean askYesNo(Component parent, String msg) {
        int result = JOptionPane.showConfirmDialog(Communicator.computeParent(parent), msg, "Question.", 0);
        return result == 0;
    }

    public static String askForInput(Component parent, String msg) {
        return JOptionPane.showInputDialog(Communicator.computeParent(parent), (Object)msg);
    }

    public static void showWarningMessage(Component parent, String msg) {
        JOptionPane.showMessageDialog(Communicator.computeParent(parent), msg, "Warning!", 2);
    }

    public static void showWarningMessage(Component parent, String msg, Exception e) {
        Communicator.showWarningMessage(parent, msg + (e == null ? " [" + e.getMessage() + "]" : ""));
    }
}

