/*
 * Decompiled with CFR 0.152.
 */
package jabref.undo;

import jabref.BasePanel;
import jabref.BibtexString;
import jabref.Globals;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableStringChange
extends AbstractUndoableEdit {
    private BibtexString string;
    private String oldValue;
    private String newValue;
    private boolean nameChange;
    private BasePanel panel;

    public UndoableStringChange(BasePanel panel, BibtexString string, boolean nameChange, String oldValue, String newValue) {
        this.string = string;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.nameChange = nameChange;
        this.panel = panel;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang(this.nameChange ? "change string name" : "change string content");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang(this.nameChange ? "change string name" : "change string content");
    }

    @Override
    public void undo() {
        super.undo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.oldValue);
        } else {
            this.string.setContent(this.oldValue);
        }
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.newValue);
        } else {
            this.string.setContent(this.newValue);
        }
        this.panel.updateStringDialog();
    }
}

