/*
 * Decompiled with CFR 0.152.
 */
package jabref.undo;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.Util;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableInsertEntry
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private BibtexEntry entry;
    private BasePanel panel;

    public UndoableInsertEntry(BibtexDatabase base, BibtexEntry entry, BasePanel panel) {
        this.base = base;
        this.entry = entry;
        this.panel = panel;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: insert entry";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: insert entry";
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.removeEntry(this.entry.getId());
            this.panel.ensureNotShowing(this.entry);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            String id = Util.createId(this.entry.getType(), this.base);
            this.entry.setId(id);
            this.base.insertEntry(this.entry);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

