/*
 * Decompiled with CFR 0.152.
 */
package jabref.imports;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.BibtexString;
import jabref.GUIGlobals;
import jabref.KeyCollisionException;
import jabref.Util;
import jabref.imports.ParserResult;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;

public class BibtexParser {
    private PushbackReader _in;
    private BibtexDatabase _db;
    private HashMap _meta;
    private boolean _eof = false;
    private int line = 1;

    public BibtexParser(Reader in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(in);
    }

    private void skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.read()) != -1 && c != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)c));
        this.unread(c);
    }

    public ParserResult parse() throws IOException {
        this._db = new BibtexDatabase();
        this._meta = new HashMap();
        this.skipWhitespace();
        try {
            while (!this._eof) {
                String rest;
                int pos;
                StringBuffer comment;
                this.consumeUncritically('@');
                this.skipWhitespace();
                String entryType = this.parseTextToken();
                BibtexEntryType tp = BibtexEntryType.getType(entryType);
                if (tp != null) {
                    this._db.insertEntry(this.parseEntry(tp));
                } else if (entryType.toLowerCase().equals("preamble")) {
                    this._db.setPreamble(this.parsePreamble());
                } else if (entryType.toLowerCase().equals("string")) {
                    this._db.addString(this.parseString(), this._db.getStringCount());
                } else if (entryType.toLowerCase().equals("comment") && ((comment = this.parseBracketedText()).substring(0, GUIGlobals.META_FLAG.length()).equals(GUIGlobals.META_FLAG) || comment.substring(0, GUIGlobals.META_FLAG_OLD.length()).equals(GUIGlobals.META_FLAG_OLD)) && (pos = (rest = comment.substring(0, GUIGlobals.META_FLAG.length()).equals(GUIGlobals.META_FLAG) ? comment.substring(GUIGlobals.META_FLAG.length()) : comment.substring(GUIGlobals.META_FLAG_OLD.length())).indexOf(58)) > 0) {
                    this._meta.put(rest.substring(0, pos), rest.substring(pos + 1));
                }
                this.skipWhitespace();
            }
            return new ParserResult(this._db, this._meta);
        }
        catch (KeyCollisionException kce) {
            throw new IOException("Duplicate ID in bibtex file: " + kce.toString());
        }
    }

    private int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    private int read() throws IOException {
        int c = this._in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private void unread(int c) throws IOException {
        if (c == 10) {
            --this.line;
        }
        this._in.unread(c);
    }

    public BibtexString parseString() throws IOException {
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String name = this.parseTextToken();
        this.skipWhitespace();
        this.consume('=');
        String content = this.parseFieldContent();
        this.consume('}', ')');
        return new BibtexString(name, content);
    }

    public String parsePreamble() throws IOException {
        return this.parseBracketedText().toString();
    }

    public BibtexEntry parseEntry(BibtexEntryType tp) throws IOException {
        int c;
        String id = Util.createId(tp, this._db);
        BibtexEntry result = new BibtexEntry(id, tp);
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String key = null;
        boolean doAgain = true;
        while (doAgain) {
            doAgain = false;
            try {
                if (key != null) {
                    key = key + this.parseKey();
                    continue;
                }
                key = this.parseKey();
            }
            catch (NoLabelException ex) {
                char c2 = (char)this.peek();
                if (Character.isWhitespace(c2) || c2 == '{' || c2 == '\"') {
                    String cont = this.parseFieldContent();
                    result.setField(ex.getMessage().trim().toLowerCase(), cont);
                    continue;
                }
                key = key != null ? key + ex.getMessage() + "=" : ex.getMessage() + "=";
                doAgain = true;
            }
        }
        if (key.equals("")) {
            key = null;
        }
        if (result != null) {
            result.setField(GUIGlobals.KEY_FIELD, key);
        }
        this.skipWhitespace();
        while ((c = this.peek()) != 125 && c != 41) {
            this.consume(',');
            this.skipWhitespace();
            c = this.peek();
            if (c == 125 || c == 41) break;
            this.parseField(result);
        }
        this.consume('}', ')');
        return result;
    }

    private void parseField(BibtexEntry entry) throws IOException {
        String key = this.parseTextToken().toLowerCase();
        this.skipWhitespace();
        this.consume('=');
        String content = this.parseFieldContent();
        if (content.length() > 0) {
            entry.setField(key, content);
        }
    }

    private String parseFieldContent() throws IOException {
        int c;
        this.skipWhitespace();
        StringBuffer value = new StringBuffer();
        int j = 46;
        while ((c = this.peek()) != 44 && c != 125 && c != 41) {
            if (this._eof) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (c == 34) {
                this.consume('\"');
                while (this.peek() != 34 || j == 92) {
                    j = this.read();
                    if (this._eof || j == -1 || j == 65535) {
                        throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
                    }
                    value.append((char)j);
                }
                this.consume('\"');
            } else if (c == 123) {
                value.append(this.parseBracketedText());
            } else if (Character.isDigit((char)c)) {
                String numString = this.parseTextToken();
                int numVal = Integer.parseInt(numString);
                value.append(new Integer(numVal).toString());
            } else if (c == 35) {
                this.consume('#');
            } else {
                String textToken = this.parseTextToken();
                if (textToken.length() == 0) {
                    throw new IOException("Error in line " + this.line + " or above: Empty text token.\nThis could be caused by a missing comma between two fields.");
                }
                value.append("#" + textToken + "#");
            }
            this.skipWhitespace();
        }
        return value.toString();
    }

    private String parseTextToken() throws IOException {
        int c;
        StringBuffer token = new StringBuffer(20);
        while (true) {
            if ((c = this.read()) == -1) {
                this._eof = true;
                return token.toString();
            }
            if (!Character.isLetterOrDigit((char)c) && c != 58 && c != 45 && c != 95 && c != 42 && c != 43 && c != 46 && c != 47 && c != 39) break;
            token.append((char)c);
        }
        this.unread(c);
        return token.toString();
    }

    private String parseKey() throws IOException, NoLabelException {
        int c;
        StringBuffer token = new StringBuffer(20);
        while (true) {
            if ((c = this.read()) == -1) {
                this._eof = true;
                return token.toString();
            }
            if (!Character.isLetterOrDigit((char)c) && (c == 35 || c == 123 || c == 125 || c == 65533 || c == 126 || c == 65533 || c == 44 || c == 61)) break;
            token.append((char)c);
        }
        if (c == 44) {
            this.unread(c);
            return token.toString();
        }
        if (c == 61) {
            throw new NoLabelException(token.toString());
        }
        throw new IOException("Error in line " + this.line + ":Character '" + (char)c + "' is not allowed in bibtex keys.");
    }

    private StringBuffer parseBracketedText() throws IOException {
        StringBuffer value = new StringBuffer();
        this.consume('{');
        int brackets = 0;
        while (this.peek() != 125 || brackets != 0) {
            int j = this.read();
            if (j == -1 || j == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (j == 123) {
                ++brackets;
            } else if (j == 125) {
                --brackets;
            }
            if (Character.isWhitespace((char)j)) {
                value.append(' ');
                this.skipWhitespace();
                continue;
            }
            value.append((char)j);
        }
        this.consume('}');
        return value;
    }

    private void consume(char expected) throws IOException {
        int c = this.read();
        if (c != expected) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + expected + " but received " + (char)c);
        }
    }

    private void consumeUncritically(char expected) throws IOException {
        int c;
        while ((c = this.read()) != expected && c != -1 && c != 65535) {
        }
        if (c == -1 || c == 65535) {
            this._eof = true;
        }
    }

    private void consume(char expected1, char expected2) throws IOException {
        int c = this.read();
        if (c != expected1 && c != expected2) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + expected1 + " or " + expected2 + " but received " + c);
        }
    }

    private class NoLabelException
    extends Exception {
        public NoLabelException(String hasRead) {
            super(hasRead);
        }
    }
}

