/*
 * Decompiled with CFR 0.152.
 */
package jabref.imports;

import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.Util;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BibTeXMLHandler
extends DefaultHandler {
    private ArrayList bibitems;
    private BibtexEntry b;
    private String name;
    private String currentChars;

    public ArrayList getItems() {
        return this.bibitems;
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
    }

    @Override
    public void startDocument() {
        this.bibitems = new ArrayList();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        this.currentChars = this.currentChars + s;
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        String name;
        this.name = name = raw;
        if (name.equals("bibtex:entry")) {
            String articleID = null;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("bibtex:id") && !atts.getQName(i).equals("id")) continue;
                articleID = atts.getValue(i);
            }
            this.b = new BibtexEntry(Util.createNeutralId());
            this.b.setField("bibtexkey", articleID);
        } else if (name.equals("bibtex:article") || name.equals("bibtex:inbook") || name.equals("bibtex:book") || name.equals("bibtex:booklet") || name.equals("bibtex:incollection") || name.equals("bibtex:inproceedings") || name.equals("bibtex:proceedings") || name.equals("bibtex:manual") || name.equals("bibtex:mastersthesis") || name.equals("bibtex:phdthesis") || name.equals("bibtex:techreport") || name.equals("bibtex:unpublished") || name.equals("bibtex:misc") || name.equals("bibtex:other")) {
            BibtexEntryType tp = BibtexEntryType.getType(local);
            this.b.setType(tp);
        }
        this.currentChars = "";
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        String name = raw;
        if (name.equals("bibtex:entry")) {
            this.bibitems.add(this.b);
        } else if (name.startsWith("bibtex:")) {
            this.b.setField(local, this.currentChars);
        }
        this.currentChars = "";
    }
}

