/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.GUIGlobals;
import jabref.Globals;
import jabref.Util;
import jabref.groups.GroupSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GroupDialog
extends JDialog {
    JTextField name = new JTextField(60);
    JTextField regexp = new JTextField(60);
    JTextField field = new JTextField(60);
    JLabel nl = new JLabel(Globals.lang("Group name") + ":");
    JLabel nr = new JLabel(Globals.lang("Search term") + ":");
    JLabel nf = new JLabel(Globals.lang("Field to search") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JPanel main = new JPanel();
    JPanel opt = new JPanel();
    private boolean ok_pressed = false;
    private Vector groups;
    private int index;
    private JFrame parent;
    private String oldName;
    private String oldRegexp;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public GroupDialog(JFrame parent_, Vector groups_, int index_, String defaultField) {
        super(parent_, Globals.lang("Edit group"), true);
        this.parent = parent_;
        this.groups = groups_;
        this.index = index_;
        if (this.index >= 0) {
            try {
                this.oldField = (String)this.groups.elementAt(this.index);
                this.field.setText(this.oldField);
                this.oldName = (String)this.groups.elementAt(this.index + 1);
                this.name.setText(this.oldName);
                this.oldRegexp = (String)this.groups.elementAt(this.index + 2);
                this.regexp.setText(this.oldRegexp);
                this.field.setEnabled(false);
                this.regexp.setEnabled(false);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            this.field.setText(defaultField);
        }
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroupDialog.this.field.getText().equals("") || GroupDialog.this.name.getText().equals("") || GroupDialog.this.regexp.getText().equals("")) {
                    JOptionPane.showMessageDialog(GroupDialog.this.parent, Globals.lang("You must provide a name, a search string and a field name for this group."), Globals.lang("Create group"), 0);
                    return;
                }
                GroupDialog.this.ok_pressed = true;
                if (GroupDialog.this.index < 0) {
                    GroupDialog.this.index = GroupSelector.findPos(GroupDialog.this.groups, GroupDialog.this.name.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.regexp.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.name.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.field.getText().toLowerCase());
                } else if (GroupDialog.this.index < GroupDialog.this.groups.size()) {
                    for (int i = 0; i < 3; ++i) {
                        GroupDialog.this.groups.removeElementAt(GroupDialog.this.index);
                    }
                    GroupDialog.this.index = GroupSelector.findPos(GroupDialog.this.groups, GroupDialog.this.name.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.regexp.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.name.getText());
                    GroupDialog.this.groups.add(GroupDialog.this.index, GroupDialog.this.field.getText().toLowerCase());
                }
                GroupDialog.this.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        this.name.addActionListener(okListener);
        this.regexp.addActionListener(okListener);
        this.field.addActionListener(okListener);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        ActionMap am = this.main.getActionMap();
        InputMap im = this.main.getInputMap(2);
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", cancelAction);
        this.main.setLayout(this.gbl);
        this.opt.setLayout(this.gbl);
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Group properties")));
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.con.anchor = 13;
        this.con.fill = 0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.nl, this.con);
        this.main.add(this.nl);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.nr, this.con);
        this.main.add(this.nr);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.nf, this.con);
        this.main.add(this.nf);
        this.con.weightx = 1.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 1;
        this.gbl.setConstraints(this.name, this.con);
        this.main.add(this.name);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.regexp, this.con);
        this.main.add(this.regexp);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.field, this.con);
        this.main.add(this.field);
        this.con.gridx = -1;
        this.con.gridy = -1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.con.anchor = 13;
        this.con.fill = 0;
        this.gbl.setConstraints(this.ok, this.con);
        this.opt.add(this.ok);
        this.con.anchor = 17;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.cancel, this.con);
        this.opt.add(this.cancel);
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.opt, "South");
        this.setSize(400, 170);
        Util.placeDialog(this, this.parent);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public int index() {
        return this.index;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldName() {
        return this.oldName;
    }

    public String oldRegexp() {
        return this.oldRegexp;
    }

    public String field() {
        return this.field.getText();
    }

    public String name() {
        return this.name.getText();
    }

    public String regexp() {
        return this.regexp.getText();
    }
}

