/*
 * Decompiled with CFR 0.152.
 */
package jabref.groups;

import jabref.BasePanel;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.Util;
import jabref.groups.GroupSelector;
import jabref.groups.UndoableAddOrRemoveGroup;
import jabref.undo.NamedCompound;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AutoGroupDialog
extends JDialog {
    JTextField remove = new JTextField(60);
    JTextField field = new JTextField(60);
    JLabel nr = new JLabel(Globals.lang("Characters to ignore") + ":");
    JLabel nf = new JLabel(Globals.lang("Field to group by") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JPanel main = new JPanel();
    JPanel opt = new JPanel();
    private boolean ok_pressed = false;
    private Vector groups;
    private JabRefFrame frame;
    private BasePanel panel;
    private GroupSelector gs;
    private String oldRemove;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public AutoGroupDialog(JabRefFrame frame_, BasePanel panel_, GroupSelector gs_, Vector groups_, String defaultField, String defaultRemove) {
        super(frame_, Globals.lang("Automatically create groups"), true);
        this.frame = frame_;
        this.gs = gs_;
        this.panel = panel_;
        this.groups = groups_;
        this.field.setText(defaultField);
        this.remove.setText(defaultRemove);
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutoGroupDialog.this.field.getText().equals("")) {
                    JOptionPane.showMessageDialog(AutoGroupDialog.this.frame, Globals.lang("You must provide a field name as basis for the group creation."), Globals.lang("Automatically create groups"), 0);
                    return;
                }
                AutoGroupDialog.this.ok_pressed = true;
                AutoGroupDialog.this.dispose();
                HashSet hs = Util.findAllWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase(), " " + AutoGroupDialog.this.remove());
                Vector<UndoableAddOrRemoveGroup> added = new Vector<UndoableAddOrRemoveGroup>(20, 20);
                NamedCompound ce = new NamedCompound(Globals.lang("Autogenerate groups"));
                Iterator i = hs.iterator();
                while (i.hasNext()) {
                    String regExp = i.next().toString().toLowerCase();
                    boolean found = false;
                    for (int j = 1; j < AutoGroupDialog.this.groups.size(); j += 3) {
                        if (!regExp.equals(((String)AutoGroupDialog.this.groups.elementAt(j)).toLowerCase())) continue;
                        found = true;
                    }
                    if (found) continue;
                    int index = GroupSelector.findPos(AutoGroupDialog.this.groups, regExp);
                    added.add(new UndoableAddOrRemoveGroup(AutoGroupDialog.this.gs, AutoGroupDialog.this.groups, index, true, AutoGroupDialog.this.field(), Util.nCase(regExp), regExp));
                    AutoGroupDialog.this.groups.add(index, regExp);
                    AutoGroupDialog.this.groups.add(index, Util.nCase(regExp));
                    AutoGroupDialog.this.groups.add(index, AutoGroupDialog.this.field());
                }
                if (added.size() > 0) {
                    AutoGroupDialog.this.panel.markBaseChanged();
                    AutoGroupDialog.this.gs.revalidateList(0);
                    AutoGroupDialog.this.frame.output(Globals.lang("Created groups."));
                    if (added.size() > 2) {
                        for (int k = 1; k < added.size() - 1; ++k) {
                            ((UndoableAddOrRemoveGroup)added.elementAt(k)).setRevalidate(false);
                        }
                    }
                    for (int k = 0; k < added.size(); ++k) {
                        ce.addEdit((UndoableAddOrRemoveGroup)added.elementAt(k));
                    }
                    ce.end();
                    ((AutoGroupDialog)AutoGroupDialog.this).panel.undoManager.addEdit(ce);
                }
            }
        };
        this.remove.addActionListener(okListener);
        this.field.addActionListener(okListener);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoGroupDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.ok.addActionListener(okListener);
        ActionMap am = this.main.getActionMap();
        InputMap im = this.main.getInputMap(2);
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", cancelAction);
        this.main.setLayout(this.gbl);
        this.opt.setLayout(this.gbl);
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Group properties")));
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.con.anchor = 13;
        this.con.fill = 0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.nf, this.con);
        this.main.add(this.nf);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.nr, this.con);
        this.main.add(this.nr);
        this.con.weightx = 1.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 1;
        this.gbl.setConstraints(this.field, this.con);
        this.main.add(this.field);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.remove, this.con);
        this.main.add(this.remove);
        this.con.gridx = -1;
        this.con.gridy = -1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.con.anchor = 13;
        this.con.fill = 0;
        this.gbl.setConstraints(this.ok, this.con);
        this.opt.add(this.ok);
        this.con.anchor = 17;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.cancel, this.con);
        this.opt.add(this.cancel);
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.opt, "South");
        this.setSize(400, 140);
        Util.placeDialog(this, this.frame);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldRemove() {
        return this.oldRemove;
    }

    public String field() {
        return this.field.getText();
    }

    public String remove() {
        return this.remove.getText();
    }
}

