/*
 * Decompiled with CFR 0.152.
 */
package jabref.export.layout;

import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.export.layout.Layout;
import jabref.export.layout.LayoutHelper;
import jabref.imports.BibtexParser;
import jabref.imports.ParserResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class LayoutTest {
    public static void main(String[] args) {
        LayoutTest test = null;
        test = new LayoutTest();
        if (args.length != 3) {
            System.err.println("Usage: LayoutTest <BibTeX-File> <Layout-File> <Output-File>");
        } else {
            test.test(args[0], args[1], args[2]);
        }
    }

    private void test(String bibtexFile, String layoutFile, String outputFile) {
        InputStreamReader reader;
        FileInputStream fis;
        File file2 = new File(bibtexFile);
        File outFile = new File(outputFile);
        BibtexParser bparser = null;
        BibtexDatabase bibtex = null;
        PrintStream ps = null;
        try {
            fis = new FileInputStream(file2);
            reader = new InputStreamReader(fis);
            ps = new PrintStream(new FileOutputStream(outFile));
            bparser = new BibtexParser(reader);
            ParserResult pr = bparser.parse();
            bibtex = pr.getDatabase();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file2 = new File(layoutFile);
        try {
            fis = new FileInputStream(file2);
            reader = new InputStreamReader(fis);
            LayoutHelper layoutHelper = new LayoutHelper(reader);
            Layout layout = layoutHelper.getLayoutFromText();
            Object[] keys = bibtex.getKeySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                BibtexEntry entry = bibtex.getEntryById(key);
                ps.println(layout.doLayout(entry));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

