/*
 * Decompiled with CFR 0.152.
 */
package jabref.export.layout;

import jabref.BibtexEntry;
import jabref.export.layout.LayoutEntry;
import jabref.wsi.ra.types.StringInt;
import java.util.Vector;

public class Layout {
    private LayoutEntry[] layoutEntries;

    public Layout(Vector parsedEntries) {
        int i;
        Vector<LayoutEntry> tmpEntries = new Vector<LayoutEntry>(parsedEntries.size());
        Vector<StringInt> blockEntries = null;
        String blockStart = null;
        for (i = 0; i < parsedEntries.size(); ++i) {
            StringInt si = (StringInt)parsedEntries.get(i);
            if (si.i != 1 && si.i != 2) {
                if (si.i == 3) {
                    blockEntries = new Vector<StringInt>();
                    blockStart = si.s;
                } else if (si.i == 4) {
                    if (blockStart.equals(si.s)) {
                        blockEntries.add(si);
                        LayoutEntry le = new LayoutEntry(blockEntries);
                        tmpEntries.add(le);
                        blockEntries = null;
                    } else {
                        System.err.println("Nested field entries are not implemented !!!");
                    }
                } else if (si.i == 5) {
                    // empty if block
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(si));
                continue;
            }
            blockEntries.add(si);
        }
        this.layoutEntries = new LayoutEntry[tmpEntries.size()];
        for (i = 0; i < tmpEntries.size(); ++i) {
            this.layoutEntries[i] = (LayoutEntry)tmpEntries.get(i);
        }
    }

    public String doLayout(BibtexEntry bibtex) {
        StringBuffer sb = new StringBuffer(100);
        boolean previousSkipped = false;
        for (int i = 0; i < this.layoutEntries.length; ++i) {
            String fieldText = this.layoutEntries[i].doLayout(bibtex);
            if (fieldText == null) {
                if (i + 1 < this.layoutEntries.length && this.layoutEntries[i + 1].doLayout(bibtex).trim().length() == 0) {
                    ++i;
                    previousSkipped = true;
                    continue;
                }
            } else if (previousSkipped) {
                int eol;
                for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                }
                if (eol < fieldText.length()) {
                    sb.append(fieldText.substring(eol));
                }
            } else {
                sb.append(fieldText);
            }
            previousSkipped = false;
        }
        return sb.toString();
    }
}

