/*
 * Decompiled with CFR 0.152.
 */
package jabref.export;

import jabref.Globals;
import jabref.Util;
import jabref.export.FieldFormatter;
import java.text.StringCharacterIterator;
import java.util.Vector;

public class LatexFieldFormatter
implements FieldFormatter {
    StringBuffer sb;
    int col;
    final int STARTCOL = 4;

    @Override
    public String format(String text, boolean standardBibtex) throws IllegalArgumentException {
        if (!standardBibtex) {
            return "{" + Util.wrap2(text, 65) + "}";
        }
        this.sb = new StringBuffer();
        int pivot = 0;
        int pos1 = -1;
        int pos2 = -1;
        boolean tell = false;
        this.col = 4;
        this.checkBraces(text);
        while (pivot < text.length()) {
            int goFrom = pivot;
            pos1 = pivot;
            while (goFrom == pos1) {
                pos1 = text.indexOf(35, goFrom);
                if (pos1 > 0 && text.charAt(pos1 - 1) == '\\') {
                    goFrom = pos1 + 1;
                    ++pos1;
                    continue;
                }
                goFrom = pos1 - 1;
            }
            if (pos1 == -1) {
                pos1 = text.length();
                pos2 = -1;
            } else {
                pos2 = text.indexOf(35, pos1 + 1);
                if (pos2 == -1) {
                    throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX fields") + ".\n" + Globals.lang("In JabRef, use pairs of # characters to indicate a string.") + "\n" + Globals.lang("Note that the entry causing the problem has been selected."));
                }
            }
            if (pos1 > pivot) {
                this.writeText(text, pivot, pos1);
            }
            if (pos1 < text.length() && pos2 - 1 > pos1) {
                this.writeStringLabel(text, pos1 + 1, pos2, pos1 == pivot, pos2 + 1 == text.length());
            }
            if (pos2 > -1) {
                pivot = pos2 + 1;
                continue;
            }
            pivot = pos1 + 1;
        }
        return this.sb.toString();
    }

    private void writeText(String text, int start_pos, int end_pos) {
        this.sb.append('{');
        boolean escape = false;
        for (int i = start_pos; i < end_pos; ++i) {
            char c = text.charAt(i);
            if (c == '&' && !escape) {
                this.sb.append("\\&");
            } else {
                this.sb.append(c);
            }
            escape = c == '\\';
        }
        this.sb.append('}');
    }

    private void writeStringLabel(String text, int start_pos, int end_pos, boolean first, boolean last) {
        this.putIn((first ? "" : " # ") + text.substring(start_pos, end_pos) + (last ? "" : " # "));
    }

    private void putIn(String s) {
        this.sb.append(Util.wrap2(s, 65));
    }

    private void oldwrap(String s) {
        boolean whitesp = false;
        boolean last = false;
        boolean cont = true;
        int lastWh = -1;
        int lastWhCol = -1;
        StringCharacterIterator it = new StringCharacterIterator(s);
        char c = it.first();
        String toSetIn = "";
        while (cont) {
            toSetIn = "";
            if (Character.isWhitespace(c)) {
                if (!whitesp) {
                    whitesp = true;
                    if (this.col >= 65 && lastWhCol > 65) {
                        if (this.sb.charAt(this.sb.length() - it.getIndex() + lastWh - 1) != '\n') {
                            this.sb.delete(this.sb.length() - it.getIndex() + lastWh, this.sb.length());
                            it.setIndex(lastWh);
                        }
                        this.col = 0;
                        toSetIn = "\n\t";
                    } else {
                        lastWh = it.getIndex();
                        lastWhCol = this.col++;
                        toSetIn = " ";
                    }
                } else {
                    ++lastWh;
                }
            } else {
                toSetIn = "" + c;
                whitesp = false;
                ++this.col;
            }
            this.sb.append(toSetIn);
            if (it.getIndex() < it.getEndIndex() - 1) {
                c = it.next();
                Util.pr("'" + c + "'");
                continue;
            }
            cont = false;
        }
    }

    private void checkBraces(String text) throws IllegalArgumentException {
        Vector<Integer> left = new Vector<Integer>(5, 3);
        Vector<Integer> right = new Vector<Integer>(5, 3);
        int current = -1;
        while ((current = text.indexOf(123, current + 1)) != -1) {
            left.add(new Integer(current));
        }
        while ((current = text.indexOf(125, current + 1)) != -1) {
            right.add(new Integer(current));
        }
        if (right.size() > 0 && left.size() == 0) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (right.size() > 0 && (Integer)right.elementAt(0) < (Integer)left.elementAt(0)) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (left.size() != right.size()) {
            throw new IllegalArgumentException("Braces don't match.");
        }
        if (left.size() == 0) {
            return;
        }
    }
}

