/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.FontSelectorDialog;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.PrefsTab;
import jabref.Util;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class TablePrefsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private String[] _choices;
    private Boolean[] _sel;
    private JCheckBox colorCodes;
    private JCheckBox autoResizeMode;
    private JCheckBox secDesc;
    private JCheckBox terDesc;
    private JCheckBox namesAsIs;
    private JCheckBox namesFf;
    private JCheckBox namesFl;
    private JCheckBox antialias;
    private JCheckBox pdfColumn;
    private JCheckBox urlColumn;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private JComboBox secSort = new JComboBox<String>(GUIGlobals.ALL_FIELDS);
    private JComboBox terSort = new JComboBox<String>(GUIGlobals.ALL_FIELDS);
    private JTextArea tableFields = new JTextArea();
    private JTextField secField;
    private JTextField terField;
    private JButton fontButton = new JButton(Globals.lang("Set table font"));
    private boolean tableChanged = false;
    private JTable colSetup;
    private int rowCount = -1;
    private int ncWidth = -1;
    private Vector tableRows = new Vector(10);
    private Font font = GUIGlobals.CURRENTFONT;
    private JabRefFrame frame;

    public TablePrefsTab(JabRefPreferences prefs2, JabRefFrame frame) {
        this._prefs = prefs2;
        this.frame = frame;
        this.setLayout(this.gbl);
        this.colorCodes = new JCheckBox(Globals.lang("Color codes for required and optional fields"), this._prefs.getBoolean("tableColorCodesOn"));
        this.antialias = new JCheckBox(Globals.lang("Use antialiasing font"), this._prefs.getBoolean("antialias"));
        this.autoResizeMode = new JCheckBox(Globals.lang("Fit table horizontally on screen"), this._prefs.getInt("autoResizeMode") == 4);
        this.namesAsIs = new JCheckBox(Globals.lang("Show names unchanged"));
        this.namesFf = new JCheckBox(Globals.lang("Show 'Firstname Lastname'"));
        this.namesFl = new JCheckBox(Globals.lang("Show 'Lastname, Firstname'"));
        this.pdfColumn = new JCheckBox(Globals.lang("Show PDF/PS column"), this._prefs.getBoolean("pdfColumn"));
        this.urlColumn = new JCheckBox(Globals.lang("Show URL/DOI column"), this._prefs.getBoolean("urlColumn"));
        this.secField = new JTextField(this._prefs.get("secSort"), 10);
        this.terField = new JTextField(this._prefs.get("terSort"), 10);
        this.secSort.insertItemAt(Globals.lang("<select>"), 0);
        this.terSort.insertItemAt(Globals.lang("<select>"), 0);
        this.secSort.setSelectedIndex(0);
        this.terSort.setSelectedIndex(0);
        this.secSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TablePrefsTab.this.secSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.secField.setText(GUIGlobals.ALL_FIELDS[TablePrefsTab.this.secSort.getSelectedIndex() - 1]);
                    TablePrefsTab.this.secSort.setSelectedIndex(0);
                }
            }
        });
        this.terSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TablePrefsTab.this.terSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.terField.setText(GUIGlobals.ALL_FIELDS[TablePrefsTab.this.terSort.getSelectedIndex() - 1]);
                    TablePrefsTab.this.terSort.setSelectedIndex(0);
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.namesAsIs);
        bg.add(this.namesFf);
        bg.add(this.namesFl);
        if (this._prefs.getBoolean("namesAsIs")) {
            this.namesAsIs.setSelected(true);
        } else if (this._prefs.getBoolean("namesFf")) {
            this.namesFf.setSelected(true);
        } else {
            this.namesFl.setSelected(true);
        }
        this.secDesc = new JCheckBox(Globals.lang("Descending"), this._prefs.getBoolean("secDescending"));
        this.terDesc = new JCheckBox(Globals.lang("Descending"), this._prefs.getBoolean("terDescending"));
        this.tableFields.setText(Util.stringArrayToDelimited(this._prefs.getStringArray("columnNames"), ";"));
        String[] names = this._prefs.getStringArray("columnNames");
        String[] lengths = this._prefs.getStringArray("columnWidths");
        for (int i = 0; i < names.length; ++i) {
            if (i < lengths.length) {
                this.tableRows.add(new TableRow(names[i], Integer.parseInt(lengths[i])));
                continue;
            }
            this.tableRows.add(new TableRow(names[i]));
        }
        this.rowCount = this.tableRows.size() + 5;
        this.ncWidth = prefs2.getInt("numberColWidth");
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TablePrefsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row == 0) {
                    return column == 0 ? GUIGlobals.NUMBER_COL : "" + TablePrefsTab.this.ncWidth;
                }
                if (--row >= TablePrefsTab.this.tableRows.size()) {
                    return "";
                }
                Object rowContent = TablePrefsTab.this.tableRows.elementAt(row);
                if (rowContent == null) {
                    return "";
                }
                TableRow tr = (TableRow)rowContent;
                switch (column) {
                    case 0: {
                        return tr.name;
                    }
                    case 1: {
                        return tr.length > 0 ? new Integer(tr.length).toString() : "";
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int col) {
                return col == 0 ? Globals.lang("Field name") : Globals.lang("Column width");
            }

            public Class getColumnClass(int column) {
                if (column == 0) {
                    return String.class;
                }
                return Integer.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return row != 0 || col != 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                TablePrefsTab.this.tableChanged = true;
                while (row >= TablePrefsTab.this.tableRows.size()) {
                    TablePrefsTab.this.tableRows.add(new TableRow("", -1));
                }
                if (row == 0 && col == 1) {
                    TablePrefsTab.this.ncWidth = Integer.parseInt(value.toString());
                    return;
                }
                TableRow rowContent = (TableRow)TablePrefsTab.this.tableRows.elementAt(row - 1);
                if (col == 0) {
                    rowContent.name = value.toString();
                    if (((String)this.getValueAt(row, 1)).equals("")) {
                        this.setValueAt("" + GUIGlobals.DEFAULT_FIELD_LENGTH, row, 1);
                    }
                } else {
                    rowContent.length = value == null ? -1 : Integer.parseInt(value.toString());
                }
            }
        };
        this.colSetup = new JTable(tm);
        TableColumnModel cm = this.colSetup.getColumnModel();
        cm.getColumn(0).setPreferredWidth(140);
        cm.getColumn(1).setPreferredWidth(80);
        JPanel upper = new JPanel();
        JPanel sort = new JPanel();
        JPanel namesp = new JPanel();
        upper.setLayout(this.gbl);
        sort.setLayout(this.gbl);
        namesp.setLayout(this.gbl);
        upper.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Table appearance")));
        sort.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Sort options")));
        namesp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Format of author and editor names")));
        this.con.gridwidth = 0;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.colorCodes, this.con);
        upper.add(this.colorCodes);
        this.gbl.setConstraints(this.autoResizeMode, this.con);
        upper.add(this.autoResizeMode);
        this.gbl.setConstraints(this.antialias, this.con);
        upper.add(this.antialias);
        this.gbl.setConstraints(this.pdfColumn, this.con);
        upper.add(this.pdfColumn);
        this.gbl.setConstraints(this.urlColumn, this.con);
        upper.add(this.urlColumn);
        this.con.anchor = 13;
        this.gbl.setConstraints(this.fontButton, this.con);
        upper.add(this.fontButton);
        this.con.anchor = 17;
        this.con.fill = 1;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(upper, this.con);
        this.add(upper);
        this.con.gridwidth = 0;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.namesAsIs, this.con);
        namesp.add(this.namesAsIs);
        this.gbl.setConstraints(this.namesFf, this.con);
        namesp.add(this.namesFf);
        this.gbl.setConstraints(this.namesFl, this.con);
        namesp.add(this.namesFl);
        this.con.fill = 1;
        this.gbl.setConstraints(namesp, this.con);
        this.add(namesp);
        JLabel lab = new JLabel(Globals.lang("Secondary sort criterion"));
        this.con.gridwidth = 1;
        this.con.insets = new Insets(0, 5, 0, 0);
        this.gbl.setConstraints(lab, this.con);
        sort.add(lab);
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.secSort, this.con);
        sort.add(this.secSort);
        this.gbl.setConstraints(this.secField, this.con);
        sort.add(this.secField);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.secDesc, this.con);
        sort.add(this.secDesc);
        this.con.gridwidth = 1;
        lab = new JLabel(Globals.lang("Tertiary sort criterion"));
        this.gbl.setConstraints(lab, this.con);
        sort.add(lab);
        this.con.weightx = 0.0;
        this.gbl.setConstraints(this.terSort, this.con);
        sort.add(this.terSort);
        this.gbl.setConstraints(this.terField, this.con);
        sort.add(this.terField);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.terDesc, this.con);
        sort.add(this.terDesc);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(sort, this.con);
        this.add(sort);
        JPanel tabPanel = new JPanel();
        this.gbl.setConstraints(tabPanel, this.con);
        this.add(tabPanel);
        tabPanel.setBorder(BorderFactory.createEtchedBorder());
        tabPanel.setLayout(this.gbl);
        JScrollPane sp = new JScrollPane(this.colSetup, 20, 31);
        this.colSetup.setPreferredScrollableViewportSize(new Dimension(250, 200));
        sp.setMinimumSize(new Dimension(250, 300));
        this.con.gridwidth = 1;
        this.con.weighty = 1.0;
        this.con.weightx = 0.0;
        this.con.fill = 1;
        this.con.anchor = 18;
        this.gbl.setConstraints(sp, this.con);
        tabPanel.add(sp);
        tabPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Visible fields")));
        JToolBar tlb = new JToolBar(1);
        tlb.setFloatable(false);
        AddRowAction ara = new AddRowAction();
        DeleteRowAction dra = new DeleteRowAction();
        tlb.add(ara);
        tlb.add(dra);
        tlb.addSeparator();
        tlb.add(new UpdateWidthsAction());
        this.gbl.setConstraints(tlb, this.con);
        tabPanel.add(tlb);
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f = new FontSelectorDialog(null, GUIGlobals.CURRENTFONT).getSelectedFont();
                if (f == null) {
                    return;
                }
                TablePrefsTab.this.font = f;
            }
        });
    }

    private String[] getChoices() {
        int count = 0;
        for (int i = 0; i < this._sel.length; ++i) {
            if (!this._sel[i].booleanValue()) continue;
            ++count;
        }
        String[] choices = new String[count];
        count = 0;
        for (int i = 0; i < this._sel.length; ++i) {
            if (!this._sel[i].booleanValue()) continue;
            choices[count] = GUIGlobals.ALL_FIELDS[i];
            ++count;
        }
        return choices;
    }

    @Override
    public void storeSettings() {
        if (this.colSetup.isEditing()) {
            int col = this.colSetup.getEditingColumn();
            int row = this.colSetup.getEditingRow();
            this.colSetup.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged) {
            int i = 0;
            while (i < this.tableRows.size()) {
                if (((TableRow)this.tableRows.elementAt((int)i)).name.equals("")) {
                    this.tableRows.removeElementAt(i);
                    continue;
                }
                ++i;
            }
            String[] names = new String[this.tableRows.size()];
            String[] widths = new String[this.tableRows.size()];
            int[] nWidths = new int[this.tableRows.size()];
            this._prefs.putInt("numberColWidth", this.ncWidth);
            for (i = 0; i < this.tableRows.size(); ++i) {
                TableRow tr = (TableRow)this.tableRows.elementAt(i);
                names[i] = tr.name;
                nWidths[i] = tr.length;
                widths[i] = "" + tr.length;
            }
            this._prefs.putStringArray("columnNames", names);
            this._prefs.putStringArray("columnWidths", widths);
        }
        this._prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this._prefs.putBoolean("namesAsIs", this.namesAsIs.isSelected());
        this._prefs.putBoolean("namesFf", this.namesFf.isSelected());
        this._prefs.putBoolean("antialias", this.antialias.isSelected());
        this._prefs.putBoolean("pdfColumn", this.pdfColumn.isSelected());
        this._prefs.putBoolean("urlColumn", this.urlColumn.isSelected());
        this._prefs.putInt("autoResizeMode", this.autoResizeMode.isSelected() ? 4 : 0);
        this._prefs.putBoolean("secDescending", this.secDesc.isSelected());
        this._prefs.putBoolean("terDescending", this.terDesc.isSelected());
        this._prefs.put("secSort", this.secField.getText().toLowerCase().trim());
        this._prefs.put("terSort", this.terField.getText().toLowerCase().trim());
        this._prefs.put("fontFamily", this.font.getFamily());
        this._prefs.putInt("fontStyle", this.font.getStyle());
        this._prefs.putInt("fontSize", this.font.getSize());
        GUIGlobals.CURRENTFONT = this.font;
    }

    class TableRow {
        String name;
        int length;

        public TableRow(String name) {
            this.name = name;
            this.length = GUIGlobals.DEFAULT_FIELD_LENGTH;
        }

        public TableRow(int length) {
            this.length = length;
            this.name = "";
        }

        public TableRow(String name, int length) {
            this.name = name;
            this.length = length;
        }
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", new ImageIcon(GUIGlobals.addIconFile));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = TablePrefsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                TablePrefsTab.this.rowCount++;
                TablePrefsTab.this.colSetup.revalidate();
                TablePrefsTab.this.colSetup.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i >= TablePrefsTab.this.tableRows.size()) continue;
                TablePrefsTab.this.tableRows.add(Math.max(1, rows[i] + i), new TableRow(GUIGlobals.DEFAULT_FIELD_LENGTH));
            }
            TablePrefsTab.this.rowCount += rows.length;
            if (rows.length > 1) {
                TablePrefsTab.this.colSetup.clearSelection();
            }
            TablePrefsTab.this.colSetup.revalidate();
            TablePrefsTab.this.colSetup.repaint();
            TablePrefsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", new ImageIcon(GUIGlobals.delRowIconFile));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = TablePrefsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            int offs = 0;
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] - i >= TablePrefsTab.this.tableRows.size() || rows[i] == 0) continue;
                TablePrefsTab.this.tableRows.remove(rows[i] - 1 - offs);
                ++offs;
            }
            TablePrefsTab.this.rowCount -= offs;
            if (rows.length > 1) {
                TablePrefsTab.this.colSetup.clearSelection();
            }
            TablePrefsTab.this.colSetup.revalidate();
            TablePrefsTab.this.colSetup.repaint();
            TablePrefsTab.this.tableChanged = true;
        }
    }

    class UpdateWidthsAction
    extends AbstractAction {
        public UpdateWidthsAction() {
            super("Add row", new ImageIcon(GUIGlobals.sheetIcon));
            this.putValue("ShortDescription", Globals.lang("Update to current column widths"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasePanel panel = TablePrefsTab.this.frame.basePanel();
            if (panel == null) {
                return;
            }
            TableColumnModel colMod = panel.entryTable.getColumnModel();
            TablePrefsTab.this.colSetup.setValueAt("" + colMod.getColumn(0).getWidth(), 0, 1);
            for (int i = 1; i < colMod.getColumnCount(); ++i) {
                block6: {
                    try {
                        String name = panel.entryTable.getColumnName(i).toLowerCase();
                        int width = colMod.getColumn(i).getWidth();
                        if (i <= TablePrefsTab.this.tableRows.size() && ((String)TablePrefsTab.this.colSetup.getValueAt(i, 0)).toLowerCase().equals(name)) {
                            TablePrefsTab.this.colSetup.setValueAt("" + width, i, 1);
                            break block6;
                        }
                        for (int j = 0; j < TablePrefsTab.this.colSetup.getRowCount(); ++j) {
                            if (j >= TablePrefsTab.this.tableRows.size() || !((String)TablePrefsTab.this.colSetup.getValueAt(j, 0)).toLowerCase().equals(name)) continue;
                            TablePrefsTab.this.colSetup.setValueAt("" + width, j, 1);
                            break;
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                TablePrefsTab.this.colSetup.revalidate();
                TablePrefsTab.this.colSetup.repaint();
            }
        }
    }
}

