/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.Globals;
import jabref.MetaData;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RightClickMenu
extends JPopupMenu
implements PopupMenuListener {
    BasePanel panel;
    MetaData metaData;
    JMenu groupMenu = new JMenu(Globals.lang("Add to group"));
    JMenu groupRemoveMenu = new JMenu(Globals.lang("Remove from group"));
    JMenu typeMenu = new JMenu(Globals.lang("Change entry type"));

    public RightClickMenu(BasePanel panel_, MetaData metaData_) {
        this.panel = panel_;
        this.metaData = metaData_;
        boolean multiple = this.panel.entryTable.getSelectedRowCount() > 1;
        BibtexEntry be = null;
        if (this.panel.entryTable.getSelectedRowCount() == 1) {
            be = this.panel.entryTable.getSelectedEntries()[0];
        }
        this.addPopupMenuListener(this);
        this.add(new AbstractAction(Globals.lang("Copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copy");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("paste");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Cut")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("cut");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        if (multiple) {
            this.add(new AbstractAction(Globals.lang("Mark entries")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RightClickMenu.this.panel.runCommand("markEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.add(new AbstractAction(Globals.lang("Unmark entries")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RightClickMenu.this.panel.runCommand("unmarkEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.addSeparator();
        } else if (be != null) {
            if (be.getField("__markedentry") == null) {
                this.add(new AbstractAction(Globals.lang("Mark entry")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            RightClickMenu.this.panel.runCommand("markEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.add(new AbstractAction(Globals.lang("Unmark entry")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            RightClickMenu.this.panel.runCommand("unmarkEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            this.addSeparator();
        }
        this.add(new AbstractAction(Globals.lang("Open PDF or PS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("openFile");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Open URL or DOI")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("openUrl");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy BibTeX key")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copyKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy \\cite{BibTeX key}")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RightClickMenu.this.panel.runCommand("copyCiteKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.populateTypeMenu();
        this.add(this.typeMenu);
        this.addSeparator();
        this.add(this.groupMenu);
        this.add(this.groupRemoveMenu);
    }

    public void populateTypeMenu() {
        this.typeMenu.removeAll();
        Iterator i = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (i.hasNext()) {
            this.typeMenu.add(new ChangeTypeAction(BibtexEntryType.getType((String)i.next())));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Vector groups = this.metaData.getData("groups");
        if (groups == null) {
            this.groupMenu.setEnabled(false);
            this.groupRemoveMenu.setEnabled(false);
            return;
        }
        this.groupMenu.setEnabled(true);
        this.groupRemoveMenu.setEnabled(true);
        this.groupMenu.removeAll();
        this.groupRemoveMenu.removeAll();
        for (int i = 0; i < groups.size() - 2; i += 3) {
            String name = (String)groups.elementAt(i + 1);
            String regexp = (String)groups.elementAt(i + 2);
            String field = (String)groups.elementAt(i);
            this.groupMenu.add(new AddToGroupAction(name, regexp, field));
            this.groupRemoveMenu.add(new RemoveFromGroupAction(name, regexp, field));
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    class ChangeTypeAction
    extends AbstractAction {
        BibtexEntryType type;

        public ChangeTypeAction(BibtexEntryType type) {
            super(type.getName());
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RightClickMenu.this.panel.changeType(this.type);
        }
    }

    class AddToGroupAction
    extends AbstractAction {
        String grp;
        String regexp;
        String field;

        public AddToGroupAction(String grp, String regexp, String field) {
            super(grp);
            this.grp = grp;
            this.regexp = regexp;
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RightClickMenu.this.panel.addToGroup(this.grp, this.regexp, this.field);
        }
    }

    class RemoveFromGroupAction
    extends AbstractAction {
        String grp;
        String regexp;
        String field;

        public RemoveFromGroupAction(String grp, String regexp, String field) {
            super(grp);
            this.grp = grp;
            this.regexp = regexp;
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RightClickMenu.this.panel.removeFromGroup(this.grp, this.regexp, this.field);
        }
    }
}

