/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MetaData {
    private HashMap metaData = new HashMap();
    private StringReader data;

    public MetaData(HashMap inData) {
        this();
        for (String key : inData.keySet()) {
            this.data = new StringReader((String)inData.get(key));
            Vector<String> orderedData = new Vector<String>();
            try {
                String unit;
                while ((unit = this.getNextUnit(this.data)) != null) {
                    orderedData.add(unit);
                }
            }
            catch (IOException ex) {
                System.err.println("Weird error while parsing meta data.");
            }
            this.metaData.put(key, orderedData);
        }
    }

    public MetaData() {
        this.metaData.put("selector_keywords", new Vector());
        this.metaData.put("selector_journal", new Vector());
        this.metaData.put("selector_publisher", new Vector());
    }

    public Iterator iterator() {
        return this.metaData.keySet().iterator();
    }

    public Vector getData(String key) {
        return (Vector)this.metaData.get(key);
    }

    public void putData(String key, Vector orderedData) {
        this.metaData.put(key, orderedData);
    }

    public void writeMetaData(Writer out) throws IOException {
        for (String key : this.metaData.keySet()) {
            Vector orderedData = (Vector)this.metaData.get(key);
            out.write("@comment{" + GUIGlobals.META_FLAG + key + ":");
            for (int j = 0; j < orderedData.size(); ++j) {
                out.write(this.makeEscape((String)orderedData.elementAt(j)) + ";");
            }
            out.write("}\n\n");
        }
    }

    private String getNextUnit(Reader data) throws IOException {
        int c;
        boolean escape = false;
        boolean done = false;
        StringBuffer res = new StringBuffer();
        while (!done && (c = data.read()) != -1) {
            if (c == 92) {
                if (!escape) {
                    escape = true;
                    continue;
                }
                escape = false;
                res.append('\\');
                continue;
            }
            if (c == 59) {
                if (!escape) {
                    done = true;
                } else {
                    res.append(';');
                }
            } else {
                res.append((char)c);
            }
            escape = false;
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return null;
    }

    private String makeEscape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

