/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.GUIGlobals;
import jabref.Globals;
import jabref.HelpContent;
import jabref.JabRefFrame;
import jabref.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private JabRefFrame frame;
    private HelpContent content;
    private BackAction back = new BackAction();
    private ForwardAction forward = new ForwardAction();
    private ContentsAction contents = new ContentsAction();

    public HelpDialog(JabRefFrame bf) {
        super(bf, Globals.lang("JabRef help"), false);
        this.frame = bf;
        this.content = new HelpContent(bf.prefs);
        this.content.addHyperlinkListener(this);
        this.setSize(GUIGlobals.helpSize);
        JToolBar tlb = new JToolBar();
        tlb.add(this.back);
        tlb.add(this.forward);
        tlb.addSeparator();
        tlb.add(this.contents);
        tlb.setFloatable(false);
        InputMap im = tlb.getInputMap(2);
        ActionMap am = tlb.getActionMap();
        im.put(GUIGlobals.exitDialog, "close");
        am.put("close", new CloseAction());
        im.put(GUIGlobals.switchPanelLeft, "left");
        am.put("left", this.back);
        im.put(GUIGlobals.switchPanelRight, "right");
        am.put("right", this.forward);
        im = this.content.getInputMap(0);
        am = this.content.getActionMap();
        im.put(GUIGlobals.switchPanelLeft, "left");
        am.put("left", this.back);
        im.put(GUIGlobals.switchPanelRight, "right");
        am.put("right", this.forward);
        this.getContentPane().add((Component)tlb, "North");
        this.getContentPane().add(this.content.getPane());
        this.forward.setEnabled(false);
        this.back.setEnabled(false);
    }

    public void showPage(String url) {
        if (!this.isVisible()) {
            Util.placeDialog(this, this.frame);
            this.setVisible(true);
            this.content.reset();
            this.forward.setEnabled(false);
            this.back.setEnabled(false);
        } else {
            this.setVisible(true);
            this.forward.setEnabled(false);
            this.back.setEnabled(true);
        }
        this.content.setPage(url);
        this.content.requestFocus();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.content.setPage(e.getURL());
            this.back.setEnabled(true);
            this.forward.setEnabled(false);
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back", new ImageIcon(GUIGlobals.backIconFile));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(HelpDialog.this.content.back());
            HelpDialog.this.forward.setEnabled(true);
        }
    }

    class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward", new ImageIcon(GUIGlobals.forwardIconFile));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(HelpDialog.this.content.forward());
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class ContentsAction
    extends AbstractAction {
        public ContentsAction() {
            super("Contents", new ImageIcon(GUIGlobals.contentsIconFile));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog.this.content.setPage(GUIGlobals.helpContents);
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close"));
            this.putValue("ShortDescription", Globals.lang("Close the help window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog.this.dispose();
        }
    }
}

