/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntryType;
import jabref.GlobalFocusListener;
import jabref.JabRefFileChooser;
import jabref.JabRefPreferences;
import jabref.OpenFileFilter;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Globals {
    static int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static String resourcePrefix = "jabref/resource/JabRef";
    private static String logfile = "jabref.log";
    public static ResourceBundle messages;
    public static Locale locale;
    public static final String FILETYPE_PREFS_EXT = "_dir";
    public static final String SELECTOR_META_PREFIX = "selector_";
    public static final String LAYOUT_PREFIX = "/jabref/resource/layout/";
    public static final String MAC = "Mac OS X";
    public static final String DOI_LOOKUP_PREFIX = "http://dx.doi.org/";
    public static final String NONE = "_non__";
    public static float duplicateThreshold;
    public static GlobalFocusListener focusListener;
    public static String osName;
    public static boolean ON_MAC;
    public static boolean ON_WIN;
    public static final String KEY_FIELD = "bibtexkey";
    public static final String SEARCH = "__search";
    public static final String GROUPSEARCH = "__groupsearch";
    public static final String MARKED = "__markedentry";
    public static final String OWNER = "owner";
    public static final String DEFAULT_BIBTEXENTRY_ID = "__ID";
    static Pattern titleCapitalPattern;
    public static HashMap HTML_CHARS;

    public static void logger(String s) {
        Logger.global.info(s);
    }

    public static void turnOffLogging() {
        Logger.global.setLevel(Level.SEVERE);
    }

    public static void turnOnConsoleLogging() {
        Logger.global.addHandler(new ConsoleHandler());
    }

    public static void turnOnFileLogging() {
        StreamHandler handler;
        Logger.global.setLevel(Level.ALL);
        try {
            handler = new FileHandler(logfile);
        }
        catch (IOException e) {
            handler = new ConsoleHandler();
        }
        Logger.global.addHandler(handler);
        handler.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return true;
            }
        });
    }

    public static void setLanguage(String language, String country) {
        locale = new Locale(language, country);
        messages = ResourceBundle.getBundle(resourcePrefix, locale);
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
    }

    public static String lang(String key) {
        String translation = null;
        try {
            if (messages != null) {
                translation = messages.getString(key.replaceAll(" ", "_"));
            }
        }
        catch (MissingResourceException ex) {
            translation = key;
        }
        if (translation != null) {
            return translation.replaceAll("_", " ");
        }
        return null;
    }

    public static BibtexEntryType getEntryType(String type) {
        Object o = BibtexEntryType.ALL_TYPES.get(type);
        if (o != null) {
            return (BibtexEntryType)o;
        }
        return BibtexEntryType.OTHER;
    }

    public static String putBracesAroundCapitals(String title) {
        StringBuffer buf = new StringBuffer();
        Matcher mcr = titleCapitalPattern.matcher(title.substring(1));
        boolean found = false;
        while (found = mcr.find()) {
            String replaceStr = mcr.group();
            mcr.appendReplacement(buf, "{" + replaceStr + "}");
        }
        mcr.appendTail(buf);
        String titleCap = title.substring(0, 1) + buf.toString();
        return titleCap;
    }

    public static String getNewFile(JFrame owner, JabRefPreferences prefs2, File directory, String extension, int dialogType, boolean updateWorkingDirectory) {
        return Globals.getNewFile(owner, prefs2, directory, extension, dialogType, updateWorkingDirectory, false);
    }

    public static String getNewDir(JFrame owner, JabRefPreferences prefs2, File directory, String extension, int dialogType, boolean updateWorkingDirectory) {
        return Globals.getNewFile(owner, prefs2, directory, extension, dialogType, updateWorkingDirectory, true);
    }

    private static String getNewFile(JFrame owner, JabRefPreferences prefs2, File directory, String extension, int dialogType, boolean updateWorkingDirectory, boolean dirOnly) {
        OpenFileFilter off = null;
        if (extension == null) {
            off = new OpenFileFilter();
        } else if (!extension.equals(NONE)) {
            off = new OpenFileFilter(extension);
        }
        if (ON_MAC) {
            return Globals.getNewFileForMac(owner, prefs2, directory, extension, dialogType, updateWorkingDirectory, dirOnly, off);
        }
        JabRefFileChooser fc = new JabRefFileChooser(directory);
        if (dirOnly) {
            fc.setFileSelectionMode(1);
        }
        fc.addChoosableFileFilter(off);
        fc.setDialogType(dialogType);
        if (dialogType == 0) {
            fc.showOpenDialog(null);
        } else {
            fc.showSaveDialog(null);
        }
        File selectedFile = fc.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        if (dialogType == 1 && fc.getFileFilter() == off && !selectedFile.getPath().endsWith(extension)) {
            selectedFile = new File(selectedFile.getPath() + extension);
        }
        if (updateWorkingDirectory) {
            prefs2.put("workingDirectory", selectedFile.getPath());
        }
        return selectedFile.getAbsolutePath();
    }

    private static String getNewFileForMac(JFrame owner, JabRefPreferences prefs2, File directory, String extensions, int dialogType, boolean updateWorkingDirectory, boolean dirOnly, FilenameFilter filter) {
        FileDialog fc = new FileDialog(owner);
        if (directory != null) {
            fc.setDirectory(directory.getParent());
        }
        if (dialogType == 0) {
            fc.setMode(0);
        } else {
            fc.setMode(1);
        }
        fc.setVisible(true);
        if (fc.getFile() != null) {
            prefs2.put("workingDirectory", fc.getDirectory() + fc.getFile());
            return fc.getDirectory() + fc.getFile();
        }
        return null;
    }

    static {
        duplicateThreshold = 0.75f;
        focusListener = new GlobalFocusListener();
        osName = System.getProperty("os.name", "def");
        ON_MAC = osName.equals(MAC);
        ON_WIN = osName.startsWith("Windows");
        titleCapitalPattern = Pattern.compile("[A-Z]+");
        HTML_CHARS = new HashMap();
        HTML_CHARS.put("\\{\\\\\\\"\\{a\\}\\}", "&auml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{A\\}\\}", "&Auml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{e\\}\\}", "&euml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{E\\}\\}", "&Euml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{i\\}\\}", "&iuml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{I\\}\\}", "&Iuml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{o\\}\\}", "&ouml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{O\\}\\}", "&Ouml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{u\\}\\}", "&uuml;");
        HTML_CHARS.put("\\{\\\\\\\"\\{U\\}\\}", "&Uuml;");
        HTML_CHARS.put("\\{\\\\\\`\\{e\\}\\}", "&egrave;");
        HTML_CHARS.put("\\{\\\\\\`\\{E\\}\\}", "&Egrave;");
        HTML_CHARS.put("\\{\\\\\\`\\{i\\}\\}", "&igrave;");
        HTML_CHARS.put("\\{\\\\\\`\\{I\\}\\}", "&Igrave;");
        HTML_CHARS.put("\\{\\\\\\`\\{o\\}\\}", "&ograve;");
        HTML_CHARS.put("\\{\\\\\\`\\{O\\}\\}", "&Ograve;");
        HTML_CHARS.put("\\{\\\\\\`\\{u\\}\\}", "&ugrave;");
        HTML_CHARS.put("\\{\\\\\\`\\{U\\}\\}", "&Ugrave;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{e\\}\\}", "&eacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{E\\}\\}", "&Eacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{i\\}\\}", "&iacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{I\\}\\}", "&Iacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{o\\}\\}", "&oacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{O\\}\\}", "&Oacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{u\\}\\}", "&uacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{U\\}\\}", "&Uacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{a\\}\\}", "&aacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffd\\{A\\}\\}", "&Aacute;");
        HTML_CHARS.put("\\{\\\\\\^\\{o\\}\\}", "&ocirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{O\\}\\}", "&Ocirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{u\\}\\}", "&ucirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{U\\}\\}", "&Ucirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{e\\}\\}", "&ecirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{E\\}\\}", "&Ecirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{i\\}\\}", "&icirc;");
        HTML_CHARS.put("\\{\\\\\\^\\{I\\}\\}", "&Icirc;");
        HTML_CHARS.put("\\{\\\\\\~\\{o\\}\\}", "&otilde;");
        HTML_CHARS.put("\\{\\\\\\~\\{O\\}\\}", "&Otilde;");
        HTML_CHARS.put("\\{\\\\\\~\\{n\\}\\}", "&ntilde;");
        HTML_CHARS.put("\\{\\\\\\~\\{N\\}\\}", "&Ntilde;");
        HTML_CHARS.put("\\{\\\\\\~\\{a\\}\\}", "&atilde;");
        HTML_CHARS.put("\\{\\\\\\~\\{A\\}\\}", "&Atilde;");
        HTML_CHARS.put("\\{\\\\\\\"a\\}", "&auml;");
        HTML_CHARS.put("\\{\\\\\\\"A\\}", "&Auml;");
        HTML_CHARS.put("\\{\\\\\\\"e\\}", "&euml;");
        HTML_CHARS.put("\\{\\\\\\\"E\\}", "&Euml;");
        HTML_CHARS.put("\\{\\\\\\\"i\\}", "&iuml;");
        HTML_CHARS.put("\\{\\\\\\\"I\\}", "&Iuml;");
        HTML_CHARS.put("\\{\\\\\\\"o\\}", "&ouml;");
        HTML_CHARS.put("\\{\\\\\\\"O\\}", "&Ouml;");
        HTML_CHARS.put("\\{\\\\\\\"u\\}", "&uuml;");
        HTML_CHARS.put("\\{\\\\\\\"U\\}", "&Uuml;");
        HTML_CHARS.put("\\{\\\\\\`e\\}", "&egrave;");
        HTML_CHARS.put("\\{\\\\\\`E\\}", "&Egrave;");
        HTML_CHARS.put("\\{\\\\\\`i\\}", "&igrave;");
        HTML_CHARS.put("\\{\\\\\\`I\\}", "&Igrave;");
        HTML_CHARS.put("\\{\\\\\\`o\\}", "&ograve;");
        HTML_CHARS.put("\\{\\\\\\`O\\}", "&Ograve;");
        HTML_CHARS.put("\\{\\\\\\`u\\}", "&ugrave;");
        HTML_CHARS.put("\\{\\\\\\`U\\}", "&Ugrave;");
        HTML_CHARS.put("\\{\\\\\\\ufffdA\\}", "&eacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdE\\}", "&Eacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdi\\}", "&iacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdI\\}", "&Iacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdo\\}", "&oacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdO\\}", "&Oacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdu\\}", "&uacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdU\\}", "&Uacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffda\\}", "&aacute;");
        HTML_CHARS.put("\\{\\\\\\\ufffdA\\}", "&Aacute;");
        HTML_CHARS.put("\\{\\\\\\^o\\}", "&ocirc;");
        HTML_CHARS.put("\\{\\\\\\^O\\}", "&Ocirc;");
        HTML_CHARS.put("\\{\\\\\\^u\\}", "&ucirc;");
        HTML_CHARS.put("\\{\\\\\\^U\\}", "&Ucirc;");
        HTML_CHARS.put("\\{\\\\\\^e\\}", "&ecirc;");
        HTML_CHARS.put("\\{\\\\\\^E\\}", "&Ecirc;");
        HTML_CHARS.put("\\{\\\\\\^i\\}", "&icirc;");
        HTML_CHARS.put("\\{\\\\\\^I\\}", "&Icirc;");
        HTML_CHARS.put("\\{\\\\\\~o\\}", "&otilde;");
        HTML_CHARS.put("\\{\\\\\\~O\\}", "&Otilde;");
        HTML_CHARS.put("\\{\\\\\\~n\\}", "&ntilde;");
        HTML_CHARS.put("\\{\\\\\\~N\\}", "&Ntilde;");
        HTML_CHARS.put("\\{\\\\\\~a\\}", "&atilde;");
        HTML_CHARS.put("\\{\\\\\\~A\\}", "&Atilde;");
        HTML_CHARS.put("\\{\\\\c c\\}", "&ccedil;");
        HTML_CHARS.put("\\{\\\\c C\\}", "&Ccedil;");
    }
}

