/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.FieldEditor;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FieldTextField
extends JTextField
implements FieldEditor {
    private static final long serialVersionUID = 1L;
    protected String fieldName;
    protected JLabel label;

    public FieldTextField(String fieldName_, String content) {
        super(content);
        this.addFocusListener(Globals.focusListener);
        this.fieldName = fieldName_;
        this.label = new JLabel(Util.nCase(this.fieldName), 0);
        this.label.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(GUIGlobals.validFieldBackground);
        this.label.setBorder(BorderFactory.createEtchedBorder(GUIGlobals.lightGray, Color.gray));
        this.label.setOpaque(true);
        this.label.setBackground(GUIGlobals.lightGray);
        if (content != null && content.length() > 0) {
            this.label.setForeground(GUIGlobals.validFieldColor);
        } else {
            this.label.setForeground(GUIGlobals.nullFieldColor);
        }
    }

    @Override
    public void append(String text) {
        this.setText(this.getText() + text);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color c) {
        this.label.setForeground(c);
    }

    @Override
    public JComponent getPane() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = g2.getRenderingHints();
        rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHints(rh);
        super.paintComponent(g2);
    }
}

