/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.ContentSelectorDialog;
import jabref.EntryEditor;
import jabref.FieldEditor;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.MetaData;
import jabref.Util;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class FieldContentSelector
extends JComponent
implements ItemListener {
    private static final long serialVersionUID = 1L;
    final String DELIMITER = " ";
    final String DELIMITER_2 = "";
    FieldEditor editor;
    JComboBox list = new JComboBox();
    JButton manage;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    EntryEditor parent;
    MetaData metaData;

    public FieldContentSelector(EntryEditor parent, FieldEditor editor_, MetaData data) {
        this.setLayout(this.gbl);
        this.editor = editor_;
        this.parent = parent;
        this.metaData = data;
        this.list.setEditable(true);
        final MetaData metaData = data;
        final JabRefFrame frame = parent.frame;
        this.updateList();
        this.list.setBackground(GUIGlobals.lightGray);
        this.con.gridwidth = 0;
        this.con.fill = 2;
        this.gbl.setConstraints(this.list, this.con);
        this.list.addItemListener(this);
        this.add(this.list);
        this.manage = new JButton(Globals.lang("Manage"));
        this.manage.setBackground(GUIGlobals.lightGray);
        this.gbl.setConstraints(this.manage, this.con);
        this.add(this.manage);
        this.manage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentSelectorDialog csd = new ContentSelectorDialog(frame, true, metaData, FieldContentSelector.this.editor.getFieldName());
                Util.placeDialog(csd, frame);
                csd.setVisible(true);
                FieldContentSelector.this.updateList();
            }
        });
    }

    private void updateList() {
        this.list.removeAllItems();
        this.list.addItem("");
        Vector items = this.metaData.getData("selector_" + this.editor.getFieldName());
        if (items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                this.list.addItem(items.elementAt(i));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.list.getSelectedIndex() == 0) {
            return;
        }
        String chosen = (String)this.list.getSelectedItem();
        if (this.list.getSelectedIndex() == -1) {
            Vector items = this.metaData.getData("selector_" + this.editor.getFieldName());
            boolean exists = false;
            int pos = -1;
            for (int i = 0; i < items.size(); ++i) {
                String s = (String)items.elementAt(i);
                if (s.equals(chosen)) {
                    exists = true;
                    break;
                }
                if (s.toLowerCase().compareTo(chosen.toLowerCase()) >= 0) continue;
                pos = i + 1;
            }
            if (!exists) {
                items.add(Math.max(0, pos), chosen);
                this.parent.panel.markNonUndoableBaseChanged();
                this.updateList();
            }
        }
        if (!this.editor.getText().equals("")) {
            this.editor.append(" ");
        }
        this.editor.append(chosen + "");
        this.list.setSelectedIndex(0);
        this.parent.storeFieldAction.actionPerformed(new ActionEvent(this.editor, 0, ""));
    }
}

