/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntryType;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class EntryTypeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    BibtexEntryType type = null;
    CancelAction cancelAction = new CancelAction();
    private final int COLNUM = 3;

    public EntryTypeDialog(JabRefFrame baseFrame_) {
        super((Frame)baseFrame_, true);
        this.setTitle("Select entry type");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EntryTypeDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel pan = new JPanel();
        this.getContentPane().add((Component)pan, "Center");
        JPanel lower = new JPanel();
        JButton cancel = new JButton(Globals.lang("Cancel"));
        cancel.addActionListener(this);
        pan.setBackground(GUIGlobals.lightGray);
        lower.setBackground(GUIGlobals.lightGray);
        cancel.getInputMap(2).put(GUIGlobals.exitDialog, "close");
        cancel.getActionMap().put("close", this.cancelAction);
        lower.add(cancel);
        this.getContentPane().add((Component)lower, "South");
        GridBagLayout gbl = new GridBagLayout();
        pan.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 2;
        con.insets = new Insets(4, 4, 4, 4);
        int col = 0;
        Iterator iter = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (iter.hasNext()) {
            BibtexEntryType tp = BibtexEntryType.getType((String)iter.next());
            TypeButton b = new TypeButton(Util.nCase(tp.getName()), tp);
            b.setAlignmentX(2.0f);
            b.addActionListener(this);
            if (++col == 3) {
                col = 0;
                con.gridwidth = 0;
            } else {
                con.gridwidth = 1;
            }
            gbl.setConstraints(b, con);
            pan.add(b);
        }
        pan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Entry types")));
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof TypeButton) {
            this.type = ((TypeButton)e.getSource()).type;
        }
        this.dispose();
    }

    public BibtexEntryType getChoice() {
        return this.type;
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntryTypeDialog.this.dispose();
        }
    }

    class TypeButton
    extends JButton
    implements Comparable {
        BibtexEntryType type;

        public TypeButton(String label, BibtexEntryType type_) {
            super(label);
            this.type = type_;
        }

        public int compareTo(Object o) {
            if (!(o instanceof TypeButton)) {
                throw new ClassCastException();
            }
            return this.type.getName().compareTo(((TypeButton)o).type.getName());
        }
    }
}

