/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BibtexEntry;
import jabref.Globals;
import jabref.JabRefFrame;
import jabref.PreviewPanel;
import jabref.Util;
import jabref.export.LatexFieldFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DuplicateResolverDialog
extends JDialog {
    public static final int KEEP_BOTH = 0;
    public static final int KEEP_UPPER = 1;
    public static final int KEEP_LOWER = 2;
    final Dimension DIM = new Dimension(650, 450);
    PreviewPanel p1;
    PreviewPanel p2;
    JTextArea ta1;
    JTextArea ta2;
    JTabbedPane tabbed = new JTabbedPane();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton first = new JButton(Globals.lang("Keep upper"));
    JButton second = new JButton(Globals.lang("Keep lower"));
    JButton both = new JButton(Globals.lang("Keep both"));
    JPanel options = new JPanel();
    JPanel main = new JPanel();
    JPanel source = new JPanel();
    int status = 0;

    public DuplicateResolverDialog(JabRefFrame frame, BibtexEntry one, BibtexEntry two) {
        super(frame, Globals.lang("Possible duplicate entries"), true);
        this.p1 = new PreviewPanel(one);
        this.p2 = new PreviewPanel(two);
        this.ta1 = new JTextArea();
        this.ta2 = new JTextArea();
        this.ta1.setEditable(false);
        this.ta2.setEditable(false);
        this.setSourceView(one, two);
        this.main.setLayout(this.gbl);
        this.source.setLayout(this.gbl);
        this.con.insets = new Insets(10, 10, 10, 10);
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        JScrollPane sp = new JScrollPane(this.p1);
        this.gbl.setConstraints(sp, this.con);
        this.main.add(sp);
        sp = new JScrollPane(this.ta1);
        this.gbl.setConstraints(sp, this.con);
        this.source.add(sp);
        sp = new JScrollPane(this.p2);
        this.gbl.setConstraints(sp, this.con);
        this.main.add(sp);
        sp = new JScrollPane(this.ta2);
        this.gbl.setConstraints(sp, this.con);
        this.source.add(sp);
        this.tabbed.add(Globals.lang("Short form"), this.main);
        this.tabbed.add(Globals.lang("Complete record"), this.source);
        this.options.add(this.first);
        this.options.add(this.second);
        this.options.add(this.both);
        this.first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 1;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.second.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 2;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.both.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DuplicateResolverDialog.this.status = 0;
                DuplicateResolverDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.tabbed, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.setSize(this.DIM);
        this.both.requestFocus();
        Util.placeDialog(this, frame);
    }

    private void setSourceView(BibtexEntry one, BibtexEntry two) {
        try {
            StringWriter sw = new StringWriter();
            one.write(sw, new LatexFieldFormatter(), false);
            this.ta1.setText(sw.getBuffer().toString());
            sw = new StringWriter();
            two.write(sw, new LatexFieldFormatter(), false);
            this.ta2.setText(sw.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEntries(BibtexEntry newOne, BibtexEntry newTwo) {
        this.setSourceView(newOne, newTwo);
        this.p1.setEntry(newOne);
        this.p2.setEntry(newTwo);
    }

    public int getSelected() {
        return this.status;
    }

    public static int resolveDuplicate(JabRefFrame frame, BibtexEntry one, BibtexEntry two) {
        DuplicateResolverDialog drd = new DuplicateResolverDialog(frame, one, two);
        drd.setVisible(true);
        return drd.getSelected();
    }
}

