/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table.filters;

import com.vlsolutions.swing.table.VLJTableFilter;

public class StartsWithFilter
implements VLJTableFilter {
    protected String filter = null;
    protected boolean ignoreCase = false;
    protected String lowerCaseFilter;

    public StartsWithFilter() {
    }

    public StartsWithFilter(String filter) {
        this.filter = filter;
    }

    public StartsWithFilter(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public StartsWithFilter(boolean ignoreCase, String filter) {
        this.ignoreCase = ignoreCase;
        this.setFilter(filter);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean accept(Object filterPattern) {
        if (this.filter == null) {
            return true;
        }
        if (this.ignoreCase) {
            return ((String)filterPattern).toLowerCase().startsWith(this.lowerCaseFilter);
        }
        return ((String)filterPattern).startsWith(this.filter);
    }

    @Override
    public void compile() {
        if (this.ignoreCase && this.filter != null) {
            this.lowerCaseFilter = this.filter.toLowerCase();
        }
    }

    @Override
    public void setFilter(Object value) {
        this.setFilter((String)value);
    }

    @Override
    public boolean isFiltering() {
        return this.filter != null && !this.filter.equals("");
    }
}

